/*
 * Decompiled with CFR 0.152.
 */
package net.vercte.extendedwrenches;

import com.mojang.logging.LogUtils;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.item.KineticStats;
import com.simibubi.create.foundation.item.TooltipModifier;
import net.createmod.catnip.lang.FontHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.vercte.extendedwrenches.ExtendedItems;
import net.vercte.extendedwrenches.ExtendedWrenchesData;
import net.vercte.extendedwrenches.ExtendedWrenchesRecipeSerializers;
import net.vercte.extendedwrenches.compat.ModCompat;
import net.vercte.extendedwrenches.wrench.ExtendedWrenchItem;
import org.slf4j.Logger;

@Mod(value="extendedwrenches")
public class ExtendedWrenches {
    public static final String ID = "extendedwrenches";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final CreateRegistrate REGISTRATE = ((CreateRegistrate)CreateRegistrate.create((String)"extendedwrenches").defaultCreativeTab((ResourceKey)null)).setTooltipModifierFactory(item -> new ItemDescription.Modifier(item, FontHelper.Palette.STANDARD_CREATE).andThen(TooltipModifier.mapNull((TooltipModifier)KineticStats.create((Item)item))));

    public ExtendedWrenches() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ExtendedItems.init();
        ExtendedWrenches.everyCompatModule();
        modEventBus.addListener(ExtendedWrenches::initExtra);
        modEventBus.addListener(ExtendedItems::addToCreative);
        modEventBus.addListener(ExtendedWrenchesData::registerDatapackRegistries);
        modEventBus.addListener(EventPriority.LOWEST, ExtendedWrenchesData::gatherData);
        ExtendedWrenchesRecipeSerializers.register(modEventBus);
        REGISTRATE.registerEventListeners(modEventBus);
    }

    public static void initExtra(FMLCommonSetupEvent event) {
        CauldronInteraction.f_175607_.put((Item)ExtendedItems.WRENCH.get(), (state, level, pos, player, hand, stack) -> {
            if (!stack.m_150930_((Item)ExtendedItems.WRENCH.get())) {
                return InteractionResult.PASS;
            }
            if (!ExtendedWrenchItem.hasCustomColor(stack)) {
                return InteractionResult.PASS;
            }
            if (!level.f_46443_) {
                ExtendedWrenchItem.clearColor(stack);
                player.m_36220_(Stats.f_12945_);
                LayeredCauldronBlock.m_153559_((BlockState)state, (Level)level, (BlockPos)pos);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        });
    }

    public static ResourceLocation asResource(String path) {
        return new ResourceLocation(ID, path);
    }

    private static void everyCompatModule() {
        try {
            if (ModList.get().isLoaded("everycomp")) {
                ModCompat.init();
                LOGGER.debug("Every Compat found, starting compatibility");
            } else {
                LOGGER.debug("Every Compat is not installed");
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to start EveryComp module", (Throwable)e);
        }
    }
}

