/*
 * Decompiled with CFR 0.152.
 */
package net.vercte.extendedwrenches.wrench;

import com.simibubi.create.AllItems;
import com.simibubi.create.content.equipment.wrench.WrenchItem;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModelRenderer;
import com.simibubi.create.foundation.item.render.SimpleCustomRenderer;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.vercte.extendedwrenches.ExtendedItems;
import net.vercte.extendedwrenches.wrench.ExtendedWrenchItemRenderer;
import net.vercte.extendedwrenches.wrench.WrenchPart;

public class ExtendedWrenchItem
extends WrenchItem {
    public static final String TAG_DISPLAY = "display";
    public static final String TAG_MATERIALS = "materials";
    public static final String TAG_MATERIAL_LOCATION = "location";
    private static final String TAG_GRIP_COLOR = "grip_color";
    private static final int DEFAULT_GRIP_COLOR = 13061958;

    public ExtendedWrenchItem(Item.Properties properties) {
        super(properties);
    }

    public static boolean hasCustomColor(ItemStack stack) {
        CompoundTag compoundtag = stack.m_41737_(TAG_DISPLAY);
        return compoundtag != null && compoundtag.m_128425_(TAG_GRIP_COLOR, 99);
    }

    public static int getColor(ItemStack stack) {
        CompoundTag display = stack.m_41737_(TAG_DISPLAY);
        return display != null && display.m_128425_(TAG_GRIP_COLOR, 99) ? display.m_128451_(TAG_GRIP_COLOR) : 13061958;
    }

    public static void setColor(ItemStack stack, int color) {
        stack.m_41698_(TAG_DISPLAY).m_128405_(TAG_GRIP_COLOR, color);
    }

    public static void clearColor(ItemStack stack) {
        CompoundTag display = stack.m_41737_(TAG_DISPLAY);
        if (display != null) {
            display.m_128473_(TAG_GRIP_COLOR);
        }
    }

    public static ItemStack dyeWrench(ItemStack stack, List<DyeItem> dyes) {
        ItemStack copiedWrench = ItemStack.f_41583_;
        int[] color = new int[3];
        int significant = 0;
        int amount = 0;
        Item item = stack.m_41720_();
        ExtendedWrenchItem wrench = null;
        if (item instanceof ExtendedWrenchItem) {
            wrench = (ExtendedWrenchItem)item;
            copiedWrench = stack.m_255036_(1);
            if (ExtendedWrenchItem.hasCustomColor(stack)) {
                int k = ExtendedWrenchItem.getColor(copiedWrench);
                float wR = (float)(k >> 16 & 0xFF) / 255.0f;
                float wG = (float)(k >> 8 & 0xFF) / 255.0f;
                float wB = (float)(k & 0xFF) / 255.0f;
                significant += (int)Math.max(wR, Math.max(wG, wB)) * 255;
                color[0] = color[0] + (int)(wR * 255.0f);
                color[1] = color[1] + (int)(wG * 255.0f);
                color[2] = color[2] + (int)(wB * 255.0f);
                ++amount;
            }
            for (DyeItem dyeitem : dyes) {
                float[] dyeColors = dyeitem.m_41089_().m_41068_();
                int dR = (int)(dyeColors[0] * 255.0f);
                int dG = (int)(dyeColors[1] * 255.0f);
                int dB = (int)(dyeColors[2] * 255.0f);
                significant += Math.max(dR, Math.max(dG, dB));
                color[0] = color[0] + dR;
                color[1] = color[1] + dG;
                color[2] = color[2] + dB;
                ++amount;
            }
        }
        if (wrench == null) {
            return ItemStack.f_41583_;
        }
        int aR = color[0] / amount;
        int aG = color[1] / amount;
        int aB = color[2] / amount;
        float f3 = (float)significant / (float)amount;
        float f4 = Math.max(aR, Math.max(aG, aB));
        aR = (int)((float)aR * f3 / f4);
        aG = (int)((float)aG * f3 / f4);
        aB = (int)((float)aB * f3 / f4);
        int j2 = (aR << 8) + aG;
        j2 = (j2 << 8) + aB;
        ExtendedWrenchItem.setColor(copiedWrench, j2);
        return copiedWrench;
    }

    public static ItemStack swapMaterial(ItemStack stack, ResourceLocation location, WrenchPart part) {
        CompoundTag display = stack.m_41698_(TAG_DISPLAY);
        CompoundTag materials = display.m_128469_(TAG_MATERIALS);
        CompoundTag materialData = materials.m_128469_(part.m_7912_());
        materialData.m_128359_(TAG_MATERIAL_LOCATION, location.toString());
        materials.m_128365_(part.m_7912_(), (Tag)materialData);
        display.m_128365_(TAG_MATERIALS, (Tag)materials);
        return stack;
    }

    public static boolean hasMaterial(ItemStack stack, WrenchPart part, @Nullable ResourceLocation material) {
        if (material == null) {
            return false;
        }
        CompoundTag display = stack.m_41698_(TAG_DISPLAY);
        CompoundTag materials = display.m_128469_(TAG_MATERIALS);
        CompoundTag materialData = materials.m_128469_(part.m_7912_());
        String materialLocation = materialData.m_128461_(TAG_MATERIAL_LOCATION);
        if (materialLocation.isEmpty()) {
            String locString = material.toString();
            if (part == WrenchPart.HEAD && locString.equals("extendedwrenches:gold_head")) {
                return true;
            }
            if (part == WrenchPart.HANDLE && locString.equals("extendedwrenches:dark_oak_handle")) {
                return true;
            }
            if (part == WrenchPart.COG && locString.equals("extendedwrenches:spruce_cog")) {
                return true;
            }
            if (part == WrenchPart.AXIS && locString.equals("extendedwrenches:andesite_axis")) {
                return true;
            }
        }
        return materialLocation.equals(material.toString());
    }

    public static ItemStack convertWrench(ItemStack original) {
        if (original.m_150930_((Item)AllItems.WRENCH.get())) {
            return ExtendedItems.WRENCH.asStack();
        }
        return original;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept((IClientItemExtensions)SimpleCustomRenderer.create((Item)this, (CustomRenderedItemModelRenderer)new ExtendedWrenchItemRenderer()));
    }

    @Nonnull
    public String m_5524_() {
        return "item.create.wrench";
    }
}

