/*
 * Decompiled with CFR 0.152.
 */
package net.vercte.extendedwrenches.wrench;

import com.google.common.collect.Lists;
import com.simibubi.create.content.equipment.wrench.WrenchItem;
import java.util.ArrayList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.vercte.extendedwrenches.ExtendedWrenchesRecipeSerializers;
import net.vercte.extendedwrenches.wrench.ExtendedWrenchItem;
import org.jetbrains.annotations.NotNull;

public class WrenchDyeRecipe
extends CustomRecipe {
    public WrenchDyeRecipe(ResourceLocation location, CraftingBookCategory category) {
        super(location, category);
    }

    public boolean matches(CraftingContainer container, @NotNull Level level) {
        ItemStack wrench = ItemStack.f_41583_;
        ArrayList dyes = Lists.newArrayList();
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack item = container.m_8020_(i);
            if (item.m_41619_()) continue;
            if (item.m_41720_() instanceof WrenchItem) {
                if (!wrench.m_41619_()) {
                    return false;
                }
                wrench = item;
                continue;
            }
            if (!(item.m_41720_() instanceof DyeItem)) {
                return false;
            }
            dyes.add(item);
        }
        return !wrench.m_41619_() && !dyes.isEmpty();
    }

    @NotNull
    public ItemStack assemble(CraftingContainer container, @NotNull RegistryAccess access) {
        ArrayList dyes = Lists.newArrayList();
        ItemStack wrench = ItemStack.f_41583_;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (stack.m_41619_()) continue;
            Item item = stack.m_41720_();
            if (item instanceof WrenchItem) {
                if (!wrench.m_41619_()) {
                    return ItemStack.f_41583_;
                }
                wrench = ExtendedWrenchItem.convertWrench(stack.m_41777_());
                continue;
            }
            if (!(item instanceof DyeItem)) {
                return ItemStack.f_41583_;
            }
            DyeItem dye = (DyeItem)item;
            dyes.add(dye);
        }
        if (!wrench.m_41619_() && !dyes.isEmpty()) {
            return ExtendedWrenchItem.dyeWrench(wrench, dyes);
        }
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int x, int y) {
        return x * y >= 2;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ExtendedWrenchesRecipeSerializers.WRENCH_DYE_RECIPE.get();
    }
}

