/*
 * Decompiled with CFR 0.152.
 */
package net.vercte.extendedwrenches.wrench;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.AllItems;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.vercte.extendedwrenches.ExtendedItems;
import net.vercte.extendedwrenches.ExtendedWrenches;
import net.vercte.extendedwrenches.ExtendedWrenchesData;
import net.vercte.extendedwrenches.ExtendedWrenchesRecipeSerializers;
import net.vercte.extendedwrenches.wrench.ExtendedWrenchItem;
import net.vercte.extendedwrenches.wrench.WrenchMaterial;
import net.vercte.extendedwrenches.wrench.WrenchPart;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.system.NonnullDefault;

public class WrenchMaterialSwapRecipe
implements SmithingRecipe {
    private final ResourceLocation id;
    private final ResourceLocation materialLocation;
    final Ingredient template;
    final Ingredient addition;
    final WrenchPart part;

    public WrenchMaterialSwapRecipe(ResourceLocation id, ResourceLocation material, Ingredient template, Ingredient addition, WrenchPart part) {
        this.id = id;
        this.materialLocation = material;
        this.template = template;
        this.addition = addition;
        this.part = part;
    }

    public boolean m_266166_(@NotNull ItemStack stack) {
        return this.template.test(stack);
    }

    public boolean m_266343_(@NotNull ItemStack stack) {
        return stack.m_150930_((Item)ExtendedItems.WRENCH.get()) || stack.m_150930_((Item)AllItems.WRENCH.get());
    }

    public boolean m_266253_(@NotNull ItemStack stack) {
        return this.addition.test(stack);
    }

    public Ingredient getTemplate() {
        return this.template;
    }

    public Ingredient getBase() {
        return Ingredient.m_43929_((ItemLike[])new ItemLike[]{AllItems.WRENCH, ExtendedItems.WRENCH});
    }

    public Ingredient getAddition() {
        return this.addition;
    }

    public boolean m_5818_(@NotNull Container container, @NotNull Level level) {
        ItemStack template = container.m_8020_(0);
        ItemStack addition = container.m_8020_(2);
        ItemStack stack = container.m_8020_(1);
        boolean isWrench = stack.m_150930_((Item)ExtendedItems.WRENCH.get()) || stack.m_150930_((Item)AllItems.WRENCH.get());
        return isWrench && this.template.test(template) && this.addition.test(addition) && !ExtendedWrenchItem.hasMaterial(stack, this.part, this.materialLocation);
    }

    @NotNull
    public ItemStack m_5874_(@NotNull Container container, @NotNull RegistryAccess access) {
        return this.applyTransformation(container.m_8020_(1), access);
    }

    public ItemStack applyTransformation(ItemStack input, @NotNull RegistryAccess access) {
        Registry materials = access.m_175515_(ExtendedWrenchesData.WRENCH_MATERIAL);
        Optional optMaterial = materials.m_6612_(this.materialLocation);
        if (optMaterial.isEmpty()) {
            return ItemStack.f_41583_;
        }
        ItemStack wrench = ExtendedWrenchItem.convertWrench(input);
        WrenchMaterial material = (WrenchMaterial)optMaterial.get();
        ResourceLocation materialLocation = materials.m_7981_((Object)material);
        assert (materialLocation != null);
        return ExtendedWrenchItem.swapMaterial(wrench.m_41777_(), materialLocation, this.part);
    }

    @NotNull
    public ItemStack m_8043_(@NotNull RegistryAccess access) {
        return ExtendedItems.WRENCH.asStack();
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ExtendedWrenchesRecipeSerializers.WRENCH_MATERIAL_SWAP.get();
    }

    public static class Builder
    implements FinishedRecipe {
        private final ResourceLocation id;
        private ResourceLocation materialLocation;
        private Ingredient template;
        private Ingredient addition;
        private WrenchPart part;

        public Builder(ResourceLocation id) {
            this.id = id;
        }

        public Builder material(String id) {
            this.materialLocation = ExtendedWrenches.asResource(id);
            return this;
        }

        public Builder template(ItemLike template) {
            this.template = Ingredient.m_43929_((ItemLike[])new ItemLike[]{template});
            return this;
        }

        public Builder addition(TagKey<Item> addition) {
            return this.addition(Ingredient.m_204132_(addition));
        }

        public Builder addition(ItemLike addition) {
            return this.addition(Ingredient.m_43929_((ItemLike[])new ItemLike[]{addition}));
        }

        public Builder addition(Ingredient addition) {
            this.addition = addition;
            return this;
        }

        public Builder part(WrenchPart part) {
            this.part = part;
            return this;
        }

        public void save(Consumer<FinishedRecipe> consumer) {
            consumer.accept(this);
        }

        public void m_7917_(JsonObject json) {
            json.addProperty("material", this.materialLocation.toString());
            json.add("template", this.template.m_43942_());
            json.add("addition", this.addition.m_43942_());
            json.addProperty("part", this.part.m_7912_());
        }

        @NotNull
        public ResourceLocation m_6445_() {
            return this.id;
        }

        @NotNull
        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)ExtendedWrenchesRecipeSerializers.WRENCH_MATERIAL_SWAP.get();
        }

        public JsonObject m_5860_() {
            return null;
        }

        public ResourceLocation m_6448_() {
            return null;
        }
    }

    @NonnullDefault
    public static class Serializer
    implements RecipeSerializer<WrenchMaterialSwapRecipe> {
        public WrenchMaterialSwapRecipe fromJson(ResourceLocation location, JsonObject json) {
            Ingredient base = Ingredient.m_43917_((JsonElement)GsonHelper.m_289747_((JsonObject)json, (String)"template"));
            Ingredient addition = Ingredient.m_43917_((JsonElement)GsonHelper.m_289747_((JsonObject)json, (String)"addition"));
            ResourceLocation materialLocation = ResourceLocation.parse((String)GsonHelper.m_13906_((JsonObject)json, (String)"material"));
            WrenchPart part = WrenchPart.getFromString(GsonHelper.m_13906_((JsonObject)json, (String)"part"));
            return new WrenchMaterialSwapRecipe(location, materialLocation, base, addition, part);
        }

        public WrenchMaterialSwapRecipe fromNetwork(ResourceLocation location, FriendlyByteBuf buffer) {
            Ingredient template = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            Ingredient addition = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ResourceLocation materialLocation = buffer.m_130281_();
            String part = buffer.m_130277_();
            return new WrenchMaterialSwapRecipe(location, materialLocation, template, addition, WrenchPart.getFromString(part));
        }

        public void toNetwork(FriendlyByteBuf buffer, WrenchMaterialSwapRecipe recipe) {
            recipe.template.m_43923_(buffer);
            recipe.addition.m_43923_(buffer);
            buffer.m_130085_(recipe.materialLocation);
            buffer.m_130070_(recipe.part.m_7912_());
        }
    }
}

