/*
 * Ex Deorum
 * Copyright (c) 2024 thedarkcolour
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package thedarkcolour.exdeorum.compat.jade;

import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import thedarkcolour.exdeorum.blockentity.InfestedLeavesBlockEntity;
import thedarkcolour.exdeorum.data.TranslationKeys;

enum InfestedLeavesComponentProvider implements IBlockComponentProvider {
    INSTANCE;

    @Override
    public void appendTooltip(ITooltip tooltip, BlockAccessor blockAccessor, IPluginConfig config) {
        if (blockAccessor.getBlockEntity() instanceof InfestedLeavesBlockEntity leaves) {
            int progress = 100 * leaves.getProgress() / InfestedLeavesBlockEntity.MAX_PROGRESS;
            if (progress == 100) {
                tooltip.add(Component.translatable(TranslationKeys.INFESTED_LEAVES_FULLY_INFESTED));
            } else {
                tooltip.add(Component.literal("Progress: ").append(Component.literal(progress + "%")));
            }
        }
    }

    @Override
    public ResourceLocation getUid() {
        return ExDeorumJadePlugin.INFESTED_LEAVES;
    }
}
