/*
 * Ex Deorum
 * Copyright (c) 2024 thedarkcolour
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package thedarkcolour.exdeorum.data;

import thedarkcolour.exdeorum.ExDeorum;
import thedarkcolour.exdeorum.compat.ModIds;

public class TranslationKeys {
    // Misc
    public static final String MAIN_CREATIVE_TAB = "itemGroup." + ExDeorum.ID + ".main";
    public static final String VOID_WORLD_TYPE = "generator." + ExDeorum.ID + ".void_world";
    // ": %s / %s"
    public static final String FRACTION_DISPLAY = "item." + ExDeorum.ID + ".watering_can_fluid_display";
    public static final String MECHANICAL_SIEVE_MESH_LABEL = "item." + ExDeorum.ID + ".mechanical_sieve.mesh_label";
    public static final String MECHANICAL_HAMMER_HAMMER_LABEL = "item." + ExDeorum.ID + ".mechanical_hammer.hammer_label";
    public static final String ENERGY = "gui." + ExDeorum.ID + ".energy_label";

    // Blocks
    public static final String INFESTED_LEAVES_FULLY_INFESTED = "block." + ExDeorum.ID + ".infested_leaves.fully_infested";

    // Items
    public static final String RANDOM_TRIM_DOES_NOT_CONTAIN_UPGRADE = "item." + ExDeorum.ID + ".random_armor_trim.no_upgrade";

    // Advancements
    public static final String ROOT_ADVANCEMENT_TITLE = "advancements." + ExDeorum.ID + ".core.root.title";
    public static final String ROOT_ADVANCEMENT_DESCRIPTION = "advancements." + ExDeorum.ID + ".core.root.description";
    public static final String CROOK_ADVANCEMENT_TITLE = "advancements." + ExDeorum.ID + ".core.crook.title";
    public static final String CROOK_ADVANCEMENT_DESCRIPTION = "advancements." + ExDeorum.ID + ".core.crook.description";
    public static final String BARREL_ADVANCEMENT_TITLE = "advancements." + ExDeorum.ID + ".core.barrel.title";
    public static final String BARREL_ADVANCEMENT_DESCRIPTION = "advancements." + ExDeorum.ID + ".core.barrel.description";
    public static final String SILK_WORM_ADVANCEMENT_TITLE = "advancements." + ExDeorum.ID + ".core.silk_worm.title";
    public static final String SILK_WORM_ADVANCEMENT_DESCRIPTION = "advancements." + ExDeorum.ID + ".core.silk_worm.description";
    public static final String STRING_MESH_ADVANCEMENT_TITLE = "advancements." + ExDeorum.ID + ".core.string_mesh.title";
    public static final String STRING_MESH_ADVANCEMENT_DESCRIPTION = "advancements." + ExDeorum.ID + ".core.string_mesh.description";

    // JEI descriptions
    public static final String SILK_WORM_JEI_INFO = "info." + ExDeorum.ID + ".silk_worm";
    public static final String SIEVE_JEI_INFO = "info." + ExDeorum.ID + ".sieve";
    public static final String SIEVE_MESH_JEI_INFO = "info." + ExDeorum.ID + ".sieve_mesh";
    public static final String WATERING_CAN_JEI_INFO = "info." + ExDeorum.ID + ".watering_can";
    public static final String WITCH_WATER_JEI_INFO = "info." + ExDeorum.ID + ".witch_water";
    public static final String MYCELIUM_SPORES_JEI_INFO = "info." + ExDeorum.ID + ".mycelium_spores";
    public static final String GRASS_SEEDS_JEI_INFO = "info." + ExDeorum.ID + ".grass_seeds";
    public static final String WARPED_NYLIUM_SPORES_JEI_INFO = "info." + ExDeorum.ID + ".warped_nylium_spores";
    public static final String CRIMSON_NYLIUM_SPORES_JEI_INFO = "info." + ExDeorum.ID + ".crimson_nylium_spores";
    public static final String SCULK_CORE_JEI_INFO = "info." + ExDeorum.ID + ".sculk_core";
    public static final String MECHANICAL_SIEVE_JEI_INFO = "info." + ExDeorum.ID + ".mechanical_sieve";
    public static final String MECHANICAL_HAMMER_JEI_INFO = "info." + ExDeorum.ID + ".mechanical_hammer";

    // JEI recipe categories
    public static final String BARREL_COMPOST_CATEGORY_TITLE = "gui." + ExDeorum.ID + ".category.barrel_compost";
    public static final String BARREL_COMPOST_RECIPE_VOLUME = "gui." + ExDeorum.ID + ".category.barrel_compost.volume";
    public static final String BARREL_MIXING_CATEGORY_TITLE = "gui." + ExDeorum.ID + ".category.barrel_mixing";
    public static final String BARREL_FLUID_MIXING_CATEGORY_TITLE = "gui." + ExDeorum.ID + ".category.barrel_fluid_mixing";
    public static final String BARREL_FLUID_MIXING_CONTENTS_ARE_CONSUMED = "gui." + ExDeorum.ID + ".category.barrel_fluid_mixing.contents_are_consumed";
    public static final String WATER_CRUCIBLE_CATEGORY_TITLE = "gui." + ExDeorum.ID + ".category.water_crucible";
    public static final String LAVA_CRUCIBLE_CATEGORY_TITLE = "gui." + ExDeorum.ID + ".category.lava_crucible";
    public static final String CRUCIBLE_HEAT_SOURCE_CATEGORY_TITLE = "gui." + ExDeorum.ID + ".category.crucible_heat_source";
    public static final String CRUCIBLE_HEAT_SOURCE_CATEGORY_MULTIPLIER = "gui." + ExDeorum.ID + ".category.crucible_heat_source.multiplier";
    public static final String HAMMER_CATEGORY_TITLE = "gui." + ExDeorum.ID + ".category.hammer";
    public static final String COMPRESSED_HAMMER_CATEGORY_TITLE = "gui." + ExDeorum.ID + ".category.compressed_hammer";
    public static final String CROOK_CATEGORY_TITLE = "gui." + ExDeorum.ID + ".category.crook";
    public static final String CROOK_CATEGORY_REQUIRES_STATE = "gui." + ExDeorum.ID + ".category.crook.requires_state";
    public static final String SIEVE_CATEGORY_TITLE = "gui." + ExDeorum.ID + ".category.sieve";
    public static final String COMPRESSED_SIEVE_CATEGORY_TITLE = "gui." + ExDeorum.ID + ".category.compressed_sieve";
    public static final String SIEVE_RECIPE_CHANCE = "gui." + ExDeorum.ID + ".category.sieve.chance";
    public static final String SIEVE_RECIPE_AVERAGE_OUTPUT = "gui." + ExDeorum.ID + ".category.sieve.average_output";
    public static final String SIEVE_RECIPE_MIN_OUTPUT = "gui." + ExDeorum.ID + ".category.sieve.min_output";
    public static final String SIEVE_RECIPE_MAX_OUTPUT = "gui." + ExDeorum.ID + ".category.sieve.max_output";
    public static final String SIEVE_RECIPE_BY_HAND_ONLY = "gui." + ExDeorum.ID + ".category.sieve.by_hand_only";

    // EMI recipe categories
    public static final String EMI_BARREL_COMPOST_CATEGORY_TITLE = ModIds.EMI + ".category." + ExDeorum.ID + ".barrel_compost";
    public static final String EMI_BARREL_MIXING_CATEGORY_TITLE = ModIds.EMI + ".category." + ExDeorum.ID + ".barrel_mixing";
    public static final String EMI_BARREL_FLUID_MIXING_CATEGORY_TITLE = ModIds.EMI + ".category." + ExDeorum.ID + ".barrel_fluid_mixing";
    public static final String EMI_LAVA_CRUCIBLE_CATEGORY_TITLE = ModIds.EMI + ".category." + ExDeorum.ID + ".lava_crucible";
    public static final String EMI_WATER_CRUCIBLE_CATEGORY_TITLE = ModIds.EMI + ".category." + ExDeorum.ID + ".water_crucible";
    public static final String EMI_CRUCIBLE_HEAT_SOURCES_CATEGORY_TITLE = ModIds.EMI + ".category." + ExDeorum.ID + ".crucible_heat_sources";
    public static final String EMI_SIEVE_CATEGORY_TITLE = ModIds.EMI + ".category." + ExDeorum.ID + ".sieve";
    public static final String EMI_COMPRESSED_SIEVE_CATEGORY_TITLE = ModIds.EMI + ".category." + ExDeorum.ID + ".compressed_sieve";
    public static final String EMI_HAMMER_CATEGORY_TITLE = ModIds.EMI + ".category." + ExDeorum.ID + ".hammer";
    public static final String EMI_COMPRESSED_HAMMER_CATEGORY_TITLE = ModIds.EMI + ".category." + ExDeorum.ID + ".compressed_hammer";
    public static final String EMI_CROOK_CATEGORY_TITLE = ModIds.EMI + ".category." + ExDeorum.ID + ".crook";

    // Screens
    public static final String MECHANICAL_SIEVE_SCREEN_TITLE = ExDeorum.ID + ".container.mechanical_sieve";
    public static final String[] REDSTONE_CONTROL_MODES = new String[] {
            "gui." + ExDeorum.ID + ".redstone_control.always",
            "gui." + ExDeorum.ID + ".redstone_control.unpowered",
            "gui." + ExDeorum.ID + ".redstone_control.powered"
    };
    public static final String REDSTONE_CONTROL_LABEL = "gui." + ExDeorum.ID + ".redstone_control.label";
    public static final String REDSTONE_CONTROL_MODE = "gui." + ExDeorum.ID + ".redstone_control.mode";
    public static final String MECHANICAL_HAMMER_SCREEN_TITLE = ExDeorum.ID + ".container.mechanical_hammer";

    // Sounds
    public static final String BARREL_ADD_COMPOST_SUBTITLE = "subtitles.exdeorum.barrel.add_compost";
    public static final String BARREL_COMPOST_SUBTITLE = "subtitles.exdeorum.barrel.compost_finish";
    public static final String BARREL_MIXING_SUBTITLE = "subtitles.exdeorum.barrel.mixing_finish";
    public static final String BARREL_FLUID_TRANSFORM_SUBTITLE = "subtitles.exdeorum.barrel.fluid_transform";
    public static final String SILK_WORM_DROP_SUBTITLE = "subtitles.exdeorum.silk_worm.drop";
    public static final String SILK_WORM_INFEST_SUBTITLE = "subtitles.exdeorum.silk_worm.infest";
    public static final String SILK_WORM_EAT_SUBTITLE = "subtitles.exdeorum.silk_worm.eat";
    public static final String GRASS_SEEDS_PLACE_SUBTITLE = "subtitles.exdeorum.grass_seeds.place";
    public static final String SCULK_CORE_ACTIVATE_SUBTITLE = "subtitles.exdeorum.sculk_core.activate";
    public static final String WATERING_CAN_USE_SUBTITLE = "subtitles.exdeorum.watering_can.use";
    public static final String WATERING_CAN_STOP_SUBTITLE = "subtitles.exdeorum.watering_can.stop";
}
