/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum;

import java.util.Calendar;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.data.loading.DatagenModLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thedarkcolour.exdeorum.client.ClientHandler;
import thedarkcolour.exdeorum.config.EConfig;
import thedarkcolour.exdeorum.data.Data;
import thedarkcolour.exdeorum.data.ModCompatData;
import thedarkcolour.exdeorum.event.EventHandler;
import thedarkcolour.exdeorum.material.DefaultMaterials;
import thedarkcolour.exdeorum.registry.EBlockEntities;
import thedarkcolour.exdeorum.registry.EBlocks;
import thedarkcolour.exdeorum.registry.EChunkGenerators;
import thedarkcolour.exdeorum.registry.ECompressedBlocks;
import thedarkcolour.exdeorum.registry.ECreativeTabs;
import thedarkcolour.exdeorum.registry.EDataComponents;
import thedarkcolour.exdeorum.registry.EFluids;
import thedarkcolour.exdeorum.registry.EGlobalLootModifiers;
import thedarkcolour.exdeorum.registry.EItems;
import thedarkcolour.exdeorum.registry.ELootFunctions;
import thedarkcolour.exdeorum.registry.EMenus;
import thedarkcolour.exdeorum.registry.ENumberProviders;
import thedarkcolour.exdeorum.registry.ERecipeSerializers;
import thedarkcolour.exdeorum.registry.ERecipeTypes;
import thedarkcolour.exdeorum.registry.ESounds;

@Mod(value="exdeorum")
public class ExDeorum {
    public static final String ID = "exdeorum";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"exdeorum");
    public static final boolean DEBUG = ModList.get().isLoaded("modkit");
    public static final boolean IS_JUNE = Calendar.getInstance().get(2) == 5;

    public ExDeorum(IEventBus modBus) {
        ExDeorum.createRegistries(modBus);
        NeoForgeMod.enableMilkFluid();
        if (DatagenModLoader.isRunningDataGen()) {
            ModCompatData.registerModData(modBus);
            modBus.addListener(Data::generateData);
        }
        EventHandler.register(modBus);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            ClientHandler.register(modBus);
        }
        ModContainer container = (ModContainer)ModList.get().getModContainerById(ID).get();
        container.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)EConfig.SERVER_SPEC);
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)EConfig.COMMON_SPEC);
        container.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)EConfig.CLIENT_SPEC);
    }

    private static void createRegistries(IEventBus modBus) {
        EBlocks.BLOCKS.register(modBus);
        EBlockEntities.BLOCK_ENTITIES.register(modBus);
        EChunkGenerators.CHUNK_GENERATORS.register(modBus);
        ECreativeTabs.CREATIVE_TABS.register(modBus);
        EFluids.FLUID_TYPES.register(modBus);
        EFluids.FLUIDS.register(modBus);
        EGlobalLootModifiers.GLOBAL_LOOT_MODIFIERS.register(modBus);
        EItems.ITEMS.register(modBus);
        ELootFunctions.LOOT_FUNCTIONS.register(modBus);
        ESounds.SOUNDS.register(modBus);
        EMenus.MENUS.register(modBus);
        ERecipeSerializers.RECIPE_SERIALIZERS.register(modBus);
        ERecipeTypes.RECIPE_TYPES.register(modBus);
        ENumberProviders.NUMBER_PROVIDERS.register(modBus);
        EDataComponents.DATA_COMPONENTS.register(modBus);
        DefaultMaterials.registerMaterials();
        ECompressedBlocks.register();
    }

    public static ResourceLocation loc(String menuProperty) {
        return ResourceLocation.fromNamespaceAndPath((String)ID, (String)menuProperty);
    }
}

