/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.block;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.world.AuxiliaryLightManager;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.exdeorum.block.EBlock;
import thedarkcolour.exdeorum.block.ETankBlock;
import thedarkcolour.exdeorum.blockentity.BarrelBlockEntity;
import thedarkcolour.exdeorum.registry.EBlockEntities;

public class BarrelBlock
extends ETankBlock {
    public static final float BARREL_FLUID_BOTTOM = 0.0625f;
    public static final float BARREL_FLUID_TOP = 0.875f;
    public static final VoxelShape SHAPE = Shapes.join((VoxelShape)BarrelBlock.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0), (VoxelShape)BarrelBlock.box((double)2.0, (double)1.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), (BooleanOp)BooleanOp.ONLY_FIRST);

    public BarrelBlock(BlockBehaviour.Properties properties) {
        super(properties, (Supplier<? extends BlockEntityType<?>>)EBlockEntities.BARREL);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState pState, BlockEntityType<T> type) {
        return type == EBlockEntities.BARREL.get() ? new BarrelBlockEntity.Ticker() : null;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BarrelBlockEntity barrel;
        ItemStack item;
        BlockEntity blockEntity;
        if (!level.isClientSide && !state.is(newState.getBlock()) && (blockEntity = level.getBlockEntity(pos)) instanceof BarrelBlockEntity && !(item = (barrel = (BarrelBlockEntity)blockEntity).getItem()).isEmpty()) {
            EBlock.dropItem(level, pos, item);
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public void neighborChanged(BlockState pState, Level level, BlockPos pos, Block pBlock, BlockPos fromPos, boolean pIsMoving) {
        BlockEntity blockEntity;
        if (fromPos.getY() - pos.getY() == 1) {
            BlockEntity blockEntity2 = level.getBlockEntity(pos);
            if (blockEntity2 instanceof BarrelBlockEntity) {
                BarrelBlockEntity barrel = (BarrelBlockEntity)blockEntity2;
                barrel.tryInWorldFluidMixing();
            }
        } else if (fromPos.getY() - pos.getY() == -1 && (blockEntity = level.getBlockEntity(pos)) instanceof BarrelBlockEntity) {
            BarrelBlockEntity barrel = (BarrelBlockEntity)blockEntity;
            barrel.updateFluidTransform();
        }
    }

    @Override
    protected boolean isEntityInFluid(Level level, BlockPos pos, Entity entity, float fillRatio) {
        float fluidTop = Mth.lerp((float)fillRatio, (float)0.0625f, (float)0.875f);
        return entity.getBoundingBox().intersects((double)pos.getX() + 0.125, (double)((float)pos.getY() + 0.0625f), (double)pos.getZ() + 0.125, (double)pos.getX() + 0.875, (double)((float)pos.getY() + fluidTop), (double)pos.getZ() + 0.875);
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        AuxiliaryLightManager lightManager = level.getAuxLightManager(pos);
        if (lightManager != null) {
            return lightManager.getLightAt(pos);
        }
        return 0;
    }
}

