/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.blockentity;

import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.util.FakePlayer;
import thedarkcolour.exdeorum.blockentity.EBlockEntity;
import thedarkcolour.exdeorum.blockentity.SieveBlockEntity;
import thedarkcolour.exdeorum.blockentity.logic.SieveLogic;
import thedarkcolour.exdeorum.config.EConfig;

public abstract class AbstractSieveBlockEntity
extends EBlockEntity
implements SieveLogic.Owner {
    protected final SieveLogic logic;
    private final float sieveInterval;

    public AbstractSieveBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, float sieveInterval, Function<SieveLogic.Owner, SieveLogic> logic) {
        super(type, pos, state);
        this.sieveInterval = sieveInterval;
        this.logic = logic.apply(this);
    }

    public static ItemStack singleCopy(ItemStack stack) {
        ItemStack copy = stack.copy();
        copy.setCount(1);
        return copy;
    }

    @Override
    public boolean handleResultItem(ItemStack result, ServerLevel level, RandomSource rand) {
        BlockPos pos = this.worldPosition;
        ItemEntity itemEntity = new ItemEntity((Level)level, (double)pos.getX() + 0.5, (double)pos.getY() + 1.5, (double)pos.getZ() + 0.5, result);
        itemEntity.setDeltaMovement(rand.nextGaussian() * 0.05, 0.2, rand.nextGaussian() * 0.05);
        level.addFreshEntity((Entity)itemEntity);
        return true;
    }

    @Override
    public ServerLevel getServerLevel() {
        return (ServerLevel)this.level;
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        this.logic.saveNbt(nbt, registries);
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.logic.loadNbt(nbt, registries);
    }

    @Override
    public SieveLogic getLogic() {
        return this.logic;
    }

    @Override
    public void writeVisualData(RegistryFriendlyByteBuf buffer) {
        this.logic.writeVisualData(buffer);
    }

    @Override
    public void readVisualData(RegistryFriendlyByteBuf buffer) {
        this.logic.readVisualData(buffer);
    }

    @Override
    public void copyVisualData(BlockEntity fromIntegratedServer) {
        this.logic.copyVisualData(fromIntegratedServer);
    }

    @Override
    public ItemInteractionResult useItemOn(Level level, Player player, ItemStack stack, InteractionHand hand) {
        boolean isClientSide;
        block22: {
            ItemStack playerItem = player.getItemInHand(hand);
            isClientSide = level.isClientSide;
            if (this.logic.getMesh().isEmpty()) {
                if (this.logic.isValidMesh(playerItem)) {
                    if (!isClientSide) {
                        this.logic.setMesh((HolderLookup.Provider)level.registryAccess(), AbstractSieveBlockEntity.singleCopy(playerItem));
                        if (!player.getAbilities().instabuild) {
                            playerItem.shrink(1);
                        }
                        return ItemInteractionResult.CONSUME;
                    }
                    return ItemInteractionResult.SUCCESS;
                }
            } else if (this.logic.getContents().isEmpty() && player.isShiftKeyDown() && player.getMainHandItem().isEmpty()) {
                AbstractSieveBlockEntity.popOutMesh(level, this.worldPosition, this.logic);
            }
            if (!isClientSide) {
                if (this.logic.getContents().isEmpty()) {
                    if (this.logic.isValidInput(playerItem)) {
                        Item usedItem = playerItem.getItem();
                        boolean realPlayer = !(player instanceof FakePlayer);
                        AbstractSieveBlockEntity.insertContents(player, playerItem, this.logic);
                        if ((realPlayer || !((Boolean)EConfig.SERVER.nerfAutomatedSieves.get()).booleanValue()) && this.canUseSimultaneously()) {
                            int range = (Integer)EConfig.SERVER.simultaneousSieveUsageRange.get();
                            BlockPos.MutableBlockPos cursor = this.worldPosition.mutable().move(-range, 0, -range);
                            for (int x = -range; x <= range; ++x) {
                                for (int z = -range; z <= range; ++z) {
                                    if (!playerItem.isEmpty() || !(playerItem = AbstractSieveBlockEntity.restockSieveMaterial(player, hand, usedItem)).isEmpty()) {
                                        BlockEntity blockEntity;
                                        if ((x | z) != 0 && (blockEntity = level.getBlockEntity((BlockPos)cursor)) instanceof SieveBlockEntity) {
                                            SieveBlockEntity other = (SieveBlockEntity)blockEntity;
                                            SieveLogic otherLogic = other.logic;
                                            if (otherLogic.getContents().isEmpty() && this.logic.getMesh().getItem() == otherLogic.getMesh().getItem()) {
                                                AbstractSieveBlockEntity.insertContents(player, playerItem, otherLogic);
                                            }
                                        }
                                        cursor.move(0, 0, 1);
                                        continue;
                                    }
                                    break block22;
                                }
                                cursor.move(1, 0, -2 * range - 1);
                            }
                        }
                    }
                } else {
                    boolean realPlayer;
                    long time = level.getGameTime();
                    boolean bl = realPlayer = !(player instanceof FakePlayer);
                    if ((realPlayer || !((Boolean)EConfig.SERVER.nerfAutomatedSieves.get()).booleanValue()) && this.canUseSimultaneously()) {
                        int range = (Integer)EConfig.SERVER.simultaneousSieveUsageRange.get();
                        BlockPos.MutableBlockPos cursor = this.worldPosition.mutable().move(-range, 0, -range);
                        BlockEntityType selfType = this.getType();
                        for (int x = -range; x <= range; ++x) {
                            for (int z = -range; z <= range; ++z) {
                                SieveLogic otherLogic;
                                AbstractSieveBlockEntity other;
                                BlockEntity blockEntity = level.getBlockEntity((BlockPos)cursor);
                                if (blockEntity instanceof AbstractSieveBlockEntity && (other = (AbstractSieveBlockEntity)blockEntity).getType() == selfType && !(otherLogic = other.logic).getContents().isEmpty() && this.logic.getMesh().getItem() == otherLogic.getMesh().getItem()) {
                                    otherLogic.sift(this.sieveInterval, time);
                                }
                                cursor.move(0, 0, 1);
                            }
                            cursor.move(1, 0, -2 * range - 1);
                        }
                    } else if (realPlayer || ((Boolean)EConfig.SERVER.automatedSieves.get()).booleanValue()) {
                        this.logic.sift(this.sieveInterval, time);
                    }
                }
            }
        }
        return ItemInteractionResult.sidedSuccess((boolean)isClientSide);
    }

    private static ItemStack restockSieveMaterial(Player player, InteractionHand hand, Item usedItem) {
        Inventory inventory = player.getInventory();
        int inventorySize = inventory.getContainerSize();
        for (int i = 0; i < inventorySize; ++i) {
            ItemStack stack = inventory.getItem(i);
            if (!stack.is(usedItem)) continue;
            stack = stack.copy();
            player.setItemInHand(hand, stack);
            inventory.setItem(i, ItemStack.EMPTY);
            return stack;
        }
        return ItemStack.EMPTY;
    }

    public static void insertContents(Player player, ItemStack playerItem, SieveLogic logic) {
        boolean consume = !player.getAbilities().instabuild;
        logic.startSifting(AbstractSieveBlockEntity.singleCopy(playerItem));
        player.awardStat(Stats.ITEM_USED.get((Object)playerItem.getItem()));
        if (consume) {
            playerItem.shrink(1);
        }
    }

    public static void popOutMesh(Level level, BlockPos sievePos, SieveLogic logic) {
        if (!level.isClientSide) {
            ItemEntity itemEntity = new ItemEntity(level, (double)sievePos.getX() + 0.5, (double)sievePos.getY() + 1.5, (double)sievePos.getZ() + 0.5, logic.getMesh());
            RandomSource rand = level.random;
            itemEntity.setDeltaMovement(rand.nextGaussian() * 0.05, 0.2, rand.nextGaussian() * 0.05);
            level.addFreshEntity((Entity)itemEntity);
            logic.setMesh((HolderLookup.Provider)level.registryAccess(), ItemStack.EMPTY);
        }
    }

    protected boolean canUseSimultaneously() {
        return false;
    }
}

