/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.blockentity.logic;

import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import thedarkcolour.exdeorum.config.EConfig;
import thedarkcolour.exdeorum.recipe.RecipeUtil;
import thedarkcolour.exdeorum.recipe.sieve.SieveRecipe;
import thedarkcolour.exdeorum.tag.EItemTags;

public class SieveLogic {
    private final Owner owner;
    private final boolean mechanical;
    private ItemStack contents = ItemStack.EMPTY;
    protected ItemStack mesh = ItemStack.EMPTY;
    private float progress;
    private float efficiency;
    private int fortune;
    private long lastTime = 0L;
    private final long minInterval;

    public SieveLogic(Owner owner, boolean mechanical) {
        this.owner = owner;
        this.mechanical = mechanical;
        this.minInterval = ((Integer)EConfig.SERVER.sieveIntervalTicks.get()).intValue();
    }

    public ItemStack getMesh() {
        return this.mesh;
    }

    public boolean isValidInput(ItemStack stack) {
        return !this.getDropsFor(stack).isEmpty();
    }

    public boolean isValidMesh(ItemStack stack) {
        return stack.is(EItemTags.SIEVE_MESHES);
    }

    public void startSifting(ItemStack stack) {
        this.contents = stack;
        this.owner.markUpdated();
    }

    public void sift(float incrementProgress, long time) {
        if (time < this.lastTime + this.minInterval) {
            return;
        }
        this.lastTime = time;
        this.progress += incrementProgress * this.efficiency;
        if (this.progress >= 0.99999f) {
            ServerLevel level = this.owner.getServerLevel();
            LootContext context = RecipeUtil.emptyLootContext(level);
            RandomSource rand = level.random;
            boolean limitDrops = this.contents.getItem() == Items.MOSS_BLOCK && (Boolean)EConfig.SERVER.limitMossSieveDrops.get() != false;
            boolean handledAnyDrops = false;
            boolean hasDrops = false;
            block0: for (SieveRecipe sieveRecipe : this.getDropsFor(this.contents)) {
                int stackAmount;
                for (int amount = this.getResultAmount(sieveRecipe, context, rand); amount > 0; amount -= stackAmount) {
                    hasDrops = true;
                    ItemStack result = sieveRecipe.result.copyWithCount(1);
                    stackAmount = Math.min(amount, sieveRecipe.result.getMaxStackSize());
                    result.setCount(stackAmount);
                    boolean handleDrop = this.owner.handleResultItem(result, level, rand);
                    boolean bl = handledAnyDrops = handledAnyDrops || handleDrop;
                    if (!limitDrops || rand.nextInt(5) == 0) continue;
                    continue block0;
                }
            }
            if (handledAnyDrops || !hasDrops) {
                this.contents = ItemStack.EMPTY;
                this.progress = 0.0f;
            } else {
                this.progress = 1.0f;
            }
        }
        this.owner.markUpdated();
    }

    protected List<? extends SieveRecipe> getDropsFor(ItemStack contents) {
        return RecipeUtil.getSieveRecipes(this.mesh.getItem(), contents);
    }

    protected int getResultAmount(SieveRecipe recipe, LootContext context, RandomSource rand) {
        if (recipe.byHandOnly && this.mechanical) {
            return 0;
        }
        int amount = recipe.resultAmount.getInt(context);
        for (int i = 0; i < this.fortune; ++i) {
            if (!(rand.nextFloat() < 0.3f)) continue;
            amount += recipe.resultAmount.getInt(context);
        }
        return amount;
    }

    public void setMesh(HolderLookup.Provider registries, ItemStack mesh) {
        this.setMesh(registries, mesh, true);
    }

    public void setMesh(HolderLookup.Provider registries, ItemStack mesh, boolean needsUpdate) {
        HolderLookup.RegistryLookup registry = registries.lookupOrThrow(Registries.ENCHANTMENT);
        this.mesh = mesh;
        this.efficiency = 1.0f + (float)mesh.getEnchantmentLevel((Holder)registry.getOrThrow(Enchantments.EFFICIENCY)) * 0.17f;
        this.fortune = mesh.getEnchantmentLevel((Holder)registry.getOrThrow(Enchantments.FORTUNE));
        if (mesh.isEmpty()) {
            this.progress = 0.0f;
            this.contents = ItemStack.EMPTY;
        }
        if (needsUpdate) {
            this.owner.markUpdated();
        }
    }

    public void saveNbt(CompoundTag nbt, HolderLookup.Provider registries) {
        if (!this.contents.isEmpty()) {
            nbt.put("contents", this.contents.save(registries));
        }
        if (!this.mechanical && !this.mesh.isEmpty()) {
            nbt.put("mesh", this.mesh.save(registries));
        }
        nbt.putFloat("progress", this.progress);
    }

    public void loadNbt(CompoundTag nbt, HolderLookup.Provider registries) {
        this.contents = nbt.contains("contents") ? ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)nbt.getCompound("contents")) : ItemStack.EMPTY;
        this.progress = nbt.getTagType("progress") == 2 ? (float)nbt.getShort("progress") / 100.0f : nbt.getFloat("progress");
        if (!this.mechanical) {
            if (nbt.contains("mesh")) {
                this.setMesh(registries, ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)nbt.getCompound("mesh")), false);
            } else {
                this.setMesh(registries, ItemStack.EMPTY, false);
            }
        }
    }

    public void writeVisualData(RegistryFriendlyByteBuf buffer) {
        ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)this.mesh);
        buffer.writeFloat(this.progress);
        ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)this.contents);
    }

    public void readVisualData(RegistryFriendlyByteBuf buffer) {
        this.setMesh((HolderLookup.Provider)buffer.registryAccess(), (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buffer));
        this.progress = buffer.readFloat();
        this.contents = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buffer);
    }

    public void copyVisualData(BlockEntity fromIntegratedServer) {
        if (fromIntegratedServer instanceof Owner) {
            Owner fromOwner = (Owner)fromIntegratedServer;
            SieveLogic from = fromOwner.getLogic();
            this.setMesh((HolderLookup.Provider)fromIntegratedServer.getLevel().registryAccess(), from.mesh.copy());
            this.progress = from.progress;
            this.contents = from.contents;
        }
    }

    public ItemStack getContents() {
        return this.contents;
    }

    public void setContents(ItemStack contents) {
        this.contents = contents;
    }

    public float getProgress() {
        return this.progress;
    }

    public void setProgress(float progress) {
        this.progress = progress;
    }

    public static interface Owner {
        public ServerLevel getServerLevel();

        public boolean handleResultItem(ItemStack var1, ServerLevel var2, RandomSource var3);

        public void markUpdated();

        public SieveLogic getLogic();
    }
}

