/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.compat;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.apache.commons.lang3.mutable.MutableInt;
import thedarkcolour.exdeorum.compat.CompatUtil;
import thedarkcolour.exdeorum.recipe.RecipeUtil;
import thedarkcolour.exdeorum.recipe.sieve.SieveRecipe;
import thedarkcolour.exdeorum.registry.EItems;

public record XeiSieveRecipe(Ingredient ingredient, ItemStack mesh, List<Result> results) {
    public static final MutableInt SIEVE_ROWS = new MutableInt(0);
    public static final MutableInt COMPRESSED_SIEVE_ROWS = new MutableInt(0);

    public static ImmutableList<XeiSieveRecipe> getAllRecipesGrouped(RecipeType<? extends SieveRecipe> recipeType, MutableInt maxRows) {
        int maxSieveRows = 1;
        List recipes = CompatUtil.collectAllRecipes(recipeType, Function.identity());
        ArrayListMultimap ingredientGrouper = ArrayListMultimap.create();
        for (int i = 0; i < recipes.size(); ++i) {
            SieveRecipe recipe = (SieveRecipe)recipes.get(i);
            ingredientGrouper.put((Object)recipe.ingredient(), (Object)recipe);
            for (int j = i + 1; j < recipes.size(); ++j) {
                SieveRecipe other = (SieveRecipe)recipes.get(j);
                if (!RecipeUtil.areIngredientsEqual(recipe.ingredient(), other.ingredient())) continue;
                ingredientGrouper.put((Object)recipe.ingredient(), (Object)other);
                recipes.remove(other);
                --j;
            }
        }
        ImmutableList.Builder jeiRecipes = new ImmutableList.Builder();
        Comparator<Result> resultSorter = Comparator.comparingDouble(Result::expectedCount).reversed();
        Comparator<Item> meshSorter = Comparator.comparingInt(XeiSieveRecipe::meshOrder);
        for (Ingredient ingredient : ingredientGrouper.keySet()) {
            ArrayListMultimap meshGrouper = ArrayListMultimap.create();
            Collection values = ingredientGrouper.get((Object)ingredient);
            for (SieveRecipe recipe : values) {
                for (ItemStack itemStack : recipe.mesh.getItems()) {
                    meshGrouper.put((Object)itemStack.getItem(), (Object)recipe);
                }
            }
            ArrayList<Item> meshes = new ArrayList<Item>(meshGrouper.keySet());
            meshes.sort(meshSorter);
            for (Item mesh : meshes) {
                Collection meshRecipes = meshGrouper.get((Object)mesh);
                ArrayList<Result> results = new ArrayList<Result>(meshRecipes.size());
                for (SieveRecipe recipe : meshRecipes) {
                    int n;
                    NumberProvider numberProvider = recipe.resultAmount;
                    if (numberProvider instanceof ConstantValue) {
                        ConstantValue constant = (ConstantValue)numberProvider;
                        n = Math.round(constant.value());
                    } else {
                        n = 1;
                    }
                    int resultCount = n;
                    results.add(new Result(recipe.result.copyWithCount(resultCount), recipe.resultAmount, recipe.byHandOnly));
                }
                results.sort(resultSorter);
                XeiSieveRecipe xeiSieveRecipe = new XeiSieveRecipe(ingredient, new ItemStack((ItemLike)mesh), results);
                jeiRecipes.add((Object)xeiSieveRecipe);
                int rows = Mth.ceil((float)((float)meshRecipes.size() / 9.0f));
                if (rows <= maxSieveRows) continue;
                maxSieveRows = rows;
            }
        }
        maxRows.setValue(maxSieveRows);
        return jeiRecipes.build();
    }

    private static int meshOrder(Item mesh) {
        if (mesh == EItems.STRING_MESH.get()) {
            return -5;
        }
        if (mesh == EItems.FLINT_MESH.get()) {
            return -4;
        }
        if (mesh == EItems.IRON_MESH.get()) {
            return -3;
        }
        if (mesh == EItems.GOLDEN_MESH.get()) {
            return -2;
        }
        if (mesh == EItems.DIAMOND_MESH.get()) {
            return -1;
        }
        if (mesh == EItems.NETHERITE_MESH.get()) {
            return 0;
        }
        return BuiltInRegistries.ITEM.getId((Object)mesh);
    }

    public static final class Result {
        public final ItemStack item;
        public final NumberProvider provider;
        public final boolean byHandOnly;
        private final double expectedCount;

        Result(ItemStack item, NumberProvider provider, boolean byHandOnly) {
            this.item = item;
            this.provider = provider;
            this.byHandOnly = byHandOnly;
            this.expectedCount = RecipeUtil.getExpectedValue(this.provider);
        }

        public double expectedCount() {
            return this.expectedCount;
        }
    }
}

