/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.compat.emi;

import com.google.common.collect.ImmutableList;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.neoforge.NeoForgeEmiStack;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.HashSet;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.fluids.FluidStack;
import thedarkcolour.exdeorum.recipe.BlockPredicate;
import thedarkcolour.exdeorum.recipe.SingleIngredientRecipe;

class EmiUtil {
    EmiUtil() {
    }

    static List<EmiIngredient> inputs(SingleIngredientRecipe recipe) {
        return ImmutableList.of((Object)EmiIngredient.of((Ingredient)recipe.ingredient));
    }

    static List<EmiIngredient> inputs(BlockPredicate predicate) {
        if (predicate instanceof BlockPredicate.SingleBlockPredicate) {
            BlockPredicate.SingleBlockPredicate block = (BlockPredicate.SingleBlockPredicate)predicate;
            Item item = block.block().asItem();
            if (item != Items.AIR) {
                return ImmutableList.of((Object)EmiStack.of((ItemLike)item));
            }
        } else {
            ImmutableList.Builder builder = ImmutableList.builder();
            HashSet items = new HashSet();
            predicate.possibleStates().forEach(state -> {
                Item item = state.getBlock().asItem();
                if (item != Items.AIR && items.add(item)) {
                    builder.add((Object)EmiStack.of((ItemLike)item));
                }
            });
            return ImmutableList.of((Object)EmiIngredient.of((List)builder.build()));
        }
        return ImmutableList.of();
    }

    public static <C extends RecipeInput, R extends Recipe<C>> void addAll(EmiRegistry registry, Supplier<RecipeType<R>> type, BiFunction<R, ResourceLocation, ? extends EmiRecipe> factory) {
        for (RecipeHolder holder : registry.getRecipeManager().byType(type.get())) {
            registry.addRecipe(factory.apply(holder.value(), holder.id()));
        }
    }

    public static List<EmiStack> outputs(ItemStack result) {
        return ImmutableList.of((Object)EmiStack.of((ItemStack)result));
    }

    public static List<EmiStack> outputs(FluidStack stack) {
        return ImmutableList.of((Object)NeoForgeEmiStack.of((FluidStack)new FluidStack(stack.getFluid(), stack.getAmount())));
    }
}

