/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.compat.jei;

import com.mojang.blaze3d.platform.InputConstants;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.recipe.IFocusFactory;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import thedarkcolour.exdeorum.compat.ClientXeiUtil;
import thedarkcolour.exdeorum.compat.jei.ClientJeiUtil;
import thedarkcolour.exdeorum.compat.jei.CrookJeiRecipe;
import thedarkcolour.exdeorum.compat.jei.CycleTimer;
import thedarkcolour.exdeorum.compat.jei.ExDeorumJeiPlugin;
import thedarkcolour.exdeorum.registry.EItems;

public class CrookCategory
implements IRecipeCategory<CrookJeiRecipe> {
    private static final Component REQUIRES_CERTAIN_STATE = Component.translatable((String)"gui.exdeorum.category.crook.requires_state").withStyle(ChatFormatting.GRAY);
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable arrow;
    private final IDrawable slot;
    private final Component title;
    private final IFocusFactory focusFactory;
    private final IIngredientManager ingredientManager;
    private final IModIdHelper modIdHelper;
    private final CycleTimer timer = new CycleTimer(0);

    public CrookCategory(IJeiHelpers helpers, IDrawable arrow) {
        IGuiHelper helper = helpers.getGuiHelper();
        this.background = helper.createBlankDrawable(120, 48);
        this.icon = helper.createDrawableItemStack(new ItemStack((ItemLike)EItems.CROOK.get()));
        this.arrow = arrow;
        this.slot = helper.getSlotDrawable();
        this.title = Component.translatable((String)"gui.exdeorum.category.crook");
        this.focusFactory = helpers.getFocusFactory();
        this.ingredientManager = helpers.getIngredientManager();
        this.modIdHelper = helpers.getModIdHelper();
    }

    public RecipeType<CrookJeiRecipe> getRecipeType() {
        return ExDeorumJeiPlugin.CROOK;
    }

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CrookJeiRecipe recipe, IFocusGroup focuses) {
        recipe.addIngredients(builder);
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 80, 18).addItemStack(recipe.result)).addRichTooltipCallback((recipeSlotView, tooltip) -> tooltip.add((FormattedText)ClientXeiUtil.formatChance(recipe.chance)));
    }

    public void draw(CrookJeiRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        this.timer.onDraw();
        this.arrow.draw(graphics, 50, 18);
        this.slot.draw(graphics, 79, 17);
        BlockState state = this.timer.getCycledItem(recipe.states);
        ClientXeiUtil.renderBlock(graphics, state, 28.0f, 18.0f, 10.0f, 20.0f);
    }

    /*
     * Unable to fully structure code
     */
    public void getTooltip(ITooltipBuilder tooltip, CrookJeiRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        block3: {
            if (!(12.0 < mouseX) || !(mouseX < 44.0) || !(10.0 < mouseY) || !(mouseY < 42.0)) break block3;
            block = this.timer.getCycledItem(recipe.states).getBlock();
            modId = BuiltInRegistries.BLOCK.getKey((Object)block).getNamespace();
            tooltip.add((FormattedText)Component.translatable((String)block.getDescriptionId()));
            if (!(recipe instanceof CrookJeiRecipe.StatesRecipe)) ** GOTO lbl-1000
            statesRecipe = (CrookJeiRecipe.StatesRecipe)recipe;
            if (!statesRecipe.requirements.isEmpty()) {
                tooltip.add((FormattedText)CrookCategory.REQUIRES_CERTAIN_STATE);
                tooltip.addAll(statesRecipe.requirements);
            } else if (recipe instanceof CrookJeiRecipe.TagRecipe) {
                tagRecipe = (CrookJeiRecipe.TagRecipe)recipe;
                tooltip.add((FormattedText)Component.literal((String)("#" + String.valueOf(tagRecipe.tag.location()))).withStyle(ChatFormatting.GRAY));
            }
            tooltip.add((FormattedText)Component.literal((String)this.modIdHelper.getFormattedModNameForModId(modId)));
        }
    }

    public boolean handleInput(CrookJeiRecipe recipe, double mouseX, double mouseY, InputConstants.Key input) {
        if (input.getType() == InputConstants.Type.MOUSE && (input.getValue() == 0 || input.getValue() == 1) && 12.0 < mouseX && mouseX < 44.0 && 10.0 < mouseY && mouseY < 42.0) {
            Block block = this.timer.getCycledItem(recipe.states).getBlock();
            ClientJeiUtil.checkTypedIngredient(this.ingredientManager, VanillaTypes.ITEM_STACK, new ItemStack((ItemLike)block.asItem()), ingredient -> {
                if (input.getValue() == 0) {
                    ClientJeiUtil.showRecipes(this.focusFactory, ingredient);
                } else if (input.getValue() == 1) {
                    ClientJeiUtil.showUsages(this.focusFactory, ingredient);
                }
            });
            return true;
        }
        return false;
    }
}

