/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.item;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import thedarkcolour.exdeorum.registry.EItems;
import thedarkcolour.exdeorum.registry.ESounds;

public class GrassSpreaderItem
extends Item {
    private final Supplier<BlockState> grassState;

    public GrassSpreaderItem(Item.Properties properties, Supplier<BlockState> grassState) {
        super(properties);
        this.grassState = grassState;
    }

    public InteractionResult useOn(UseOnContext ctx) {
        Level level = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        Player player = ctx.getPlayer();
        BlockState state = level.getBlockState(pos);
        BlockState grass = this.grassState.get();
        if (this.canSpread(state) && grass != state) {
            if (!level.isClientSide) {
                level.setBlock(pos, grass, 3);
                level.playSound(null, pos, (SoundEvent)ESounds.GRASS_SEEDS_PLACE.get(), SoundSource.BLOCKS);
                if (player == null || !player.getAbilities().instabuild) {
                    ctx.getItemInHand().shrink(1);
                }
                return InteractionResult.CONSUME;
            }
            level.addDestroyBlockEffect(pos, grass);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity target, InteractionHand pUsedHand) {
        Cow cow;
        MushroomCow mushroomCow;
        if (stack.getItem() == EItems.MYCELIUM_SPORES.get() && target instanceof Cow && (mushroomCow = (MushroomCow)EntityType.MOOSHROOM.create((cow = (Cow)target).level())) != null) {
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
            }
            cow.discard();
            mushroomCow.moveTo(cow.getX(), cow.getY(), cow.getZ());
            mushroomCow.setHealth(cow.getHealth());
            mushroomCow.yBodyRot = cow.yBodyRot;
            if (cow.hasCustomName()) {
                mushroomCow.setCustomName(cow.getCustomName());
                mushroomCow.setCustomNameVisible(cow.isCustomNameVisible());
            }
            if (cow.isPersistenceRequired()) {
                mushroomCow.setPersistenceRequired();
            }
            mushroomCow.setInvulnerable(cow.isInvulnerable());
            cow.level().addFreshEntity((Entity)mushroomCow);
            if (!cow.level().isClientSide) {
                ((ServerLevel)cow.level()).sendParticles((ParticleOptions)ParticleTypes.EXPLOSION, cow.getX(), cow.getY(0.5), cow.getZ(), 1, 0.0, 0.0, 0.0, 0.0);
            }
            cow.playSound(SoundEvents.MOOSHROOM_CONVERT, 2.0f, 1.0f);
        }
        return InteractionResult.PASS;
    }

    public boolean canSpread(BlockState state) {
        return state.is(BlockTags.DIRT);
    }
}

