/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.network;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.level.block.entity.BlockEntityType;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.exdeorum.ExDeorum;
import thedarkcolour.exdeorum.blockentity.EBlockEntity;

record VisualUpdateMessage(BlockPos pos, @Nullable EBlockEntity blockEntity, BlockEntityType<?> blockEntityType, @Nullable RegistryFriendlyByteBuf payload) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<VisualUpdateMessage> TYPE = new CustomPacketPayload.Type(ExDeorum.loc("visual_update"));
    public static final StreamCodec<RegistryFriendlyByteBuf, VisualUpdateMessage> STREAM_CODEC = StreamCodec.of(VisualUpdateMessage::write, VisualUpdateMessage::decode);

    public static void write(RegistryFriendlyByteBuf buffer, VisualUpdateMessage msg) {
        try {
            buffer.writeBlockPos(msg.pos);
            buffer.writeById(arg_0 -> ((Registry)BuiltInRegistries.BLOCK_ENTITY_TYPE).getId(arg_0), msg.blockEntityType);
            int dataBytesIndex = buffer.writerIndex();
            buffer.writeInt(0);
            msg.blockEntity.writeVisualData(buffer);
            int numDataBytes = buffer.writerIndex() - dataBytesIndex - 4;
            buffer.setInt(dataBytesIndex, numDataBytes);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static VisualUpdateMessage decode(RegistryFriendlyByteBuf buffer) {
        return new VisualUpdateMessage(buffer.readBlockPos(), null, (BlockEntityType)buffer.readById(arg_0 -> ((Registry)BuiltInRegistries.BLOCK_ENTITY_TYPE).byId(arg_0)), new RegistryFriendlyByteBuf(buffer.readBytes(buffer.readInt()), buffer.registryAccess()));
    }
}

