/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.exdeorum.recipe.CodecUtil;
import thedarkcolour.exdeorum.recipe.RecipeUtil;

public sealed interface BlockPredicate
extends Predicate<BlockState> {
    public static final byte SINGLE_BLOCK = 0;
    public static final byte BLOCK_STATE = 1;
    public static final byte BLOCK_TAG = 2;
    public static final Codec<BlockPredicate> CODEC = new SpecialCodec();
    public static final StreamCodec<RegistryFriendlyByteBuf, BlockPredicate> STREAM_CODEC = StreamCodec.of(BlockPredicate::writeBlockPredicateNetwork, BlockPredicate::readBlockPredicateNetwork);

    private static void writeBlockPredicateNetwork(RegistryFriendlyByteBuf buffer, BlockPredicate predicate) {
        predicate.toNetwork(buffer);
    }

    private static BlockPredicate readBlockPredicateNetwork(RegistryFriendlyByteBuf buffer) {
        BlockPredicate blockPredicate = BlockPredicate.fromNetwork(buffer);
        if (blockPredicate == null) {
            throw new IllegalStateException("Failed to read block predicate from network");
        }
        return blockPredicate;
    }

    public void toNetwork(RegistryFriendlyByteBuf var1);

    public Stream<BlockState> possibleStates();

    public static BlockPredicate singleBlock(Block block) {
        return new SingleBlockPredicate(block);
    }

    public static BlockPredicate blockState(Block block, StatePropertiesPredicate properties) {
        return new BlockStatePredicate(block, properties);
    }

    public static BlockPredicate blockTag(TagKey<Block> tag) {
        return new TagPredicate(tag);
    }

    @Nullable
    public static BlockPredicate fromNetwork(RegistryFriendlyByteBuf buffer) {
        return switch (buffer.readByte()) {
            case 0 -> new SingleBlockPredicate(Objects.requireNonNull((Block)buffer.readById(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.BLOCK).byId(arg_0))));
            case 1 -> new BlockStatePredicate(Objects.requireNonNull((Block)buffer.readById(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.BLOCK).byId(arg_0))), BlockPredicate.decodeStatePredicate(JsonParser.parseString((String)buffer.readUtf())));
            case 2 -> new TagPredicate(RecipeUtil.readTag((FriendlyByteBuf)buffer, Registries.BLOCK));
            default -> null;
        };
    }

    private static StatePropertiesPredicate decodeStatePredicate(JsonElement json) {
        return (StatePropertiesPredicate)CodecUtil.decode(StatePropertiesPredicate.CODEC, json);
    }

    private static JsonElement encodeStatePredicate(StatePropertiesPredicate predicate) {
        return CodecUtil.encode(StatePropertiesPredicate.CODEC, predicate);
    }

    public record SingleBlockPredicate(Block block) implements BlockPredicate
    {
        @Override
        public void toNetwork(RegistryFriendlyByteBuf buffer) {
            buffer.writeByte((byte)0);
            buffer.writeById(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.BLOCK).getId(arg_0), (Object)this.block);
        }

        @Override
        public boolean test(BlockState state) {
            return state.is(this.block);
        }

        @Override
        public Stream<BlockState> possibleStates() {
            return this.block.getStateDefinition().getPossibleStates().stream();
        }
    }

    public record BlockStatePredicate(Block block, StatePropertiesPredicate properties) implements BlockPredicate
    {
        @Override
        public void toNetwork(RegistryFriendlyByteBuf buffer) {
            buffer.writeByte((byte)1);
            buffer.writeById(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.BLOCK).getId(arg_0), (Object)this.block);
            buffer.writeUtf(BlockPredicate.encodeStatePredicate(this.properties).toString());
        }

        @Override
        public boolean test(BlockState state) {
            return state.is(this.block) && this.properties.matches(state);
        }

        @Override
        public Stream<BlockState> possibleStates() {
            return this.block.getStateDefinition().getPossibleStates().stream().filter(arg_0 -> ((StatePropertiesPredicate)this.properties).matches(arg_0));
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BlockStatePredicate that = (BlockStatePredicate)o;
            return this.block == that.block && Objects.equals(BlockPredicate.encodeStatePredicate(this.properties), BlockPredicate.encodeStatePredicate(that.properties));
        }
    }

    public record TagPredicate(TagKey<Block> tag) implements BlockPredicate
    {
        @Override
        public void toNetwork(RegistryFriendlyByteBuf buffer) {
            buffer.writeByte((byte)2);
            RecipeUtil.writeTag((FriendlyByteBuf)buffer, this.tag);
        }

        @Override
        public boolean test(BlockState state) {
            return state.is(this.tag);
        }

        @Override
        public Stream<BlockState> possibleStates() {
            return StreamSupport.stream(BuiltInRegistries.BLOCK.getTagOrEmpty(this.tag).spliterator(), false).filter(holder -> holder.is(this.tag)).flatMap(holder -> ((Block)holder.value()).getStateDefinition().getPossibleStates().stream());
        }
    }

    public static class SpecialCodec
    implements Codec<BlockPredicate> {
        private static final Codec<TagPredicate> TAG_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)TagKey.codec((ResourceKey)Registries.BLOCK).fieldOf("block_tag").forGetter(TagPredicate::tag)).apply((Applicative)instance, TagPredicate::new));
        private static final Codec<BlockStatePredicate> BLOCK_STATE_CODEC = RecordCodecBuilder.create(instance -> instance.group(CodecUtil.blockField("block", BlockStatePredicate::block), (App)StatePropertiesPredicate.CODEC.fieldOf("state").forGetter(BlockStatePredicate::properties)).apply((Applicative)instance, BlockStatePredicate::new));
        private static final Codec<SingleBlockPredicate> SINGLE_BLOCK_CODEC = RecordCodecBuilder.create(instance -> instance.group(CodecUtil.blockField("block", SingleBlockPredicate::block)).apply((Applicative)instance, SingleBlockPredicate::new));

        public <T> DataResult<Pair<BlockPredicate, T>> decode(DynamicOps<T> ops, T input) {
            DataResult tagResult = TAG_CODEC.decode(ops, input);
            if (tagResult.error().isEmpty()) {
                return CodecUtil.cast(tagResult);
            }
            DataResult stateResult = BLOCK_STATE_CODEC.decode(ops, input);
            if (stateResult.error().isEmpty()) {
                return CodecUtil.cast(stateResult);
            }
            DataResult blockResult = SINGLE_BLOCK_CODEC.decode(ops, input);
            return blockResult.error().isEmpty() ? CodecUtil.cast(blockResult) : DataResult.error(() -> "Invalid block predicate");
        }

        public <T> DataResult<T> encode(BlockPredicate input, DynamicOps<T> ops, T prefix) {
            if (input instanceof SingleBlockPredicate) {
                SingleBlockPredicate block = (SingleBlockPredicate)input;
                return SINGLE_BLOCK_CODEC.encode((Object)block, ops, prefix);
            }
            if (input instanceof BlockStatePredicate) {
                BlockStatePredicate state = (BlockStatePredicate)input;
                return BLOCK_STATE_CODEC.encode((Object)state, ops, prefix);
            }
            return TAG_CODEC.encode((Object)((TagPredicate)input), ops, prefix);
        }
    }
}

