/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.Lazy;
import thedarkcolour.exdeorum.compat.PreferredOres;
import thedarkcolour.exdeorum.recipe.RecipeUtil;
import thedarkcolour.exdeorum.registry.ERecipeSerializers;

public class OreChunkRecipe
implements CraftingRecipe {
    public static final MapCodec<OreChunkRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("ore_chunk").forGetter(OreChunkRecipe::getOreChunk), (App)TagKey.codec((ResourceKey)Registries.ITEM).fieldOf("ore").forGetter(OreChunkRecipe::getOre)).apply((Applicative)instance, OreChunkRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, OreChunkRecipe> STREAM_CODEC = StreamCodec.of(OreChunkRecipe::toNetwork, OreChunkRecipe::fromNetwork);
    private static final List<String> GRID_2X2 = List.of("CC", "CC");
    private final Ingredient oreChunk;
    private final TagKey<Item> ore;
    private final ShapedRecipePattern pattern;
    private final Lazy<ItemStack> resultItem;

    public OreChunkRecipe(Ingredient oreChunk, TagKey<Item> ore) {
        this.oreChunk = oreChunk;
        this.ore = ore;
        this.pattern = ShapedRecipePattern.of(Map.of(Character.valueOf('C'), oreChunk), GRID_2X2);
        this.resultItem = Lazy.of(() -> new ItemStack((ItemLike)PreferredOres.getPreferredOre(this.ore)));
    }

    public Ingredient getOreChunk() {
        return this.oreChunk;
    }

    public TagKey<Item> getOre() {
        return this.ore;
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.pattern.ingredients();
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return (ItemStack)this.resultItem.get();
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider lookup) {
        return ((ItemStack)this.resultItem.get()).copy();
    }

    public boolean matches(CraftingInput container, Level level) {
        return this.pattern.matches(container);
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width >= 2 && height >= 2;
    }

    public CraftingBookCategory category() {
        return CraftingBookCategory.BUILDING;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ERecipeSerializers.ORE_CHUNK.get();
    }

    public static OreChunkRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
        return new OreChunkRecipe((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer), RecipeUtil.readTag((FriendlyByteBuf)buffer, Registries.ITEM));
    }

    public static void toNetwork(RegistryFriendlyByteBuf buffer, OreChunkRecipe recipe) {
        Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.oreChunk);
        RecipeUtil.writeTag((FriendlyByteBuf)buffer, recipe.ore);
    }

    public static class Serializer
    implements RecipeSerializer<OreChunkRecipe> {
        public MapCodec<OreChunkRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, OreChunkRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

