/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.recipe.barrel;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import thedarkcolour.exdeorum.registry.ERecipeSerializers;
import thedarkcolour.exdeorum.registry.ERecipeTypes;

public record BarrelFluidMixingRecipe(SizedFluidIngredient baseFluid, FluidIngredient additiveFluid, ItemStack result, boolean consumesAdditive) implements Recipe<RecipeInput>
{
    public static final MapCodec<BarrelFluidMixingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)SizedFluidIngredient.FLAT_CODEC.fieldOf("base_fluid").forGetter(BarrelFluidMixingRecipe::baseFluid), (App)FluidIngredient.CODEC_NON_EMPTY.fieldOf("additive_fluid").forGetter(BarrelFluidMixingRecipe::additiveFluid), (App)ItemStack.CODEC.fieldOf("result").forGetter(BarrelFluidMixingRecipe::result), (App)Codec.BOOL.optionalFieldOf("consumes_additive", (Object)false).forGetter(BarrelFluidMixingRecipe::consumesAdditive)).apply((Applicative)instance, BarrelFluidMixingRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, BarrelFluidMixingRecipe> STREAM_CODEC = StreamCodec.of(BarrelFluidMixingRecipe::toNetwork, BarrelFluidMixingRecipe::fromNetwork);

    public boolean matches(RecipeInput input, Level level) {
        return false;
    }

    public ItemStack assemble(RecipeInput input, HolderLookup.Provider registries) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return false;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return this.result;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ERecipeSerializers.BARREL_FLUID_MIXING.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ERecipeTypes.BARREL_FLUID_MIXING.get();
    }

    public static void toNetwork(RegistryFriendlyByteBuf buffer, BarrelFluidMixingRecipe recipe) {
        SizedFluidIngredient.STREAM_CODEC.encode((Object)buffer, (Object)recipe.baseFluid);
        FluidIngredient.STREAM_CODEC.encode((Object)buffer, (Object)recipe.additiveFluid);
        ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.result);
        buffer.writeBoolean(recipe.consumesAdditive);
    }

    public static BarrelFluidMixingRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
        SizedFluidIngredient baseFluid = (SizedFluidIngredient)SizedFluidIngredient.STREAM_CODEC.decode((Object)buffer);
        FluidIngredient additiveFluid = (FluidIngredient)FluidIngredient.STREAM_CODEC.decode((Object)buffer);
        ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
        boolean consumesAdditive = buffer.readBoolean();
        return new BarrelFluidMixingRecipe(baseFluid, additiveFluid, result, consumesAdditive);
    }

    public static class Serializer
    implements RecipeSerializer<BarrelFluidMixingRecipe> {
        public MapCodec<BarrelFluidMixingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, BarrelFluidMixingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

