/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.recipe.barrel;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import thedarkcolour.exdeorum.recipe.CodecUtil;
import thedarkcolour.exdeorum.recipe.SingleIngredientRecipe;
import thedarkcolour.exdeorum.registry.ERecipeSerializers;
import thedarkcolour.exdeorum.registry.ERecipeTypes;

public class BarrelMixingRecipe
extends SingleIngredientRecipe {
    public static final MapCodec<BarrelMixingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(CodecUtil.ingredientField(), (App)SizedFluidIngredient.FLAT_CODEC.fieldOf("fluid").forGetter(BarrelMixingRecipe::getFluid), (App)ItemStack.CODEC.fieldOf("result").forGetter(BarrelMixingRecipe::getResult)).apply((Applicative)instance, BarrelMixingRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, BarrelMixingRecipe> STREAM_CODEC = StreamCodec.of(BarrelMixingRecipe::toNetwork, BarrelMixingRecipe::fromNetwork);
    public final SizedFluidIngredient fluid;
    public final ItemStack result;

    public BarrelMixingRecipe(Ingredient ingredient, SizedFluidIngredient fluid, ItemStack result) {
        super(ingredient);
        this.fluid = fluid;
        this.result = result;
    }

    public SizedFluidIngredient getFluid() {
        return this.fluid;
    }

    public ItemStack getResult() {
        return this.result;
    }

    @Override
    @Deprecated
    public boolean matches(RecipeInput inventory, Level level) {
        return false;
    }

    public boolean matches(ItemStack item, FluidStack fluid) {
        return this.ingredient.test(item) && this.fluid.test(fluid);
    }

    @Override
    public ItemStack getResultItem(HolderLookup.Provider access) {
        return this.result;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ERecipeSerializers.BARREL_MIXING.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ERecipeTypes.BARREL_MIXING.get();
    }

    public static void toNetwork(RegistryFriendlyByteBuf buffer, BarrelMixingRecipe recipe) {
        Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.ingredient);
        SizedFluidIngredient.STREAM_CODEC.encode((Object)buffer, (Object)recipe.fluid);
        ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.result);
    }

    public static BarrelMixingRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
        Ingredient ingredient = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
        SizedFluidIngredient fluid = (SizedFluidIngredient)SizedFluidIngredient.STREAM_CODEC.decode((Object)buffer);
        ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
        return new BarrelMixingRecipe(ingredient, fluid, result);
    }

    public static class Serializer
    implements RecipeSerializer<BarrelMixingRecipe> {
        public MapCodec<BarrelMixingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, BarrelMixingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

