/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.recipe.barrel;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IdMapper;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;
import thedarkcolour.exdeorum.recipe.BlockPredicate;
import thedarkcolour.exdeorum.recipe.CodecUtil;
import thedarkcolour.exdeorum.recipe.RecipeUtil;
import thedarkcolour.exdeorum.recipe.WeightedList;
import thedarkcolour.exdeorum.registry.ERecipeSerializers;
import thedarkcolour.exdeorum.registry.ERecipeTypes;

public record FluidTransformationRecipe(FluidIngredient baseFluid, Fluid resultFluid, int resultColor, BlockPredicate catalyst, WeightedList<BlockState> byproducts, int duration) implements Recipe<RecipeInput>
{
    public static final MapCodec<FluidTransformationRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)FluidIngredient.CODEC.fieldOf("base_fluid").forGetter(FluidTransformationRecipe::baseFluid), CodecUtil.fluidField("result_fluid", FluidTransformationRecipe::resultFluid), (App)Codec.INT.fieldOf("result_color").forGetter(FluidTransformationRecipe::resultColor), (App)BlockPredicate.CODEC.fieldOf("catalyst").forGetter(FluidTransformationRecipe::catalyst), (App)WeightedList.codec(Codec.STRING.xmap(RecipeUtil::parseBlockState, RecipeUtil::writeBlockState)).optionalFieldOf("byproducts", WeightedList.empty()).forGetter(FluidTransformationRecipe::byproducts), (App)Codec.INT.fieldOf("duration").forGetter(FluidTransformationRecipe::duration)).apply((Applicative)instance, FluidTransformationRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, FluidTransformationRecipe> STREAM_CODEC = StreamCodec.of(FluidTransformationRecipe::toNetwork, FluidTransformationRecipe::fromNetwork);

    public boolean matches(RecipeInput pContainer, Level pLevel) {
        return false;
    }

    public ItemStack assemble(RecipeInput input, HolderLookup.Provider lookup) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return false;
    }

    public ItemStack getResultItem(HolderLookup.Provider lookup) {
        return ItemStack.EMPTY;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ERecipeSerializers.BARREL_FLUID_TRANSFORMATION.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ERecipeTypes.BARREL_FLUID_TRANSFORMATION.get();
    }

    public static void toNetwork(RegistryFriendlyByteBuf buffer, FluidTransformationRecipe recipe) {
        FluidIngredient.STREAM_CODEC.encode((Object)buffer, (Object)recipe.baseFluid);
        buffer.writeById(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.FLUID).getId(arg_0), (Object)recipe.resultFluid);
        buffer.writeInt(recipe.resultColor);
        recipe.catalyst.toNetwork(buffer);
        recipe.byproducts.toNetwork((FriendlyByteBuf)buffer, (buf, state) -> buf.writeById(arg_0 -> ((IdMapper)Block.BLOCK_STATE_REGISTRY).getId(arg_0), state));
        buffer.writeVarInt(recipe.duration);
    }

    public static FluidTransformationRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
        FluidIngredient baseFluid = (FluidIngredient)FluidIngredient.STREAM_CODEC.decode((Object)buffer);
        Fluid resultFluid = Objects.requireNonNull((Fluid)buffer.readById(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.FLUID).byId(arg_0)));
        int resultColor = buffer.readInt();
        BlockPredicate catalyst = (BlockPredicate)BlockPredicate.STREAM_CODEC.decode((Object)buffer);
        WeightedList<BlockState> byproducts = WeightedList.fromNetwork((FriendlyByteBuf)buffer, buf -> (BlockState)buf.readById(arg_0 -> ((IdMapper)Block.BLOCK_STATE_REGISTRY).byId(arg_0)));
        int duration = buffer.readVarInt();
        return new FluidTransformationRecipe(baseFluid, resultFluid, resultColor, catalyst, byproducts, duration);
    }

    public static class Serializer
    implements RecipeSerializer<FluidTransformationRecipe> {
        public MapCodec<FluidTransformationRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, FluidTransformationRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

