/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.recipe.crucible;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import thedarkcolour.exdeorum.recipe.BlockPredicate;
import thedarkcolour.exdeorum.registry.ERecipeSerializers;
import thedarkcolour.exdeorum.registry.ERecipeTypes;

public record CrucibleHeatRecipe(BlockPredicate blockPredicate, int heatValue) implements Recipe<RecipeInput>
{
    public static final MapCodec<CrucibleHeatRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockPredicate.CODEC.fieldOf("block_predicate").forGetter(CrucibleHeatRecipe::blockPredicate), (App)Codec.INT.fieldOf("heat_value").forGetter(CrucibleHeatRecipe::heatValue)).apply((Applicative)instance, CrucibleHeatRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, CrucibleHeatRecipe> STREAM_CODEC = StreamCodec.of(CrucibleHeatRecipe::toNetwork, CrucibleHeatRecipe::fromNetwork);

    public boolean matches(RecipeInput input, Level level) {
        return false;
    }

    public ItemStack assemble(RecipeInput input, HolderLookup.Provider registries) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return false;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return ItemStack.EMPTY;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ERecipeSerializers.CRUCIBLE_HEAT_SOURCE.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ERecipeTypes.CRUCIBLE_HEAT_SOURCE.get();
    }

    public static void toNetwork(RegistryFriendlyByteBuf buffer, CrucibleHeatRecipe recipe) {
        BlockPredicate.STREAM_CODEC.encode((Object)buffer, (Object)recipe.blockPredicate);
        buffer.writeVarInt(recipe.heatValue);
    }

    public static CrucibleHeatRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
        BlockPredicate blockPredicate = (BlockPredicate)BlockPredicate.STREAM_CODEC.decode((Object)buffer);
        int heatValue = buffer.readVarInt();
        return new CrucibleHeatRecipe(blockPredicate, heatValue);
    }

    public static class Serializer
    implements RecipeSerializer<CrucibleHeatRecipe> {
        public MapCodec<CrucibleHeatRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, CrucibleHeatRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

