/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.block;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.exdeorum.block.ETankBlock;
import thedarkcolour.exdeorum.block.UnfiredCrucibleBlock;
import thedarkcolour.exdeorum.blockentity.AbstractCrucibleBlockEntity;
import thedarkcolour.exdeorum.registry.EBlockEntities;

public abstract class AbstractCrucibleBlock
extends ETankBlock {
    public static final float CRUCIBLE_FLUID_BOTTOM = 0.25f;
    public static final float CRUCIBLE_FLUID_TOP = 0.875f;

    public AbstractCrucibleBlock(BlockBehaviour.Properties properties, Supplier<? extends BlockEntityType<?>> blockEntityType) {
        super(properties, blockEntityType);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return UnfiredCrucibleBlock.SHAPE;
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        BlockEntity blockEntity = level.getExistingBlockEntity(pos);
        if (blockEntity instanceof AbstractCrucibleBlockEntity) {
            AbstractCrucibleBlockEntity crucible = (AbstractCrucibleBlockEntity)blockEntity;
            return crucible.getTank().getFluid().getFluid().getFluidType().getLightLevel();
        }
        return 0;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState pState, BlockEntityType<T> type) {
        return type == EBlockEntities.WATER_CRUCIBLE.get() || type == EBlockEntities.LAVA_CRUCIBLE.get() ? new AbstractCrucibleBlockEntity.Ticker() : null;
    }

    @Override
    protected boolean isEntityInFluid(Level level, BlockPos pos, Entity entity, float fillRatio) {
        float fluidTop = Mth.lerp((float)fillRatio, (float)0.25f, (float)0.875f);
        return entity.getY() < (double)((float)pos.getY() + fluidTop) && entity.getBoundingBox().maxY > (double)((float)pos.getY() + 0.25f);
    }
}

