/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.block;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import thedarkcolour.exdeorum.block.EBlock;
import thedarkcolour.exdeorum.block.WitchWaterBlock;
import thedarkcolour.exdeorum.blockentity.ETankBlockEntity;
import thedarkcolour.exdeorum.registry.EFluids;

public abstract class ETankBlock
extends EBlock {
    public ETankBlock(BlockBehaviour.Properties properties, Supplier<? extends BlockEntityType<?>> blockEntityType) {
        super(properties, blockEntityType);
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        ETankBlockEntity blockEntity;
        IFluidTank tank;
        FluidStack fluid;
        BlockEntity blockEntity2;
        if (!level.isClientSide && (blockEntity2 = level.getBlockEntity(pos)) instanceof ETankBlockEntity && !(fluid = (tank = (blockEntity = (ETankBlockEntity)blockEntity2).getTank()).getFluid()).isEmpty() && this.isEntityInFluid(level, pos, entity, (float)fluid.getAmount() / (float)tank.getCapacity())) {
            ETankBlock.entityInFluidLogic(level, entity, fluid);
        }
    }

    protected abstract boolean isEntityInFluid(Level var1, BlockPos var2, Entity var3, float var4);

    public static void entityInFluidLogic(Level level, Entity entity, FluidStack fluid) {
        Fluid fluidType = fluid.getFluid();
        if (fluidType == Fluids.LAVA) {
            entity.lavaHurt();
        } else if (fluidType == EFluids.WITCH_WATER.get()) {
            WitchWaterBlock.witchWaterEntityEffects(level, entity);
        } else if (fluidType.getFluidType().canExtinguish(entity)) {
            entity.extinguishFire();
        } else if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (ForgeMod.MILK.isPresent() && fluidType == ForgeMod.MILK.get()) {
                living.curePotionEffects(new ItemStack((ItemLike)Items.MILK_BUCKET));
            }
        }
    }
}

