/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.block;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.exdeorum.block.EBlock;
import thedarkcolour.exdeorum.blockentity.AbstractMachineBlockEntity;
import thedarkcolour.exdeorum.blockentity.MechanicalHammerBlockEntity;
import thedarkcolour.exdeorum.config.EConfig;
import thedarkcolour.exdeorum.registry.EBlockEntities;

public class MechanicalHammerBlock
extends EBlock {
    public static final BooleanProperty RUNNING = BooleanProperty.create((String)"running");
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;

    public MechanicalHammerBlock(BlockBehaviour.Properties properties) {
        super(properties, (Supplier<? extends BlockEntityType<?>>)EBlockEntities.MECHANICAL_HAMMER);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)RUNNING, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{RUNNING, FACING});
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return type == EBlockEntities.MECHANICAL_HAMMER.get() && !level.isClientSide ? new AbstractMachineBlockEntity.ServerTicker() : null;
    }

    public void appendHoverText(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        CompoundTag nbt = BlockItem.getBlockEntityData((ItemStack)stack);
        if (nbt != null) {
            CompoundTag inventoryNbt = nbt.getCompound("inventory");
            ItemStackHandler inventory = new ItemStackHandler();
            inventory.deserializeNBT(inventoryNbt);
            ItemStack hammer = inventory.getStackInSlot(1);
            if (!hammer.isEmpty()) {
                tooltip.add((Component)Component.translatable((String)"item.exdeorum.mechanical_hammer.hammer_label").withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)hammer.getDescriptionId())));
            }
            int energy = nbt.getInt("energy");
            tooltip.add((Component)Component.translatable((String)"gui.exdeorum.energy_label").withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)"item.exdeorum.watering_can_fluid_display", (Object[])new Object[]{energy, EConfig.SERVER.mechanicalSieveEnergyStorage.get()})).append(" FE"));
        }
    }

    public void playerWillDestroy(Level level, BlockPos pos, BlockState pState, Player player) {
        BlockEntity blockEntity;
        if (!level.isClientSide && player.isCreative() && level.getGameRules().getBoolean(GameRules.RULE_DOBLOCKDROPS) && (blockEntity = level.getBlockEntity(pos)) instanceof MechanicalHammerBlockEntity) {
            MechanicalHammerBlockEntity sieve = (MechanicalHammerBlockEntity)blockEntity;
            if (!sieve.inventory.getStackInSlot(1).isEmpty()) {
                ItemStack stack = new ItemStack((ItemLike)this);
                BlockItem.setBlockEntityData((ItemStack)stack, (BlockEntityType)((BlockEntityType)EBlockEntities.MECHANICAL_HAMMER.get()), (CompoundTag)sieve.saveWithoutMetadata());
                ItemEntity itemEntity = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, stack);
                itemEntity.setDefaultPickUpDelay();
                level.addFreshEntity((Entity)itemEntity);
            }
        }
        super.playerWillDestroy(level, pos, pState, player);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        CompoundTag nbt = BlockItem.getBlockEntityData((ItemStack)context.getItemInHand());
        BlockState state = this.defaultBlockState();
        if (nbt != null && nbt.contains("progress") && nbt.getInt("progress") != -1) {
            state = (BlockState)state.setValue((Property)RUNNING, (Comparable)Boolean.valueOf(true));
        }
        return (BlockState)state.setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        BlockEntity blockEntity;
        if (!oldState.is(state.getBlock()) && (blockEntity = level.getBlockEntity(pos)) instanceof MechanicalHammerBlockEntity) {
            MechanicalHammerBlockEntity hammer = (MechanicalHammerBlockEntity)blockEntity;
            hammer.checkPoweredState(level, pos);
        }
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof MechanicalHammerBlockEntity) {
            MechanicalHammerBlockEntity hammer = (MechanicalHammerBlockEntity)blockEntity;
            hammer.checkPoweredState(level, pos);
        }
    }
}

