/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.block;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.exdeorum.block.EBlock;
import thedarkcolour.exdeorum.blockentity.AbstractMachineBlockEntity;
import thedarkcolour.exdeorum.blockentity.MechanicalSieveBlockEntity;
import thedarkcolour.exdeorum.config.EConfig;
import thedarkcolour.exdeorum.registry.EBlockEntities;

public class MechanicalSieveBlock
extends EBlock {
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)MechanicalSieveBlock.box((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{MechanicalSieveBlock.box((double)1.0, (double)0.0, (double)1.0, (double)3.0, (double)8.0, (double)3.0), MechanicalSieveBlock.box((double)1.0, (double)0.0, (double)13.0, (double)3.0, (double)8.0, (double)15.0), MechanicalSieveBlock.box((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)3.0), MechanicalSieveBlock.box((double)13.0, (double)0.0, (double)13.0, (double)15.0, (double)8.0, (double)15.0)});

    public MechanicalSieveBlock(BlockBehaviour.Properties properties) {
        super(properties, (Supplier<? extends BlockEntityType<?>>)EBlockEntities.MECHANICAL_SIEVE);
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState pState, BlockEntityType<T> type) {
        return type == EBlockEntities.MECHANICAL_SIEVE.get() && !level.isClientSide ? new AbstractMachineBlockEntity.ServerTicker() : null;
    }

    public void appendHoverText(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        CompoundTag nbt = BlockItem.getBlockEntityData((ItemStack)stack);
        if (nbt != null) {
            CompoundTag inventoryNbt = nbt.getCompound("inventory");
            ItemStackHandler inventory = new ItemStackHandler();
            inventory.deserializeNBT(inventoryNbt);
            ItemStack mesh = inventory.getStackInSlot(1);
            if (!mesh.isEmpty()) {
                tooltip.add((Component)Component.translatable((String)"item.exdeorum.mechanical_sieve.mesh_label").withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)mesh.getDescriptionId())));
            }
            int energy = nbt.getInt("energy");
            tooltip.add((Component)Component.translatable((String)"gui.exdeorum.energy_label").withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)"item.exdeorum.watering_can_fluid_display", (Object[])new Object[]{energy, EConfig.SERVER.mechanicalSieveEnergyStorage.get()})).append(" FE"));
        }
    }

    public void playerWillDestroy(Level level, BlockPos pos, BlockState pState, Player player) {
        MechanicalSieveBlockEntity sieve;
        BlockEntity blockEntity;
        if (!level.isClientSide && player.isCreative() && level.getGameRules().getBoolean(GameRules.RULE_DOBLOCKDROPS) && (blockEntity = level.getBlockEntity(pos)) instanceof MechanicalSieveBlockEntity && !(sieve = (MechanicalSieveBlockEntity)blockEntity).getLogic().getMesh().isEmpty()) {
            ItemStack stack = new ItemStack((ItemLike)this);
            BlockItem.setBlockEntityData((ItemStack)stack, (BlockEntityType)((BlockEntityType)EBlockEntities.MECHANICAL_SIEVE.get()), (CompoundTag)sieve.saveWithoutMetadata());
            ItemEntity itemEntity = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, stack);
            itemEntity.setDefaultPickUpDelay();
            level.addFreshEntity((Entity)itemEntity);
        }
        super.playerWillDestroy(level, pos, pState, player);
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        BlockEntity blockEntity;
        if (!oldState.is(state.getBlock()) && (blockEntity = level.getBlockEntity(pos)) instanceof MechanicalSieveBlockEntity) {
            MechanicalSieveBlockEntity sieve = (MechanicalSieveBlockEntity)blockEntity;
            sieve.checkPoweredState(level, pos);
        }
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof MechanicalSieveBlockEntity) {
            MechanicalSieveBlockEntity sieve = (MechanicalSieveBlockEntity)blockEntity;
            sieve.checkPoweredState(level, pos);
        }
    }

    public boolean isPathfindable(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }
}

