/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.blockentity;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.IdMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.exdeorum.blockentity.BarrelBlockEntity;
import thedarkcolour.exdeorum.blockentity.ETankBlockEntity;
import thedarkcolour.exdeorum.blockentity.WaterCrucibleBlockEntity;
import thedarkcolour.exdeorum.blockentity.helper.FluidHelper;
import thedarkcolour.exdeorum.config.EConfig;
import thedarkcolour.exdeorum.material.AbstractCrucibleMaterial;
import thedarkcolour.exdeorum.recipe.crucible.CrucibleRecipe;
import thedarkcolour.exdeorum.registry.EBlockEntities;
import thedarkcolour.exdeorum.registry.EItems;

public abstract class AbstractCrucibleBlockEntity
extends ETankBlockEntity {
    public static final Lazy<HashMap<Item, Block>> MELT_OVERRIDES = Lazy.concurrentOf(() -> {
        HashMap<Item, Block> map = new HashMap<Item, Block>();
        AbstractCrucibleBlockEntity.addMeltOverrides(map);
        return map;
    });
    public static final int MAX_SOLIDS = 1000;
    public static final int MAX_FLUID_CAPACITY = 4000;
    private final ItemHandler item = new ItemHandler();
    private final FluidHandler tank = new FluidHandler();
    private final LazyOptional<IItemHandler> itemHandler = LazyOptional.of(() -> this.item);
    private final LazyOptional<IFluidHandler> fluidHandler = LazyOptional.of(() -> this.tank);
    @Nullable
    private Block lastMelted;
    @Nullable
    private Fluid fluid = null;
    private short solids;
    private boolean needsLightUpdate;
    public final boolean transparent;

    public AbstractCrucibleBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.transparent = AbstractCrucibleMaterial.TRANSPARENT_CRUCIBLES.contains(state.getBlock());
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (!this.remove) {
            if (cap == ForgeCapabilities.FLUID_HANDLER) {
                return this.fluidHandler.cast();
            }
            if (cap == ForgeCapabilities.ITEM_HANDLER) {
                return this.itemHandler.cast();
            }
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.fluidHandler.invalidate();
        this.itemHandler.invalidate();
    }

    public void saveAdditional(CompoundTag nbt) {
        super.saveAdditional(nbt);
        nbt.put("Tank", (Tag)this.tank.writeToNBT(new CompoundTag()));
        nbt.putString("LastMelted", ForgeRegistries.BLOCKS.getKey((Object)this.lastMelted).toString());
        nbt.putString("Fluid", ForgeRegistries.FLUIDS.getKey((Object)this.fluid).toString());
        nbt.putShort("Solids", this.solids);
    }

    public void load(CompoundTag nbt) {
        super.load(nbt);
        this.tank.readFromNBT(nbt.getCompound("Tank"));
        this.lastMelted = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(nbt.getString("LastMelted")));
        this.fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(nbt.getString("Fluid")));
        this.solids = nbt.getShort("Solids");
        this.needsLightUpdate = true;
    }

    @Override
    public void writeVisualData(FriendlyByteBuf buffer) {
        buffer.writeId((IdMap)BuiltInRegistries.FLUID, (Object)this.tank.getFluid().getFluid());
        buffer.writeVarInt(this.tank.getFluidAmount());
        buffer.writeId((IdMap)BuiltInRegistries.BLOCK, (Object)(this.lastMelted != null ? this.lastMelted : Blocks.AIR));
        buffer.writeShort((int)this.solids);
    }

    @Override
    public void readVisualData(FriendlyByteBuf buffer) {
        Fluid fluid = (Fluid)buffer.readById((IdMap)BuiltInRegistries.FLUID);
        if (fluid == null) {
            this.tank.setFluid(FluidStack.EMPTY);
            buffer.readVarInt();
        } else {
            this.tank.setFluid(new FluidStack(fluid, buffer.readVarInt()));
        }
        Block lastMelted = (Block)buffer.readById((IdMap)BuiltInRegistries.BLOCK);
        this.lastMelted = lastMelted == Blocks.AIR ? null : lastMelted;
        this.solids = buffer.readShort();
    }

    @Override
    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        ItemStack playerItem = player.getItemInHand(hand);
        if (playerItem.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent()) {
            return FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)this.tank) ? InteractionResult.sidedSuccess((boolean)level.isClientSide) : InteractionResult.PASS;
        }
        if (!level.isClientSide) {
            if (playerItem.getItem() == Items.GLASS_BOTTLE && this.getType() == EBlockEntities.WATER_CRUCIBLE.get() && ((Boolean)EConfig.SERVER.allowWaterBottleTransfer.get()).booleanValue()) {
                FluidStack fluid = new FluidStack((Fluid)Fluids.WATER, 250);
                if (this.tank.drain(fluid, IFluidHandler.FluidAction.SIMULATE).getAmount() == 250) {
                    BarrelBlockEntity.extractWaterBottle((IFluidHandler)this.tank, level, player, playerItem, fluid);
                    this.markUpdated();
                }
            } else if (this.canInsertItem(playerItem)) {
                this.tryMelt(playerItem, player.getAbilities().instabuild ? stack -> {} : stack -> stack.shrink(1));
            }
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    @Nullable
    protected abstract CrucibleRecipe getRecipe(ItemStack var1);

    private void tryMelt(ItemStack item, Consumer<ItemStack> shrinkAction) {
        HashMap melts;
        if (item.isEmpty()) {
            return;
        }
        Item meltItem = item.getItem();
        CrucibleRecipe recipe = this.getRecipe(item);
        if (recipe == null) {
            this.item.setStackInSlot(0, ItemStack.EMPTY);
            return;
        }
        FluidStack result = recipe.getResult();
        FluidStack contained = this.tank.getFluid();
        shrinkAction.accept(item);
        this.solids = (short)Math.min(this.solids + result.getAmount(), 1000);
        if (contained.isEmpty()) {
            this.fluid = result.getFluid();
            this.needsLightUpdate = true;
        }
        if ((melts = (HashMap)MELT_OVERRIDES.get()).containsKey(meltItem)) {
            this.lastMelted = (Block)melts.get(meltItem);
        } else if (meltItem.getClass() == BlockItem.class) {
            this.lastMelted = ((BlockItem)meltItem).getBlock();
        } else if (this.lastMelted == null) {
            this.lastMelted = this.getDefaultMeltBlock();
        }
        this.markUpdated();
    }

    private boolean canInsertItem(ItemStack item) {
        if (item.isEmpty()) {
            return false;
        }
        CrucibleRecipe recipe = this.getRecipe(item);
        if (recipe != null) {
            FluidStack contained;
            FluidStack result = recipe.getResult();
            return (result.isFluidEqual(contained = this.tank.getFluid()) || contained.isEmpty()) && result.getAmount() + this.solids <= 1000;
        }
        return false;
    }

    public abstract int getMeltingRate();

    public int getSolids() {
        return this.solids;
    }

    public FluidTank getTank() {
        return this.tank;
    }

    public abstract Block getDefaultMeltBlock();

    @Nullable
    public Block getLastMelted() {
        return this.lastMelted;
    }

    public void setRemoved() {
        this.itemHandler.invalidate();
        this.fluidHandler.invalidate();
        super.setRemoved();
    }

    private static void addMeltOverrides(HashMap<Item, Block> overrides) {
        overrides.put(Items.OAK_SAPLING, Blocks.OAK_LEAVES);
        overrides.put(Items.SPRUCE_SAPLING, Blocks.SPRUCE_LEAVES);
        overrides.put(Items.ACACIA_SAPLING, Blocks.ACACIA_LEAVES);
        overrides.put(Items.JUNGLE_SAPLING, Blocks.JUNGLE_LEAVES);
        overrides.put(Items.DARK_OAK_SAPLING, Blocks.DARK_OAK_LEAVES);
        overrides.put(Items.BIRCH_SAPLING, Blocks.BIRCH_LEAVES);
        overrides.put(Items.CHERRY_SAPLING, Blocks.CHERRY_LEAVES);
        overrides.put(Items.MANGROVE_PROPAGULE, Blocks.MANGROVE_LEAVES);
        overrides.put(Items.SWEET_BERRIES, Blocks.SPRUCE_LEAVES);
        overrides.put(Items.GLOW_BERRIES, Blocks.MOSS_BLOCK);
        overrides.put((Item)EItems.GRASS_SEEDS.get(), Blocks.GRASS_BLOCK);
        overrides.put((Item)EItems.MYCELIUM_SPORES.get(), Blocks.MYCELIUM);
        overrides.put((Item)EItems.WARPED_NYLIUM_SPORES.get(), Blocks.WARPED_NYLIUM);
        overrides.put((Item)EItems.CRIMSON_NYLIUM_SPORES.get(), Blocks.CRIMSON_NYLIUM);
        for (Map.Entry sapling : ForgeRegistries.BLOCKS.getEntries()) {
            ResourceLocation key;
            Item item = ((Block)sapling.getValue()).asItem();
            if (overrides.containsKey(item) || !(key = ((ResourceKey)sapling.getKey()).location()).getPath().endsWith("sapling")) continue;
            try {
                overrides.put(item, (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(key.getNamespace(), key.getPath().replace("sapling", "leaves"))));
            }
            catch (Exception exception) {}
        }
    }

    private class ItemHandler
    extends ItemStackHandler {
        private ItemHandler() {
        }

        protected void onContentsChanged(int slot) {
            AbstractCrucibleBlockEntity.this.tryMelt(this.getItem(), item -> this.setStackInSlot(0, ItemStack.EMPTY));
        }

        protected int getStackLimit(int slot, @NotNull ItemStack stack) {
            return 1;
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return AbstractCrucibleBlockEntity.this.canInsertItem(stack);
        }

        public ItemStack getItem() {
            return (ItemStack)this.stacks.get(0);
        }
    }

    private static class FluidHandler
    extends FluidHelper {
        public FluidHandler() {
            super(4000);
        }

        public boolean isFluidValid(FluidStack stack) {
            return false;
        }
    }

    public static class Ticker
    implements BlockEntityTicker<AbstractCrucibleBlockEntity> {
        public void tick(Level level, BlockPos pos, BlockState state, AbstractCrucibleBlockEntity crucible) {
            if (crucible.needsLightUpdate) {
                level.getLightEngine().checkBlock(crucible.worldPosition);
                crucible.needsLightUpdate = false;
            }
            if (!level.isClientSide) {
                FluidHandler tank = crucible.tank;
                if (level.getGameTime() % 10L == 0L) {
                    short delta = (short)Math.min(crucible.solids, crucible.getMeltingRate());
                    if (delta <= 0) {
                        return;
                    }
                    if (tank.getSpace() >= delta) {
                        crucible.solids = (short)(crucible.solids - delta);
                        if (tank.isEmpty()) {
                            if (crucible.fluid != null) {
                                tank.setFluid(new FluidStack(crucible.fluid, (int)delta));
                                crucible.needsLightUpdate = true;
                            }
                        } else {
                            tank.getFluid().grow((int)delta);
                        }
                        crucible.markUpdated();
                    }
                }
                if (((Boolean)EConfig.SERVER.cruciblesCollectRainWater.get()).booleanValue() && tank.getFluidAmount() < 4000 && crucible instanceof WaterCrucibleBlockEntity && level.isRainingAt(pos.above())) {
                    BarrelBlockEntity.fillRainWater(crucible, tank);
                }
            }
        }
    }
}

