/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.blockentity;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BowlFoodItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3i;
import thedarkcolour.exdeorum.blockentity.EBlockEntity;
import thedarkcolour.exdeorum.blockentity.ETankBlockEntity;
import thedarkcolour.exdeorum.blockentity.helper.FluidHelper;
import thedarkcolour.exdeorum.client.CompostColors;
import thedarkcolour.exdeorum.config.EConfig;
import thedarkcolour.exdeorum.material.BarrelMaterial;
import thedarkcolour.exdeorum.recipe.RecipeUtil;
import thedarkcolour.exdeorum.recipe.barrel.BarrelCompostRecipe;
import thedarkcolour.exdeorum.recipe.barrel.BarrelFluidMixingRecipe;
import thedarkcolour.exdeorum.recipe.barrel.BarrelMixingRecipe;
import thedarkcolour.exdeorum.recipe.barrel.FluidTransformationRecipe;
import thedarkcolour.exdeorum.registry.EBlockEntities;
import thedarkcolour.exdeorum.registry.ESounds;

public class BarrelBlockEntity
extends ETankBlockEntity {
    private static final int MOSS_SPREAD_RANGE = 2;
    private static final int MAX_CAPACITY = 1000;
    private final ItemHandler item = new ItemHandler();
    private final FluidHandler tank = new FluidHandler();
    public float progress;
    public short compost;
    public short r;
    public short g;
    public short b;
    private boolean isBeingFilledByPlayer;
    public final boolean transparent;
    @Nullable
    public FluidTransformationRecipe currentTransformRecipe = null;
    private final LazyOptional<IItemHandler> itemHandler = LazyOptional.of(() -> this.item);
    private final LazyOptional<IFluidHandler> fluidHandler = LazyOptional.of(() -> this.tank);

    public BarrelBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EBlockEntities.BARREL.get(), pos, state);
        this.transparent = BarrelMaterial.TRANSPARENT_BARRELS.contains(state.getBlock());
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidHandler.cast();
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.fluidHandler.invalidate();
        this.itemHandler.invalidate();
    }

    public void saveAdditional(CompoundTag nbt) {
        super.saveAdditional(nbt);
        nbt.put("item", (Tag)this.item.serializeNBT());
        nbt.put("tank", (Tag)this.tank.writeToNBT(new CompoundTag()));
        nbt.putShort("compost", this.compost);
        nbt.putFloat("progress", this.progress);
        nbt.putShort("r", this.r);
        nbt.putShort("g", this.g);
        nbt.putShort("b", this.b);
    }

    public void load(CompoundTag nbt) {
        super.load(nbt);
        this.item.deserializeNBT(nbt.getCompound("item"));
        this.tank.readFromNBT(nbt.getCompound("tank"));
        this.compost = nbt.getShort("compost");
        this.progress = nbt.getFloat("progress");
        this.r = nbt.getShort("r");
        this.g = nbt.getShort("g");
        this.b = nbt.getShort("b");
    }

    @Override
    public void writeVisualData(FriendlyByteBuf buffer) {
        buffer.writeItem(this.item.getStackInSlot(0));
        buffer.writeFluidStack(this.tank.getFluid());
        buffer.writeShort((int)this.compost);
        buffer.writeFloat(this.progress);
        buffer.writeShort((int)this.r);
        buffer.writeShort((int)this.g);
        buffer.writeShort((int)this.b);
    }

    @Override
    public void readVisualData(FriendlyByteBuf buffer) {
        this.item.setStackInSlot(0, buffer.readItem());
        this.tank.setFluid(buffer.readFluidStack());
        this.compost = buffer.readShort();
        this.progress = buffer.readFloat();
        this.r = buffer.readShort();
        this.g = buffer.readShort();
        this.b = buffer.readShort();
    }

    public boolean isBrewing() {
        return this.tank.getFluidAmount() == 1000 && this.progress != 0.0f && !this.isBurning();
    }

    public boolean isBurning() {
        return this.getBlockState().ignitedByLava() && BarrelBlockEntity.isHotFluid(this.tank.getFluid().getFluid().getFluidType()) && this.progress != 0.0f;
    }

    public boolean isComposting() {
        return this.compost == 1000;
    }

    public boolean hasNoSolids() {
        return this.compost <= 0 && this.item.getStackInSlot(0).isEmpty();
    }

    public boolean hasFullWater() {
        return this.tank.getFluidAmount() == 1000 && this.tank.getFluid().getFluid().is(FluidTags.WATER);
    }

    public static boolean isHotFluid(FluidType fluidType) {
        return fluidType.getTemperature() > 575;
    }

    private void spawnParticlesIfBurning() {
        if (this.isBurning()) {
            BlockPos pos = this.getBlockPos();
            int burnTicks = (int)(this.progress * 300.0f);
            if (burnTicks % 30 == 0) {
                this.level.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)pos.getX() + Math.random(), (double)pos.getY() + 1.2, (double)pos.getZ() + Math.random(), 0.0, 0.0, 0.0);
            } else if (burnTicks % 5 == 0) {
                this.level.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)pos.getX() + Math.random(), (double)pos.getY() + 1.2, (double)pos.getZ() + Math.random(), 0.0, 0.0, 0.0);
            }
        }
    }

    public ItemStack getItem() {
        return this.item.getStackInSlot(0);
    }

    private void setItem(ItemStack item) {
        this.item.setStackInSlot(0, item);
    }

    @Override
    public IFluidTank getTank() {
        return this.tank;
    }

    @Override
    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        if (!this.getItem().isEmpty()) {
            return this.giveResultItem(level);
        }
        if (this.hasNoSolids()) {
            Optional itemFluidCapOptional;
            boolean wasBurning = this.isBurning();
            this.isBeingFilledByPlayer = true;
            if (FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)this.tank)) {
                this.isBeingFilledByPlayer = false;
                this.tryInWorldFluidMixing();
                this.markUpdated();
                if (wasBurning && !BarrelBlockEntity.isHotFluid(this.tank.getFluid().getFluid().getFluidType())) {
                    this.progress = 0.0f;
                }
                return InteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            this.isBeingFilledByPlayer = false;
            ItemStack playerItem = player.getItemInHand(hand);
            if (((Boolean)EConfig.SERVER.allowWaterBottleTransfer.get()).booleanValue()) {
                FluidStack fluid = new FluidStack((Fluid)Fluids.WATER, 250);
                if (playerItem.getItem() == Items.POTION && PotionUtils.getPotion((ItemStack)playerItem) == Potions.WATER) {
                    CompoundTag nbt = playerItem.getTag().copy();
                    nbt.remove("Potion");
                    fluid = new FluidStack((Fluid)Fluids.WATER, 250, nbt);
                    if (this.tank.fill(fluid, IFluidHandler.FluidAction.SIMULATE) > 0) {
                        if (!player.getAbilities().instabuild) {
                            playerItem.shrink(1);
                            ItemStack emptyBottle = new ItemStack((ItemLike)Items.GLASS_BOTTLE);
                            if (!player.addItem(emptyBottle)) {
                                player.drop(emptyBottle, false);
                            }
                        }
                        this.tank.fill(fluid, IFluidHandler.FluidAction.EXECUTE);
                        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.BOTTLE_FILL, SoundSource.NEUTRAL, 1.0f, 1.0f);
                        this.markUpdated();
                        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
                    }
                } else if (playerItem.getItem() == Items.GLASS_BOTTLE) {
                    FluidStack currentFluid = this.tank.getFluid();
                    if (currentFluid.getRawFluid() == Fluids.WATER) {
                        fluid.setTag(currentFluid.getTag());
                    }
                    if (this.tank.drain(fluid, IFluidHandler.FluidAction.SIMULATE).getAmount() == 250) {
                        BarrelBlockEntity.extractWaterBottle((IFluidHandler)this.tank, level, player, playerItem, fluid);
                        this.markUpdated();
                        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
                    }
                }
            }
            if ((itemFluidCapOptional = playerItem.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).resolve()).isPresent()) {
                IFluidHandlerItem itemFluidCap = (IFluidHandlerItem)itemFluidCapOptional.get();
                FluidStack itemFluid = itemFluidCap.drain(1000, IFluidHandler.FluidAction.SIMULATE);
                BarrelFluidMixingRecipe recipe = RecipeUtil.getFluidMixingRecipe(this.tank.getFluid(), itemFluid.getFluid());
                if (recipe != null && this.tank.getFluidAmount() >= recipe.baseFluidAmount && itemFluid.getAmount() == 1000) {
                    if (!level.isClientSide) {
                        this.tank.drain(recipe.baseFluidAmount, IFluidHandler.FluidAction.EXECUTE);
                        ItemStack result = new ItemStack((ItemLike)recipe.result);
                        result.setTag(recipe.getResultNbt());
                        this.setItem(result);
                        if (recipe.consumesAdditive) {
                            itemFluidCap.drain(1000, IFluidHandler.FluidAction.EXECUTE);
                            if (!player.getAbilities().instabuild) {
                                playerItem.shrink(1);
                                ItemStack container = itemFluidCap.getContainer();
                                if (!container.isEmpty() && !player.addItem(container)) {
                                    player.drop(container, false);
                                }
                            }
                        }
                    }
                    return InteractionResult.sidedSuccess((boolean)level.isClientSide);
                }
            }
        }
        ItemStack playerItem = player.getItemInHand(hand);
        if (!level.isClientSide) {
            ItemStack handItem = this.item.insertItem(0, player.getAbilities().instabuild ? playerItem.copy() : playerItem, false);
            if (!player.getAbilities().instabuild) {
                player.setItemInHand(hand, handItem);
                this.giveResultItem(level);
            }
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    protected static void extractWaterBottle(IFluidHandler tank, Level level, Player player, ItemStack playerItem, FluidStack fluid) {
        if (!player.getAbilities().instabuild) {
            playerItem.shrink(1);
        }
        ItemStack bottle = PotionUtils.setPotion((ItemStack)new ItemStack((ItemLike)Items.POTION), (Potion)Potions.WATER);
        CompoundTag nbt = bottle.getOrCreateTag();
        nbt.merge(fluid.getOrCreateTag());
        if (!player.addItem(bottle)) {
            player.drop(bottle, false);
        }
        tank.drain(fluid, IFluidHandler.FluidAction.EXECUTE);
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.BOTTLE_EMPTY, SoundSource.NEUTRAL, 1.0f, 1.0f);
    }

    private InteractionResult giveResultItem(Level level) {
        if (!level.isClientSide) {
            BarrelBlockEntity.popOutItem(level, this.worldPosition, this.item.extract(false));
            this.setItem(ItemStack.EMPTY);
            this.markUpdated();
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    private static void popOutItem(Level level, BlockPos pos, ItemStack stack) {
        if (!level.isClientSide && !stack.isEmpty()) {
            RandomSource rand = level.random;
            ItemEntity itemEntity = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 1.5, (double)pos.getZ() + 0.5, stack);
            itemEntity.setDeltaMovement(rand.nextGaussian() * 0.05, 0.2, rand.nextGaussian() * 0.05);
            level.addFreshEntity((Entity)itemEntity);
        }
    }

    private boolean tryCrafting(ItemStack input, boolean simulate) {
        boolean crafted = false;
        if (!this.tank.isEmpty()) {
            crafted = this.tryMixing(input, simulate);
        } else if (!this.isComposting()) {
            crafted = this.tryComposting(input, simulate);
        }
        if (crafted) {
            if (!simulate) {
                this.markUpdated();
            }
            return true;
        }
        return false;
    }

    private boolean tryMixing(ItemStack playerItem, boolean simulate) {
        if (this.isBurning()) {
            return false;
        }
        BarrelMixingRecipe recipe = RecipeUtil.getBarrelMixingRecipe(this.level.getRecipeManager(), playerItem, this.tank.getFluid());
        if (recipe != null) {
            if (!simulate) {
                this.tank.drain(recipe.fluidAmount, IFluidHandler.FluidAction.EXECUTE);
                ItemStack result = new ItemStack((ItemLike)recipe.result);
                result.setTag(recipe.getResultNbt());
                this.setItem(result);
                this.level.playSound(null, this.worldPosition, (SoundEvent)ESounds.BARREL_MIXING.get(), SoundSource.BLOCKS, 0.8f, 1.0f);
            }
            return true;
        }
        return false;
    }

    private boolean tryComposting(ItemStack stack, boolean simulate) {
        if (simulate) {
            return RecipeUtil.isCompostable(stack);
        }
        BarrelCompostRecipe recipe = RecipeUtil.getBarrelCompostRecipe(stack);
        if (recipe != null) {
            this.addCompost(stack, recipe.getVolume());
            return true;
        }
        return false;
    }

    private void addCompost(ItemStack playerItem, int volume) {
        short oldCompost = this.compost;
        this.compost = (short)Math.min(1000, this.compost + volume);
        if (this.compost != 0) {
            if (!CompostColors.isLoaded()) {
                CompostColors.loadColors();
            }
            float weightNew = (float)(this.compost - oldCompost) / (float)this.compost;
            float weightOld = 1.0f - weightNew;
            Vector3i color = (Vector3i)CompostColors.COLORS.getOrDefault((Object)playerItem.getItem(), (Object)CompostColors.DEFAULT_COLOR);
            this.r = (short)(weightNew * (float)color.x + weightOld * (float)this.r);
            this.g = (short)(weightNew * (float)color.y + weightOld * (float)this.g);
            this.b = (short)(weightNew * (float)color.z + weightOld * (float)this.b);
        }
        this.level.playSound(null, this.worldPosition, (SoundEvent)ESounds.BARREL_ADD_COMPOST.get(), SoundSource.BLOCKS);
    }

    public void tryInWorldFluidMixing() {
        BlockPos abovePos;
        BlockState aboveBlockState;
        FluidState aboveFluidState;
        Fluid aboveFluid;
        if (!this.level.isClientSide && !this.tank.isEmpty() && this.item.getStackInSlot(0).isEmpty() && (aboveFluid = (aboveFluidState = (aboveBlockState = this.level.getBlockState(abovePos = this.worldPosition.above())).getFluidState()).getType()) != Fluids.EMPTY) {
            Fluid fluid;
            FluidStack fluidStack = this.tank.getFluid();
            if (aboveFluid instanceof FlowingFluid) {
                FlowingFluid flowing = (FlowingFluid)aboveFluid;
                fluid = flowing.getSource();
            } else {
                fluid = aboveFluid;
            }
            BarrelFluidMixingRecipe recipe = RecipeUtil.getFluidMixingRecipe(fluidStack, fluid);
            if (recipe != null) {
                if (!recipe.consumesAdditive) {
                    this.tank.drain(recipe.baseFluidAmount, IFluidHandler.FluidAction.EXECUTE);
                    this.setItem(new ItemStack((ItemLike)recipe.result));
                } else {
                    BucketPickup pickup;
                    Block block = aboveBlockState.getBlock();
                    if (block instanceof BucketPickup && !(pickup = (BucketPickup)block).pickupBlock((LevelAccessor)this.level, abovePos, aboveBlockState).isEmpty()) {
                        this.tank.drain(recipe.baseFluidAmount, IFluidHandler.FluidAction.EXECUTE);
                        this.setItem(new ItemStack((ItemLike)recipe.result));
                    }
                }
            }
        }
    }

    public void updateFluidTransform() {
        if (!this.level.isClientSide) {
            if (this.tank.getFluidAmount() != 1000) {
                this.currentTransformRecipe = null;
            } else {
                BlockState belowState = this.level.getBlockState(this.worldPosition.below());
                this.currentTransformRecipe = RecipeUtil.getFluidTransformationRecipe(this.tank.getFluid().getFluid(), belowState);
                if (this.currentTransformRecipe != null) {
                    int color = this.currentTransformRecipe.resultColor;
                    this.r = (short)(color >> 16 & 0xFF);
                    this.g = (short)(color >> 8 & 0xFF);
                    this.b = (short)(color & 0xFF);
                    this.markUpdated();
                }
            }
            this.progress = 0.0f;
        }
    }

    public static void fillRainWater(EBlockEntity block, FluidHelper tank) {
        if (tank.isEmpty()) {
            tank.setFluid(new FluidStack((Fluid)Fluids.WATER, 1));
            block.markUpdated();
        } else if (tank.getFluid().getFluid() == Fluids.WATER) {
            tank.getFluid().grow(1);
            block.markUpdated();
        }
    }

    private static float getProgressStep() {
        return ((Double)EConfig.SERVER.barrelProgressStep.get()).floatValue();
    }

    private void doCompost() {
        this.progress += BarrelBlockEntity.getProgressStep();
        this.markUpdated();
        if (this.progress >= 1.0f) {
            this.progress = 0.0f;
            this.compost = 0;
            this.setItem(new ItemStack((ItemLike)Items.DIRT));
            this.level.playSound(null, this.worldPosition, (SoundEvent)ESounds.BARREL_COMPOST.get(), SoundSource.BLOCKS);
        }
    }

    private static ItemStack getRemainderItem(ItemStack stack) {
        return stack.getItem() instanceof BowlFoodItem || stack.getItem() == Items.SUSPICIOUS_STEW ? new ItemStack((ItemLike)Items.BOWL) : stack.getCraftingRemainingItem();
    }

    public void onLoad() {
        this.tryInWorldFluidMixing();
        this.updateFluidTransform();
    }

    private class ItemHandler
    extends ItemStackHandler {
        private ItemHandler() {
        }

        protected int getStackLimit(int slot, ItemStack stack) {
            return 1;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return BarrelBlockEntity.this.tryCrafting(stack, true);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (stack.isEmpty()) {
                return ItemStack.EMPTY;
            }
            this.validateSlotIndex(slot);
            if (!((ItemStack)this.stacks.get(slot)).isEmpty()) {
                return stack;
            }
            if (BarrelBlockEntity.this.tryCrafting(stack, simulate)) {
                if (stack.getCount() == 1) {
                    return BarrelBlockEntity.getRemainderItem(stack);
                }
                BarrelBlockEntity.popOutItem(BarrelBlockEntity.this.level, BarrelBlockEntity.this.worldPosition, BarrelBlockEntity.getRemainderItem(stack));
                return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.getCount() - 1));
            }
            return stack;
        }

        public ItemStack extract(boolean simulate) {
            return this.extractItem(0, 64, simulate);
        }

        protected void onContentsChanged(int slot) {
            if (!((BarrelBlockEntity)BarrelBlockEntity.this).level.isClientSide) {
                BarrelBlockEntity.this.markUpdated();
            }
        }
    }

    private class FluidHandler
    extends FluidHelper {
        public FluidHandler() {
            super(1000);
        }

        public boolean isFluidValid(FluidStack stack) {
            return !BarrelBlockEntity.this.isBrewing() && BarrelBlockEntity.this.hasNoSolids();
        }

        protected void onContentsChanged() {
            if (!BarrelBlockEntity.this.isBeingFilledByPlayer) {
                BarrelBlockEntity.this.tryInWorldFluidMixing();
                BarrelBlockEntity.this.markUpdated();
            }
            BarrelBlockEntity.this.updateFluidTransform();
        }
    }

    public static class Ticker
    implements BlockEntityTicker<BarrelBlockEntity> {
        public void tick(Level level, BlockPos pos, BlockState state, BarrelBlockEntity barrel) {
            if (!level.isClientSide) {
                FluidHandler tank = barrel.tank;
                if (barrel.isComposting()) {
                    barrel.doCompost();
                } else if (BarrelBlockEntity.isHotFluid(tank.getFluid().getFluid().getFluidType()) && state.ignitedByLava()) {
                    float f;
                    barrel.progress += BarrelBlockEntity.getProgressStep();
                    if (f >= 1.0f) {
                        if (tank.getFluidAmount() == 1000) {
                            Fluid fluid = tank.getFluid().getFluid();
                            level.setBlockAndUpdate(pos, fluid.getFluidType().getBlockForFluidState((BlockAndTintGetter)level, pos, fluid.defaultFluidState()));
                        } else {
                            level.setBlockAndUpdate(pos, Blocks.FIRE.defaultBlockState());
                        }
                    }
                    barrel.markUpdated();
                } else if (barrel.currentTransformRecipe != null) {
                    FluidTransformationRecipe recipe = barrel.currentTransformRecipe;
                    int catalysts = 0;
                    for (BlockPos cursor : BlockPos.betweenClosed((int)(pos.getX() - 1), (int)(pos.getY() - 1), (int)(pos.getZ() - 1), (int)(pos.getX() + 1), (int)(pos.getY() - 1), (int)(pos.getZ() + 1))) {
                        BlockState byproduct;
                        BlockPos above;
                        RandomSource rand;
                        if (!recipe.catalyst.test(level.getBlockState(cursor))) continue;
                        ++catalysts;
                        if (recipe.byproducts.isEmpty() || (rand = level.random).nextInt(1500) != 0 || !level.getBlockState(above = cursor.above()).isAir() || !(byproduct = recipe.byproducts.getRandom(rand)).canSurvive((LevelReader)level, above)) continue;
                        level.setBlockAndUpdate(above, byproduct);
                    }
                    if (catalysts == 0) {
                        barrel.currentTransformRecipe = null;
                    } else {
                        barrel.progress += (float)catalysts * (1.0f / (float)barrel.currentTransformRecipe.duration);
                        if (barrel.progress >= 0.99999f) {
                            barrel.progress = 0.0f;
                            level.playSound(null, pos, (SoundEvent)ESounds.BARREL_FLUID_TRANSFORM.get(), SoundSource.BLOCKS, 1.0f, 0.6f);
                            tank.setFluid(FluidStack.EMPTY);
                            tank.fill(new FluidStack(recipe.resultFluid, 1000), IFluidHandler.FluidAction.EXECUTE);
                        }
                        barrel.markUpdated();
                    }
                } else if (((Boolean)EConfig.SERVER.barrelsCollectRainWater.get()).booleanValue() && tank.getFluidAmount() < 1000 && level.isRainingAt(pos.above()) && barrel.item.getStackInSlot(0).isEmpty() && barrel.compost == 0) {
                    BarrelBlockEntity.fillRainWater(barrel, tank);
                    if (tank.getFluidAmount() == 1000) {
                        barrel.updateFluidTransform();
                    }
                } else if (barrel.hasFullWater() && tank.getFluid().getFluid().getFluidType() == ForgeMod.WATER_TYPE.get()) {
                    RandomSource rand = level.random;
                    if (state.ignitedByLava() && rand.nextInt(500) == 0) {
                        BlockPos randomPos = pos.offset(rand.nextIntBetweenInclusive(-2, 2), -1, rand.nextIntBetweenInclusive(-2, 2));
                        Block randomBlock = level.getBlockState(randomPos).getBlock();
                        if (randomBlock == Blocks.COBBLESTONE) {
                            level.setBlock(randomPos, Blocks.MOSSY_COBBLESTONE.defaultBlockState(), 3);
                        } else if (randomBlock == Blocks.STONE_BRICKS) {
                            level.setBlock(randomPos, Blocks.MOSSY_STONE_BRICKS.defaultBlockState(), 3);
                        }
                    }
                }
            } else {
                barrel.spawnParticlesIfBurning();
            }
        }
    }
}

