/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.blockentity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import thedarkcolour.exdeorum.block.InfestedLeavesBlock;
import thedarkcolour.exdeorum.blockentity.EBlockEntity;
import thedarkcolour.exdeorum.registry.EBlockEntities;
import thedarkcolour.exdeorum.registry.EBlocks;

public class InfestedLeavesBlockEntity
extends EBlockEntity {
    public static final float PROGRESS_INTERVAL = 0.005f;
    public static final int SPREAD_INTERVAL = 40;
    private float progress;
    private int spreadTimer;
    private BlockState mimic = Blocks.OAK_LEAVES.defaultBlockState();

    public InfestedLeavesBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EBlockEntities.INFESTED_LEAVES.get(), pos, state);
    }

    @Override
    public void writeVisualData(FriendlyByteBuf buffer) {
        buffer.writeFloat(this.progress);
    }

    @Override
    public void readVisualData(FriendlyByteBuf buffer) {
        buffer.readFloat();
    }

    private void trySpread(Level level) {
        int x = level.random.nextInt(3) - 1;
        int y = level.random.nextInt(3) - 1;
        int z = level.random.nextInt(3) - 1;
        BlockPos targetPos = this.getBlockPos().offset(x, y, z);
        BlockState state = level.getBlockState(targetPos);
        if (state.is(BlockTags.LEAVES) && state.getBlock() != EBlocks.INFESTED_LEAVES.get()) {
            InfestedLeavesBlock.setBlock(level, targetPos, state);
            BlockEntity te = level.getBlockEntity(targetPos);
            if (te instanceof InfestedLeavesBlockEntity) {
                InfestedLeavesBlockEntity leaves = (InfestedLeavesBlockEntity)te;
                leaves.setMimic(state);
                leaves.setChanged();
            }
        }
    }

    public void load(CompoundTag nbt) {
        super.load(nbt);
        HolderLookup.RegistryLookup holderLookup = this.level != null ? this.level.holderLookup(Registries.BLOCK) : BuiltInRegistries.BLOCK.asLookup();
        this.mimic = NbtUtils.readBlockState((HolderGetter)holderLookup, (CompoundTag)nbt.getCompound("mimic"));
        this.progress = nbt.getFloat("progress");
    }

    public void saveAdditional(CompoundTag nbt) {
        super.saveAdditional(nbt);
        if (this.mimic == null || this.mimic.getBlock() == EBlocks.INFESTED_LEAVES.get()) {
            this.mimic = Blocks.OAK_LEAVES.defaultBlockState();
        }
        nbt.put("mimic", (Tag)NbtUtils.writeBlockState((BlockState)this.mimic));
        nbt.putFloat("progress", this.progress);
    }

    public float getProgress() {
        return this.progress;
    }

    public void setProgress(float progress) {
        this.progress = progress;
    }

    public BlockState getMimic() {
        return this.mimic;
    }

    public void setMimic(BlockState mimic) {
        this.mimic = mimic;
    }

    public static class Ticker
    implements BlockEntityTicker<InfestedLeavesBlockEntity> {
        public void tick(Level level, BlockPos pos, BlockState state, InfestedLeavesBlockEntity leaves) {
            if (leaves.progress < 1.0f) {
                leaves.progress = Math.min(1.0f, leaves.progress + 0.005f);
                if (leaves.progress == 1.0f) {
                    level.setBlock(pos, (BlockState)state.setValue((Property)InfestedLeavesBlock.FULLY_INFESTED, (Comparable)Boolean.valueOf(true)), 1);
                }
            }
            if (!level.isClientSide && leaves.progress > 0.6f) {
                ++leaves.spreadTimer;
                if (leaves.spreadTimer >= 40) {
                    leaves.trySpread(level);
                    leaves.spreadTimer = level.random.nextInt(10);
                }
            }
        }
    }
}

