/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.blockentity;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.exdeorum.block.MechanicalHammerBlock;
import thedarkcolour.exdeorum.blockentity.AbstractMachineBlockEntity;
import thedarkcolour.exdeorum.blockentity.MechanicalHammerMenu;
import thedarkcolour.exdeorum.blockentity.helper.ItemHelper;
import thedarkcolour.exdeorum.config.EConfig;
import thedarkcolour.exdeorum.loot.HammerLootModifier;
import thedarkcolour.exdeorum.recipe.RecipeUtil;
import thedarkcolour.exdeorum.recipe.hammer.HammerRecipe;
import thedarkcolour.exdeorum.registry.EBlockEntities;
import thedarkcolour.exdeorum.tag.EItemTags;

public class MechanicalHammerBlockEntity
extends AbstractMachineBlockEntity<MechanicalHammerBlockEntity> {
    private static final Component TITLE = Component.translatable((String)"exdeorum.container.mechanical_hammer");
    private static final int INPUT_SLOT = 0;
    public static final int HAMMER_SLOT = 1;
    private static final int OUTPUT_SLOT = 2;
    public static final int TOTAL_PROGRESS = 10000000;
    private static final int PROGRESS_INTERVAL = 50000;
    public static final int NOT_RUNNING = -1;
    private int progress = -1;
    private float efficiency;

    public MechanicalHammerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EBlockEntities.MECHANICAL_HAMMER.get(), pos, state, ItemHandler::new, (Integer)EConfig.SERVER.mechanicalHammerEnergyStorage.get());
    }

    public static boolean isValidInput(ItemStack stack) {
        return RecipeUtil.getHammerRecipe(stack.getItem()) != null;
    }

    @Override
    protected void saveAdditional(CompoundTag nbt) {
        super.saveAdditional(nbt);
        nbt.putInt("progress", this.progress);
    }

    @Override
    public void load(CompoundTag nbt) {
        super.load(nbt);
        this.progress = nbt.getInt("progress");
        this.onHammerChanged();
    }

    public Component getDisplayName() {
        return TITLE;
    }

    public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player pPlayer) {
        return new MechanicalHammerMenu(containerId, playerInventory, this);
    }

    @Override
    protected boolean isRunning() {
        return this.progress != -1;
    }

    @Override
    protected void tryStartRunning() {
        ItemStack input = this.inventory.getStackInSlot(0);
        if (!input.isEmpty() && this.canFitResultIntoOutput(input) != null) {
            this.progress = 0;
            this.level.setBlock(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)MechanicalHammerBlock.RUNNING, (Comparable)Boolean.valueOf(true)), 3);
            return;
        }
        if (((Boolean)this.getBlockState().getValue((Property)MechanicalHammerBlock.RUNNING)).booleanValue()) {
            this.level.setBlock(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)MechanicalHammerBlock.RUNNING, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    @Override
    protected void noEnergyTick() {
        if (((Boolean)this.getBlockState().getValue((Property)MechanicalHammerBlock.RUNNING)).booleanValue()) {
            this.level.setBlock(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)MechanicalHammerBlock.RUNNING, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    @Nullable
    private HammerRecipe canFitResultIntoOutput(ItemStack input) {
        HammerRecipe recipe;
        ItemStack output = this.inventory.getStackInSlot(2);
        if ((output.isEmpty() || output.getCount() < output.getMaxStackSize()) && (recipe = RecipeUtil.getHammerRecipe(input.getItem())) != null && (output.isEmpty() || MechanicalHammerBlockEntity.matchesStack(recipe.result, recipe.getRawResultNbt(), output))) {
            return recipe;
        }
        return null;
    }

    private static boolean matchesStack(Item item, @Nullable CompoundTag itemNbt, ItemStack stack) {
        return Objects.equals(itemNbt, stack.getTag()) && item == stack.getItem();
    }

    @Override
    protected void runMachineTick() {
        ItemStack input = this.inventory.getStackInSlot(0);
        if (!input.isEmpty()) {
            this.progress += (int)(50000.0f * this.efficiency);
            if (this.progress >= 10000000) {
                HammerRecipe recipe = this.canFitResultIntoOutput(input);
                if (recipe != null) {
                    LootContext ctx = RecipeUtil.emptyLootContext((ServerLevel)this.level);
                    int resultCount = recipe.resultAmount.getInt(ctx);
                    resultCount += HammerLootModifier.calculateFortuneBonus(this.inventory.getStackInSlot(1), ctx.getRandom(), resultCount == 0);
                    ItemStack output = this.inventory.getStackInSlot(2);
                    if (output.isEmpty()) {
                        ItemStack stack = new ItemStack((ItemLike)recipe.result, resultCount);
                        stack.setTag(recipe.getResultNbt());
                        this.inventory.setStackInSlot(2, stack);
                    } else {
                        output.setCount(Math.min(output.getMaxStackSize(), resultCount + output.getCount()));
                    }
                    input.shrink(1);
                    this.damageHammer(ctx.getRandom());
                    this.setChanged();
                }
                this.progress = -1;
            }
        } else {
            this.level.setBlock(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)MechanicalHammerBlock.RUNNING, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    private void damageHammer(RandomSource rand) {
        ItemStack hammer = this.inventory.getStackInSlot(1);
        if (hammer.isDamageableItem() && hammer.hurt(1, rand, null)) {
            hammer.shrink(1);
            if (hammer.isEmpty()) {
                this.inventory.setStackInSlot(1, ItemStack.EMPTY);
            }
        }
    }

    private void onHammerChanged() {
        ItemStack hammer = this.inventory.getStackInSlot(1);
        this.efficiency = hammer.isEmpty() ? 1.0f : 2.0f + (float)hammer.getEnchantmentLevel(Enchantments.BLOCK_EFFICIENCY) * 0.33f;
    }

    @Override
    protected int getEnergyConsumption() {
        return (Integer)EConfig.SERVER.mechanicalHammerEnergyConsumption.get();
    }

    public int getGuiProgress() {
        return Math.round((float)(24 * this.progress) / 1.0E7f);
    }

    public void setGuiProgress(int guiProgress) {
        this.progress = guiProgress * 10000000 / 24;
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    private static class ItemHandler
    extends ItemHelper {
        private final MechanicalHammerBlockEntity hammer;

        public ItemHandler(MechanicalHammerBlockEntity hammer) {
            super(3);
            this.hammer = hammer;
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            if (slot == 0) {
                return RecipeUtil.getHammerRecipe(stack.getItem()) != null;
            }
            if (slot == 1) {
                return stack.is(EItemTags.HAMMERS);
            }
            return false;
        }

        public int getSlotLimit(int slot) {
            return slot == 1 ? 1 : super.getSlotLimit(slot);
        }

        @Override
        public boolean canMachineExtract(int slot) {
            return slot == 2;
        }

        protected void onContentsChanged(int slot) {
            if (slot == 1) {
                this.hammer.onHammerChanged();
            } else if (slot == 0 && this.getStackInSlot(0).isEmpty()) {
                this.hammer.progress = -1;
            }
        }
    }
}

