/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.blockentity;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.ItemHandlerHelper;
import thedarkcolour.exdeorum.blockentity.AbstractMachineBlockEntity;
import thedarkcolour.exdeorum.blockentity.AbstractSieveBlockEntity;
import thedarkcolour.exdeorum.blockentity.helper.ItemHelper;
import thedarkcolour.exdeorum.blockentity.logic.SieveLogic;
import thedarkcolour.exdeorum.config.EConfig;
import thedarkcolour.exdeorum.menu.MechanicalSieveMenu;
import thedarkcolour.exdeorum.recipe.RecipeUtil;
import thedarkcolour.exdeorum.registry.EBlockEntities;
import thedarkcolour.exdeorum.tag.EItemTags;

public class MechanicalSieveBlockEntity
extends AbstractMachineBlockEntity<MechanicalSieveBlockEntity>
implements SieveLogic.Owner {
    private static final Component TITLE = Component.translatable((String)"exdeorum.container.mechanical_sieve");
    private static final int INPUT_SLOT = 0;
    public static final int MESH_SLOT = 1;
    private final SieveLogic logic = new SieveLogic(this, true);

    public MechanicalSieveBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EBlockEntities.MECHANICAL_SIEVE.get(), pos, state, ItemHandler::new, (Integer)EConfig.SERVER.mechanicalSieveEnergyStorage.get());
    }

    @Override
    protected void saveAdditional(CompoundTag nbt) {
        super.saveAdditional(nbt);
        this.logic.saveNbt(nbt);
    }

    @Override
    public void load(CompoundTag nbt) {
        super.load(nbt);
        this.logic.loadNbt(nbt);
    }

    @Override
    protected boolean isRunning() {
        return !this.logic.getContents().isEmpty();
    }

    @Override
    protected void tryStartRunning() {
        ItemStack input = this.inventory.getStackInSlot(0);
        if (this.logic.isValidInput(input)) {
            this.logic.startSifting(AbstractSieveBlockEntity.singleCopy(input));
            input.shrink(1);
        }
    }

    @Override
    protected void runMachineTick() {
        this.logic.sift(0.01f, Long.MAX_VALUE);
    }

    @Override
    protected int getEnergyConsumption() {
        return (Integer)EConfig.SERVER.mechanicalSieveEnergyConsumption.get();
    }

    @Override
    public void writeVisualData(FriendlyByteBuf buffer) {
        buffer.writeItem(this.logic.getMesh());
        buffer.writeFloat(this.logic.getProgress());
        buffer.writeItem(this.logic.getContents());
    }

    @Override
    public void readVisualData(FriendlyByteBuf buffer) {
        this.logic.setMesh(buffer.readItem(), false);
        this.logic.setProgress(buffer.readFloat());
        this.logic.setContents(buffer.readItem());
    }

    @Override
    public boolean handleResultItem(ItemStack result, ServerLevel level, RandomSource rand) {
        ItemStack remainder = result.copy();
        for (int i = 2; i < 22; ++i) {
            boolean splitRemainder;
            ItemStack existing = this.inventory.getStackInSlot(i);
            int limit = this.inventory.getSlotLimit(i);
            if (!existing.isEmpty()) {
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)remainder, (ItemStack)existing)) continue;
                limit -= existing.getCount();
            }
            if (limit <= 0) continue;
            boolean bl = splitRemainder = remainder.getCount() > limit;
            if (existing.isEmpty()) {
                this.inventory.setStackInSlot(i, splitRemainder ? ItemHandlerHelper.copyStackWithSize((ItemStack)remainder, (int)limit) : remainder);
            } else {
                existing.grow(splitRemainder ? limit : remainder.getCount());
            }
            if (splitRemainder) {
                remainder = ItemHandlerHelper.copyStackWithSize((ItemStack)remainder, (int)(remainder.getCount() - limit));
                continue;
            }
            return true;
        }
        return remainder.getCount() < result.getCount();
    }

    public Component getDisplayName() {
        return TITLE;
    }

    public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player pPlayer) {
        return new MechanicalSieveMenu(containerId, playerInventory, this);
    }

    @Override
    public SieveLogic getLogic() {
        return this.logic;
    }

    @Override
    public ServerLevel getServerLevel() {
        return (ServerLevel)this.level;
    }

    private static class ItemHandler
    extends ItemHelper {
        private final MechanicalSieveBlockEntity sieve;

        public ItemHandler(MechanicalSieveBlockEntity sieve) {
            super(22);
            this.sieve = sieve;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            if (slot == 0) {
                return !RecipeUtil.getSieveRecipes(this.getStackInSlot(1).getItem(), stack).isEmpty();
            }
            if (slot == 1) {
                return stack.is(EItemTags.SIEVE_MESHES);
            }
            return false;
        }

        public int getSlotLimit(int slot) {
            return slot == 1 ? 1 : super.getSlotLimit(slot);
        }

        @Override
        public boolean canMachineExtract(int slot) {
            return slot > 1;
        }

        protected void onContentsChanged(int slot) {
            if (slot == 1) {
                this.sieve.logic.setMesh(this.sieve.inventory.getStackInSlot(1));
            }
        }

        protected void onLoad() {
            this.sieve.logic.setMesh(this.sieve.inventory.getStackInSlot(1), false);
        }
    }
}

