/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.client.gui.screens.worldselection.WorldCreationUiState;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Unit;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RegisterShadersEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import thedarkcolour.exdeorum.ExDeorum;
import thedarkcolour.exdeorum.asm.ASMHooks;
import thedarkcolour.exdeorum.client.RenderUtil;
import thedarkcolour.exdeorum.client.screen.MechanicalHammerScreen;
import thedarkcolour.exdeorum.client.screen.MechanicalSieveScreen;
import thedarkcolour.exdeorum.client.ter.BarrelRenderer;
import thedarkcolour.exdeorum.client.ter.CompressedSieveRenderer;
import thedarkcolour.exdeorum.client.ter.CrucibleRenderer;
import thedarkcolour.exdeorum.client.ter.InfestedLeavesRenderer;
import thedarkcolour.exdeorum.client.ter.SieveRenderer;
import thedarkcolour.exdeorum.config.EConfig;
import thedarkcolour.exdeorum.network.ClientMessageHandler;
import thedarkcolour.exdeorum.recipe.RecipeUtil;
import thedarkcolour.exdeorum.registry.EBlockEntities;
import thedarkcolour.exdeorum.registry.EFluids;
import thedarkcolour.exdeorum.registry.EMenus;

public class ClientHandler {
    public static final ResourceLocation OAK_BARREL_COMPOSTING = new ResourceLocation("exdeorum", "item/oak_barrel_composting");
    public static boolean needsRecipeCacheRefresh;
    public static Holder<WorldPreset> originalDefaultWorldPreset;

    public static void register() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus fmlBus = MinecraftForge.EVENT_BUS;
        modBus.addListener(ClientHandler::clientSetup);
        modBus.addListener(ClientHandler::registerRenderers);
        modBus.addListener(ClientHandler::registerShaders);
        modBus.addListener(ClientHandler::addClientReloadListeners);
        modBus.addListener(ClientHandler::onConfigChanged);
        fmlBus.addListener(ClientHandler::onPlayerRespawn);
        fmlBus.addListener(ClientHandler::onPlayerLogout);
        fmlBus.addListener(ClientHandler::onScreenOpen);
        fmlBus.addListener(ClientHandler::onTagsUpdated);
        if (ModList.get().isLoaded("jei") || ModList.get().isLoaded("emi")) {
            modBus.addListener(ClientHandler::registerAdditionalModels);
        }
    }

    private static void onTagsUpdated(TagsUpdatedEvent event) {
        if (needsRecipeCacheRefresh && Minecraft.getInstance().getConnection() != null) {
            RecipeUtil.reload(Minecraft.getInstance().getConnection().getRecipeManager());
            needsRecipeCacheRefresh = false;
        }
    }

    private static void addClientReloadListeners(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((prepBarrier, resourceManager, prepProfiler, reloadProfiler, backgroundExecutor, gameExecutor) -> prepBarrier.wait((Object)Unit.INSTANCE).thenRunAsync(RenderUtil::reload, gameExecutor));
    }

    private static void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ClientHandler.setRenderLayers();
            MenuScreens.register((MenuType)((MenuType)EMenus.MECHANICAL_SIEVE.get()), MechanicalSieveScreen::new);
            MenuScreens.register((MenuType)((MenuType)EMenus.MECHANICAL_HAMMER.get()), MechanicalHammerScreen::new);
        });
    }

    private static void setRenderLayers() {
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)EFluids.WITCH_WATER.get()), (RenderType)RenderType.translucent());
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)EFluids.WITCH_WATER_FLOWING.get()), (RenderType)RenderType.translucent());
    }

    private static void onPlayerRespawn(ClientPlayerNetworkEvent.Clone event) {
        if (ClientMessageHandler.isInVoidWorld) {
            ClientMessageHandler.disableVoidFogRendering();
        }
    }

    private static void onPlayerLogout(ClientPlayerNetworkEvent.LoggingOut event) {
        ClientMessageHandler.isInVoidWorld = false;
        needsRecipeCacheRefresh = false;
    }

    private static void onConfigChanged(ModConfigEvent.Reloading event) {
        if (event.getConfig().getSpec() == EConfig.CLIENT_SPEC) {
            RenderSystem.recordRenderCall(() -> Minecraft.getInstance().levelRenderer.allChanged());
        }
    }

    private static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)EBlockEntities.INFESTED_LEAVES.get(), ctx -> new InfestedLeavesRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)EBlockEntities.BARREL.get(), BarrelRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)EBlockEntities.LAVA_CRUCIBLE.get(), ctx -> new CrucibleRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)EBlockEntities.WATER_CRUCIBLE.get(), ctx -> new CrucibleRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)EBlockEntities.SIEVE.get(), ctx -> new SieveRenderer(0.75f, 15.0f));
        event.registerBlockEntityRenderer((BlockEntityType)EBlockEntities.MECHANICAL_SIEVE.get(), ctx -> new SieveRenderer(0.75f, 15.0f));
        event.registerBlockEntityRenderer((BlockEntityType)EBlockEntities.COMPRESSED_SIEVE.get(), ctx -> new CompressedSieveRenderer(0.5625f, 16.0f));
    }

    private static void registerShaders(RegisterShadersEvent event) {
        try {
            event.registerShader(new ShaderInstance(event.getResourceProvider(), new ResourceLocation("exdeorum", "rendertype_tinted_cutout_mipped"), DefaultVertexFormat.NEW_ENTITY), instance -> {
                RenderUtil.renderTypeTintedCutoutMippedShader = instance;
            });
        }
        catch (IOException e) {
            ExDeorum.LOGGER.error("Unable to load tinted shader", (Throwable)e);
        }
    }

    private static void onScreenOpen(ScreenEvent.Opening event) {
        Screen screen = event.getNewScreen();
        if (screen instanceof CreateWorldScreen) {
            WorldCreationUiState uiState;
            Holder originalPreset;
            CreateWorldScreen screen2 = (CreateWorldScreen)screen;
            if (((Boolean)EConfig.COMMON.setVoidWorldAsDefault.get()).booleanValue() && (originalPreset = (uiState = screen2.getUiState()).getWorldType().preset()) != null) {
                if (originalDefaultWorldPreset == null) {
                    originalDefaultWorldPreset = originalPreset;
                }
                if (originalDefaultWorldPreset.unwrapKey().equals(originalPreset.unwrapKey())) {
                    Holder.Reference voidWorldPreset = uiState.getSettings().worldgenLoadContext().registryOrThrow(Registries.WORLD_PRESET).getHolder(ASMHooks.overrideDefaultWorldPreset()).orElse(null);
                    uiState.setWorldType(new WorldCreationUiState.WorldTypeEntry((Holder)voidWorldPreset));
                }
            }
        }
    }

    private static void registerAdditionalModels(ModelEvent.RegisterAdditional event) {
        event.register(new ResourceLocation("exdeorum", "block/oak_barrel_composting"));
        event.register(OAK_BARREL_COMPOSTING);
    }
}

