/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.client.screen;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.exdeorum.blockentity.MechanicalHammerBlockEntity;
import thedarkcolour.exdeorum.blockentity.MechanicalHammerMenu;
import thedarkcolour.exdeorum.client.screen.RedstoneControlWidget;
import thedarkcolour.exdeorum.config.EConfig;
import thedarkcolour.exdeorum.menu.AbstractMachineMenu;

public class MechanicalHammerScreen
extends AbstractContainerScreen<MechanicalHammerMenu> {
    private static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("exdeorum", "textures/gui/container/mechanical_hammer.png");
    public static final int RECIPE_CLICK_AREA_POS_X = 80;
    public static final int RECIPE_CLICK_AREA_POS_Y = 34;
    public static final int RECIPE_CLICK_AREA_WIDTH = 23;
    public static final int RECIPE_CLICK_AREA_HEIGHT = 16;
    @Nullable
    private RedstoneControlWidget redstoneControlWidget;

    public MechanicalHammerScreen(MechanicalHammerMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageWidth = 176;
        this.imageHeight = 166;
    }

    protected void init() {
        super.init();
        this.redstoneControlWidget = new RedstoneControlWidget((AbstractMachineMenu)this.menu, BACKGROUND_TEXTURE, this.leftPos + this.imageWidth, this.topPos + 3);
        this.addRenderableWidget(this.redstoneControlWidget);
    }

    @Nullable
    public RedstoneControlWidget getRedstoneControlWidget() {
        return this.redstoneControlWidget;
    }

    protected void renderBg(GuiGraphics graphics, float pPartialTick, int pMouseX, int pMouseY) {
        int left = this.leftPos;
        int top = this.topPos;
        graphics.blit(BACKGROUND_TEXTURE, left, top, 0, 0, this.imageWidth, this.imageHeight);
        int energy = Mth.floor((float)(54.0f * ((float)((MechanicalHammerMenu)this.menu).prevEnergy / (float)((Integer)EConfig.SERVER.mechanicalSieveEnergyStorage.get()).intValue())));
        graphics.blit(BACKGROUND_TEXTURE, left + 10, top + 15 + 54 - energy, this.imageWidth, 70 - energy, 12, energy);
        int progress = Math.min(23, ((MechanicalHammerBlockEntity)((MechanicalHammerMenu)this.menu).machine).getGuiProgress());
        graphics.blit(BACKGROUND_TEXTURE, left + 80, top + 34, this.imageWidth, 0, progress, 16);
    }

    public void render(GuiGraphics graphics, int mx, int my, float pPartialTick) {
        this.renderBackground(graphics);
        super.render(graphics, mx, my, pPartialTick);
        this.renderTooltip(graphics, mx, my);
        int rx = mx - this.leftPos;
        int ry = my - this.topPos;
        if (9 <= rx && rx < 23 && 14 <= ry && ry < 70) {
            MutableComponent energyTooltip = Component.translatable((String)"gui.exdeorum.energy_label").append((Component)Component.translatable((String)"item.exdeorum.watering_can_fluid_display", (Object[])new Object[]{((MechanicalHammerMenu)this.menu).prevEnergy, EConfig.SERVER.mechanicalSieveEnergyStorage.get()})).append(" FE");
            graphics.renderTooltip(Minecraft.getInstance().font, (Component)energyTooltip, mx, my);
        }
    }
}

