/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.client.ter;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import thedarkcolour.exdeorum.ExDeorum;
import thedarkcolour.exdeorum.blockentity.BarrelBlockEntity;
import thedarkcolour.exdeorum.client.RenderUtil;
import thedarkcolour.exdeorum.config.EConfig;

public class BarrelRenderer
implements BlockEntityRenderer<BarrelBlockEntity> {
    public static final ResourceLocation COMPOST_DIRT_TEXTURE = new ResourceLocation("exdeorum", "block/compost_dirt");
    private final BlockRenderDispatcher blockRenderer;
    private final ItemRenderer itemRenderer;

    public BarrelRenderer(BlockEntityRendererProvider.Context ctx) {
        this.blockRenderer = ctx.getBlockRenderDispatcher();
        this.itemRenderer = ctx.getItemRenderer();
    }

    public void render(BarrelBlockEntity barrel, float partialTicks, PoseStack stack, MultiBufferSource buffers, int light, int overlay) {
        ItemStack item = barrel.getItem();
        Item item2 = item.getItem();
        if (item2 instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item2;
            Block block = blockItem.getBlock();
            BlockState state = block.defaultBlockState();
            stack.pushPose();
            stack.translate(0.125f, 0.125f, 0.125f);
            stack.scale(0.75f, 0.75f, 0.75f);
            this.blockRenderer.renderSingleBlock(state, stack, buffers, light, overlay, ModelData.EMPTY, null);
            stack.popPose();
        } else {
            stack.pushPose();
            stack.translate(0.5, 0.09375 + (double)((float)barrel.getTank().getFluidAmount() / 1000.0f * 13.0f / 16.0f), 0.5);
            stack.mulPose(Axis.XP.rotation(1.5707964f));
            this.itemRenderer.renderStatic(item, ItemDisplayContext.FIXED, light, OverlayTexture.NO_OVERLAY, stack, buffers, null, 0);
            stack.popPose();
        }
        barrel.getCapability(ForgeCapabilities.FLUID_HANDLER).ifPresent(tank -> {
            FluidStack fluidStack = tank.getFluidInTank(0);
            if (!fluidStack.isEmpty()) {
                Fluid fluid = fluidStack.getFluid();
                Level level = barrel.getLevel();
                BlockPos pos = barrel.getBlockPos();
                float percentage = (float)fluidStack.getAmount() / 1000.0f;
                float y = Mth.lerp((float)percentage, (float)0.0625f, (float)0.875f);
                int inputFluidColor = RenderUtil.getFluidColor(fluid, level, pos);
                int r = inputFluidColor >> 16 & 0xFF;
                int g = inputFluidColor >> 8 & 0xFF;
                int b = inputFluidColor & 0xFF;
                if (barrel.isBrewing()) {
                    float progress = barrel.progress;
                    r = (int)Mth.lerp((float)progress, (float)r, (float)barrel.r);
                    g = (int)Mth.lerp((float)progress, (float)g, (float)barrel.g);
                    b = (int)Mth.lerp((float)progress, (float)b, (float)barrel.b);
                }
                if (barrel.transparent) {
                    RenderUtil.renderFluidCuboid(buffers, stack, level, pos, 0.0625f, y, 2.0f, light, r, g, b, fluid);
                } else {
                    RenderUtil.renderFlatFluidSprite(buffers, stack, level, pos, y, 2.0f, light, r, g, b, fluid);
                }
            }
        });
        if (barrel.compost > 0) {
            int b;
            int g;
            int r;
            TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(COMPOST_DIRT_TEXTURE);
            VertexConsumer builder = buffers.getBuffer(RenderType.solid());
            float compostProgress = barrel.progress;
            if (ExDeorum.IS_JUNE && ((Boolean)EConfig.CLIENT.rainbowCompostDuringJune.get()).booleanValue() && barrel.getLevel() != null) {
                Color rainbow = RenderUtil.getRainbowColor(barrel.getLevel().getGameTime(), partialTicks);
                r = rainbow.getRed();
                g = rainbow.getGreen();
                b = rainbow.getBlue();
            } else {
                r = barrel.r;
                g = barrel.g;
                b = barrel.b;
            }
            r = (int)Mth.lerp((float)compostProgress, (float)r, (float)238.0f);
            g = (int)Mth.lerp((float)compostProgress, (float)g, (float)169.0f);
            b = (int)Mth.lerp((float)compostProgress, (float)b, (float)109.0f);
            RenderUtil.renderFlatSpriteLerp(builder, stack, (float)barrel.compost / 1000.0f, r, g, b, sprite, light, 2.0f, 1.0f, 14.0f);
        }
    }
}

