/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.compat;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.client.RenderTypeHelper;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import thedarkcolour.exdeorum.client.ClientHandler;
import thedarkcolour.exdeorum.material.DefaultMaterials;
import thedarkcolour.exdeorum.registry.EBlocks;

public class ClientXeiUtil {
    private static final ItemStack OAK_BARREL = new ItemStack((ItemLike)DefaultMaterials.OAK_BARREL.getItem());
    private static final FluidState EMPTY = Fluids.EMPTY.defaultFluidState();
    private static final BlockState AIR = Blocks.AIR.defaultBlockState();
    private static final Vector3f L1 = new Vector3f(0.4f, 0.0f, 1.0f).normalize();
    private static final Vector3f L2 = new Vector3f(-0.4f, 1.0f, -0.2f).normalize();

    public static void renderItemAlternativeModel(GuiGraphics graphics, BakedModel model, ItemStack stack, int xOffset, int yOffset) {
        Minecraft mc = Minecraft.getInstance();
        PoseStack pose = graphics.pose();
        pose.pushPose();
        pose.translate((float)(8 + xOffset), (float)(8 + yOffset), 150.0f);
        try {
            boolean flag;
            pose.mulPoseMatrix(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
            pose.scale(16.0f, 16.0f, 16.0f);
            boolean bl = flag = !model.usesBlockLight();
            if (flag) {
                Lighting.setupForFlatItems();
            }
            mc.getItemRenderer().render(stack, ItemDisplayContext.GUI, false, pose, (MultiBufferSource)graphics.bufferSource(), 0xF000F0, OverlayTexture.NO_OVERLAY, model);
            graphics.flush();
            if (flag) {
                Lighting.setupFor3DItems();
            }
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.forThrowable((Throwable)throwable, (String)"Rendering item");
            CrashReportCategory crashreportcategory = crashreport.addCategory("Item being rendered");
            crashreportcategory.setDetail("Item Type", () -> String.valueOf(stack.getItem()));
            crashreportcategory.setDetail("Registry Name", () -> BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString());
            throw new ReportedException(crashreport);
        }
        pose.popPose();
        RenderSystem.disableBlend();
    }

    public static void renderFilledCompostBarrel(GuiGraphics guiGraphics, int xOffset, int yOffset) {
        RenderSystem.enableDepthTest();
        Minecraft mc = Minecraft.getInstance();
        BakedModel model = mc.getModelManager().getModel(ClientHandler.OAK_BARREL_COMPOSTING);
        ClientXeiUtil.renderItemAlternativeModel(guiGraphics, model, OAK_BARREL, xOffset, yOffset);
        RenderSystem.disableDepthTest();
    }

    public static void renderBlock(GuiGraphics guiGraphics, BlockState state, float x, float y, float z, float scale) {
        PoseStack poseStack = guiGraphics.pose();
        poseStack.translate(x, y, z);
        poseStack.scale(-scale, -scale, -scale);
        poseStack.translate(-0.5f, -0.5f, 0.0f);
        poseStack.mulPose(Axis.XP.rotationDegrees(-30.0f));
        poseStack.translate(0.5f, 0.0f, -0.5f);
        poseStack.mulPose(Axis.YP.rotationDegrees(45.0f));
        poseStack.translate(-0.5f, 0.0f, 0.5f);
        poseStack.pushPose();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.translate(0.0f, 0.0f, -1.0f);
        FluidState fluidState = state.getFluidState();
        if (fluidState.isEmpty()) {
            MultiBufferSource.BufferSource buffers = Minecraft.getInstance().renderBuffers().bufferSource();
            RenderSystem.setupGui3DDiffuseLighting((Vector3f)L1, (Vector3f)L2);
            if (state.is((Block)EBlocks.INFESTED_LEAVES.get())) {
                BlockRenderDispatcher blockRenderer = Minecraft.getInstance().getBlockRenderer();
                BakedModel bakedmodel = blockRenderer.getBlockModel(state);
                for (RenderType renderType : bakedmodel.getRenderTypes(state, RandomSource.create((long)42L), ModelData.EMPTY)) {
                    blockRenderer.getModelRenderer().renderModel(poseStack.last(), buffers.getBuffer(RenderTypeHelper.getEntityRenderType((RenderType)renderType, (boolean)false)), state, bakedmodel, 1.0f, 1.0f, 1.0f, 0xF000F0, OverlayTexture.NO_OVERLAY, ModelData.EMPTY, renderType);
                }
            } else {
                Minecraft.getInstance().getBlockRenderer().renderSingleBlock(state, poseStack, (MultiBufferSource)buffers, 0xF000F0, OverlayTexture.NO_OVERLAY);
            }
            buffers.endBatch();
        } else {
            RenderType renderType = ItemBlockRenderTypes.getRenderLayer((FluidState)fluidState);
            PoseStack modelView = RenderSystem.getModelViewStack();
            Tesselator tesselator = Tesselator.getInstance();
            BufferBuilder builder = tesselator.getBuilder();
            renderType.setupRenderState();
            modelView.pushPose();
            modelView.mulPoseMatrix(poseStack.last().pose());
            RenderSystem.applyModelViewMatrix();
            builder.begin(renderType.mode(), renderType.format());
            Dummy.tempState = state;
            Dummy.tempFluid = fluidState;
            Minecraft.getInstance().getBlockRenderer().renderLiquid(BlockPos.ZERO, (BlockAndTintGetter)Dummy.INSTANCE, (VertexConsumer)builder, state, state.getFluidState());
            Dummy.tempFluid = EMPTY;
            Dummy.tempState = AIR;
            if (builder.building()) {
                tesselator.end();
            }
            renderType.clearRenderState();
            modelView.popPose();
            RenderSystem.applyModelViewMatrix();
        }
        poseStack.popPose();
    }

    public static void renderItemWithAsterisk(GuiGraphics graphics, ItemStack stack) {
        Minecraft mc = Minecraft.getInstance();
        BakedModel model = mc.getItemRenderer().getModel(stack, (Level)mc.level, null, 0);
        ClientXeiUtil.renderItemAlternativeModel(graphics, model, stack, 0, 0);
        ClientXeiUtil.renderAsterisk(graphics, 0, 0);
    }

    public static void renderAsterisk(GuiGraphics graphics, int xOffset, int yOffset) {
        graphics.pose().pushPose();
        graphics.pose().translate(0.0f, 0.0f, 200.0f);
        Font font = Minecraft.getInstance().font;
        graphics.drawString(font, "*", xOffset + 19 - 2 - font.width("*"), yOffset + 12, 0xFF5555, true);
        graphics.pose().popPose();
    }

    private static enum Dummy implements BlockAndTintGetter
    {
        INSTANCE;

        private static BlockState tempState;
        private static FluidState tempFluid;

        public float getShade(Direction pDirection, boolean pShade) {
            return 1.0f;
        }

        public LevelLightEngine getLightEngine() {
            return Minecraft.getInstance().level.getLightEngine();
        }

        public int getBlockTint(BlockPos pBlockPos, ColorResolver pColorResolver) {
            return 0;
        }

        public int getBrightness(LightLayer pLightType, BlockPos pBlockPos) {
            return 15;
        }

        public int getRawBrightness(BlockPos pBlockPos, int pAmount) {
            return 15;
        }

        @Nullable
        public BlockEntity getBlockEntity(BlockPos pPos) {
            return null;
        }

        public BlockState getBlockState(BlockPos pos) {
            return pos.equals((Object)BlockPos.ZERO) ? tempState : AIR;
        }

        public FluidState getFluidState(BlockPos pos) {
            return pos.equals((Object)BlockPos.ZERO) ? tempFluid : EMPTY;
        }

        public int getHeight() {
            return 0;
        }

        public int getMinBuildHeight() {
            return 0;
        }

        static {
            tempState = AIR;
            tempFluid = EMPTY;
        }
    }

    @FunctionalInterface
    public static interface RenderBlockFn {
        public void renderBlock(BlockState var1, PoseStack var2, MultiBufferSource.BufferSource var3);
    }
}

