/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.compat;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import thedarkcolour.exdeorum.ExDeorum;
import thedarkcolour.exdeorum.config.EConfig;
import thedarkcolour.exdeorum.tag.EItemTags;

public class PreferredOres {
    private static final Map<TagKey<Item>, Item> PREFERRED_ORE_ITEMS = new Object2ObjectOpenHashMap(15, 0.75f);

    private static void putPreferredOre(TagKey<Item> tag, ForgeConfigSpec.ConfigValue<String> config, Item defaultOre) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation((String)config.get()));
        if (item == Items.AIR) {
            item = defaultOre;
            ExDeorum.LOGGER.debug("No preferred ore was set for tag {}. Using default choice {}", (Object)tag.location(), (Object)item.builtInRegistryHolder().key().location());
        }
        PREFERRED_ORE_ITEMS.put(tag, defaultOre);
    }

    public static Item getPreferredOre(TagKey<Item> tag) {
        Item preferred = PREFERRED_ORE_ITEMS.get(tag);
        if (preferred != null && preferred != Items.AIR) {
            return preferred;
        }
        ArrayList collection = Lists.newArrayList((Iterable)BuiltInRegistries.ITEM.getTagOrEmpty(tag));
        if (collection.isEmpty()) {
            return Items.AIR;
        }
        collection.sort(Comparator.comparing(holder -> BuiltInRegistries.ITEM.getKey((Object)((Item)holder.get()))));
        return (Item)((Holder)collection.get(0)).get();
    }

    public static Item getDefaultAluminumOre() {
        Item item = PreferredOres.defaultItem("aluminum_ore", "alltheores", "immersiveengineering", "nature_arise");
        if (item == Items.AIR && ModList.get().isLoaded("modern_industrialization")) {
            item = PreferredOres.defaultItem("bauxite_ore", "modern_industrialization");
        }
        return item;
    }

    public static Item getDefaultCobaltOre() {
        return PreferredOres.defaultItem("cobalt_ore", "tconstruct", "nuclearcraft");
    }

    public static Item getDefaultSilverOre() {
        return PreferredOres.defaultItem("silver_ore", "alltheores", "thermal", "occultism", "railcraft", "factorium", "nuclearcraft", "immersiveengineering");
    }

    public static Item getDefaultLeadOre() {
        return PreferredOres.defaultItem("lead_ore", "alltheores", "gtceu", "modern_industrialization", "mekanism", "railcraft", "factorium", "nuclearcraft", "immersiveengineering");
    }

    public static Item getDefaultPlatinumOre() {
        return PreferredOres.defaultItem("platinum_ore", "alltheores", "gtceu", "modern_industrialization", "factorium", "nuclearcraft");
    }

    public static Item getDefaultNickelOre() {
        Item item = PreferredOres.defaultItem("nickel_ore", "alltheores", "gtceu", "modern_industrialization", "thermal", "railcraft", "factorium", "immersiveengineering");
        if (item == Items.AIR && ModList.get().isLoaded("immersiveengineering")) {
            item = PreferredOres.defaultItem("ore_nickel", "immersiveengineering");
        }
        return item;
    }

    public static Item getDefaultUraniumOre() {
        Item item = PreferredOres.defaultItem("uranium_ore", "alltheores", "modern_industrialization", "mekanism", "biggerreactors", "nuclearcraft", "immersiveengineering");
        if (item == Items.AIR && ModList.get().isLoaded("bigreactors")) {
            item = PreferredOres.defaultItem("yellorite_ore", "bigreactors");
        }
        return item;
    }

    public static Item getDefaultOsmiumOre() {
        return PreferredOres.defaultItem("osmium_ore", "alltheores", "mekanism");
    }

    public static Item getDefaultTinOre() {
        return PreferredOres.defaultItem("tin_ore", "alltheores", "gtceu", "modern_industrialization", "thermal", "mekanism", "forestry", "railcraft", "factorium", "nuclearcraft");
    }

    public static Item getDefaultZincOre() {
        return PreferredOres.defaultItem("zinc_ore", "alltheores", "gtceu", "create", "railcraft", "factorium", "nuclearcraft");
    }

    public static Item getDefaultIridiumOre() {
        return PreferredOres.defaultItem("iridium_ore", "alltheores", "modern_industrialization");
    }

    public static Item getDefaultThoriumOre() {
        return PreferredOres.defaultItem("thorium_ore", "nuclearcraft");
    }

    public static Item getDefaultMagnesiumOre() {
        return PreferredOres.defaultItem("magnesium_ore", "nuclearcraft");
    }

    public static Item getDefaultLithiumOre() {
        return PreferredOres.defaultItem("lithium_ore", "nuclearcraft");
    }

    public static Item getDefaultBoronOre() {
        return PreferredOres.defaultItem("boron_ore", "nuclearcraft");
    }

    private static Item defaultItem(String path, String ... modIds) {
        String modId = PreferredOres.getFirstAvailableModId(modIds);
        if (modId != null) {
            if (modId.equals("factorium")) {
                return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(modId, "mat_" + path));
            }
            if (modId.equals("immersiveengineering")) {
                return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(modId, "ore_" + path.substring(0, path.length() - 4)));
            }
            return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(modId, path));
        }
        return Items.AIR;
    }

    @Nullable
    private static String getFirstAvailableModId(String ... modids) {
        for (String modid : modids) {
            if (!ModList.get().isLoaded(modid)) continue;
            return modid;
        }
        ExDeorum.LOGGER.debug("None of the specified mods were found: {}", (Object)Arrays.toString(modids));
        return null;
    }

    static {
        PreferredOres.putPreferredOre(EItemTags.ORES_ALUMINUM, EConfig.COMMON.preferredAluminumOre, PreferredOres.getDefaultAluminumOre());
        PreferredOres.putPreferredOre(EItemTags.ORES_COBALT, EConfig.COMMON.preferredCobaltOre, PreferredOres.getDefaultCobaltOre());
        PreferredOres.putPreferredOre(EItemTags.ORES_SILVER, EConfig.COMMON.preferredSilverOre, PreferredOres.getDefaultSilverOre());
        PreferredOres.putPreferredOre(EItemTags.ORES_LEAD, EConfig.COMMON.preferredLeadOre, PreferredOres.getDefaultLeadOre());
        PreferredOres.putPreferredOre(EItemTags.ORES_PLATINUM, EConfig.COMMON.preferredPlatinumOre, PreferredOres.getDefaultPlatinumOre());
        PreferredOres.putPreferredOre(EItemTags.ORES_NICKEL, EConfig.COMMON.preferredNickelOre, PreferredOres.getDefaultNickelOre());
        PreferredOres.putPreferredOre(EItemTags.ORES_URANIUM, EConfig.COMMON.preferredUraniumOre, PreferredOres.getDefaultUraniumOre());
        PreferredOres.putPreferredOre(EItemTags.ORES_OSMIUM, EConfig.COMMON.preferredOsmiumOre, PreferredOres.getDefaultOsmiumOre());
        PreferredOres.putPreferredOre(EItemTags.ORES_TIN, EConfig.COMMON.preferredTinOre, PreferredOres.getDefaultTinOre());
        PreferredOres.putPreferredOre(EItemTags.ORES_ZINC, EConfig.COMMON.preferredZincOre, PreferredOres.getDefaultZincOre());
        PreferredOres.putPreferredOre(EItemTags.ORES_IRIDIUM, EConfig.COMMON.preferredIridiumOre, PreferredOres.getDefaultIridiumOre());
        PreferredOres.putPreferredOre(EItemTags.ORES_THORIUM, EConfig.COMMON.preferredThoriumOre, PreferredOres.getDefaultThoriumOre());
        PreferredOres.putPreferredOre(EItemTags.ORES_MAGNESIUM, EConfig.COMMON.preferredMagnesiumOre, PreferredOres.getDefaultMagnesiumOre());
        PreferredOres.putPreferredOre(EItemTags.ORES_LITHIUM, EConfig.COMMON.preferredLithiumOre, PreferredOres.getDefaultLithiumOre());
        PreferredOres.putPreferredOre(EItemTags.ORES_BORON, EConfig.COMMON.preferredBoronOre, PreferredOres.getDefaultBoronOre());
    }
}

