/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.compat;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.providers.number.BinomialDistributionGenerator;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.exdeorum.loot.SummationGenerator;
import thedarkcolour.exdeorum.recipe.BlockPredicate;
import thedarkcolour.exdeorum.recipe.RecipeUtil;

public class XeiUtil {
    public static final int ONE_TO_ONE_WIDTH = 72;
    public static final int ONE_TO_ONE_HEIGHT = 18;
    public static final int BARREL_MIXING_WIDTH = 120;
    public static final int BARREL_MIXING_HEIGHT = 18;
    public static final int BARREL_COMPOST_WIDTH = 120;
    public static final int BARREL_COMPOST_HEIGHT = 18;
    public static final Component REQUIRES_CERTAIN_STATE = Component.translatable((String)"gui.exdeorum.category.crook.requires_state").withStyle(ChatFormatting.GRAY);
    public static final int SIEVE_WIDTH = 162;
    public static final int SIEVE_ROW_START = 28;
    public static final int SIEVE_ROW_HEIGHT = 18;
    public static final Component BY_HAND_ONLY_LABEL = Component.translatable((String)"gui.exdeorum.category.sieve.by_hand_only").withStyle(ChatFormatting.RED);
    public static final DecimalFormat FORMATTER = new DecimalFormat();

    public static Component formatChance(double probability) {
        String chance = FORMATTER.format(probability * 100.0);
        return Component.translatable((String)"gui.exdeorum.category.sieve.chance", (Object[])new Object[]{chance}).withStyle(ChatFormatting.GRAY);
    }

    public static List<BlockState> getStates(BlockPredicate predicate) {
        if (predicate instanceof BlockPredicate.BlockStatePredicate) {
            BlockPredicate.BlockStatePredicate state = (BlockPredicate.BlockStatePredicate)predicate;
            return state.possibleStates().filter(blockState -> !blockState.hasProperty((Property)BlockStateProperties.WATERLOGGED) || (Boolean)blockState.getValue((Property)BlockStateProperties.WATERLOGGED) == false).toList();
        }
        if (predicate instanceof BlockPredicate.SingleBlockPredicate) {
            BlockPredicate.SingleBlockPredicate block = (BlockPredicate.SingleBlockPredicate)predicate;
            return ImmutableList.of((Object)block.block().defaultBlockState());
        }
        if (predicate instanceof BlockPredicate.TagPredicate) {
            BlockPredicate.TagPredicate tag = (BlockPredicate.TagPredicate)predicate;
            ArrayList<BlockState> list = new ArrayList<BlockState>();
            for (Holder holder : BuiltInRegistries.BLOCK.getTagOrEmpty(tag.tag())) {
                if (!holder.isBound()) continue;
                list.add(((Block)holder.value()).defaultBlockState());
            }
            return list;
        }
        throw new IllegalArgumentException("Invalid Block Predicate");
    }

    public static Component getModDisplayName(String modId) {
        String string = ModList.get().getModContainerById(modId).map(ModContainer::getModInfo).map(IModInfo::getDisplayName).orElseGet(() -> StringUtils.capitalize((String)modId));
        String withoutFormattingCodes = ChatFormatting.stripFormatting((String)string);
        return Component.literal((String)(withoutFormattingCodes == null ? "" : withoutFormattingCodes)).withStyle(style -> style.withItalic(Boolean.valueOf(true)).withColor(ChatFormatting.BLUE));
    }

    public static List<Component> getBlockTooltip(List<Component> extraDetails, Block block) {
        String modId = BuiltInRegistries.BLOCK.getKey((Object)block).getNamespace();
        ArrayList<Component> tooltip = new ArrayList<Component>();
        tooltip.add((Component)Component.translatable((String)block.getDescriptionId()));
        tooltip.addAll(extraDetails);
        tooltip.add(XeiUtil.getModDisplayName(modId));
        return tooltip;
    }

    public static ImmutableList<Component> getStateRequirements(@Nullable BlockPredicate.BlockStatePredicate predicate) {
        JsonElement json;
        ImmutableList.Builder requirements = ImmutableList.builder();
        if (predicate != null && (json = predicate.properties().serializeToJson()) instanceof JsonObject) {
            JsonObject obj = (JsonObject)json;
            for (Map.Entry entry : obj.entrySet()) {
                requirements.add((Object)Component.literal((String)("  " + (String)entry.getKey() + "=" + ((JsonElement)entry.getValue()).toString())).withStyle(ChatFormatting.GRAY));
            }
        }
        return requirements.build();
    }

    public static List<Component> getExtraDetails(BlockPredicate predicate) {
        Object extraDetails;
        if (predicate instanceof BlockPredicate.TagPredicate) {
            BlockPredicate.TagPredicate tag = (BlockPredicate.TagPredicate)predicate;
            extraDetails = ImmutableList.of((Object)Component.literal((String)("#" + tag.tag().location())).withStyle(ChatFormatting.GRAY));
        } else if (predicate instanceof BlockPredicate.BlockStatePredicate) {
            BlockPredicate.BlockStatePredicate state = (BlockPredicate.BlockStatePredicate)predicate;
            ImmutableList<Component> requirements = XeiUtil.getStateRequirements(state);
            extraDetails = new ArrayList(requirements.size() + 1);
            extraDetails.add(REQUIRES_CERTAIN_STATE);
            extraDetails.addAll(requirements);
        } else {
            extraDetails = List.of();
        }
        return extraDetails;
    }

    /*
     * Unable to fully structure code
     */
    public static void addSieveDropTooltip(boolean byHandOnly, NumberProvider provider, Consumer<Component> tooltipLines) {
        block6: {
            block5: {
                if (byHandOnly) {
                    tooltipLines.accept(XeiUtil.BY_HAND_ONLY_LABEL);
                }
                if (!(provider instanceof BinomialDistributionGenerator)) break block5;
                binomial = (BinomialDistributionGenerator)provider;
                var5_4 = binomial.n;
                if (!(var5_4 instanceof ConstantValue)) ** GOTO lbl-1000
                constant = (ConstantValue)var5_4;
                if (constant.value == 1.0f) {
                    chanceLabel = XeiUtil.formatChance(RecipeUtil.getExpectedValue(binomial.p));
                    tooltipLines.accept(chanceLabel);
                } else lbl-1000:
                // 2 sources

                {
                    XeiUtil.addAvgOutput(tooltipLines, RecipeUtil.getExpectedValue(provider));
                }
                XeiUtil.addMinMaxes(tooltipLines, 0.0, XeiUtil.getMax(binomial.n));
                break block6;
            }
            if (provider.getClass() != ConstantValue.class && (val = RecipeUtil.getExpectedValue(provider)) != -1.0) {
                XeiUtil.addAvgOutput(tooltipLines, val);
                if (provider instanceof UniformGenerator || provider instanceof SummationGenerator) {
                    XeiUtil.addMinMaxes(tooltipLines, XeiUtil.getMin(provider), XeiUtil.getMax(provider));
                }
            }
        }
    }

    private static double getMin(NumberProvider provider) {
        if (provider instanceof ConstantValue) {
            ConstantValue value = (ConstantValue)provider;
            return value.value;
        }
        if (provider instanceof UniformGenerator) {
            UniformGenerator uniform = (UniformGenerator)provider;
            return XeiUtil.getMin(uniform.min);
        }
        if (provider instanceof BinomialDistributionGenerator) {
            return 0.0;
        }
        if (provider instanceof SummationGenerator) {
            SummationGenerator summation = (SummationGenerator)provider;
            double sum = 0.0;
            for (NumberProvider child : summation.providers()) {
                sum += XeiUtil.getMin(child);
            }
            return sum;
        }
        return 0.0;
    }

    private static double getMax(NumberProvider provider) {
        if (provider instanceof ConstantValue) {
            ConstantValue value = (ConstantValue)provider;
            return value.value;
        }
        if (provider instanceof UniformGenerator) {
            UniformGenerator uniform = (UniformGenerator)provider;
            return XeiUtil.getMax(uniform.max);
        }
        if (provider instanceof BinomialDistributionGenerator) {
            BinomialDistributionGenerator binomial = (BinomialDistributionGenerator)provider;
            return XeiUtil.getMax(binomial.n);
        }
        if (provider instanceof SummationGenerator) {
            SummationGenerator summation = (SummationGenerator)provider;
            double sum = 0.0;
            for (NumberProvider child : summation.providers()) {
                sum += XeiUtil.getMax(child);
            }
            return sum;
        }
        return 0.0;
    }

    private static void addAvgOutput(Consumer<Component> tooltipLines, double avgValue) {
        String avgOutput = FORMATTER.format(avgValue);
        tooltipLines.accept((Component)Component.translatable((String)"gui.exdeorum.category.sieve.average_output", (Object[])new Object[]{avgOutput}).withStyle(ChatFormatting.GRAY));
    }

    private static void addMinMaxes(Consumer<Component> tooltipLines, double min, double max) {
        String minFormatted = FORMATTER.format(min);
        String maxFormatted = FORMATTER.format(max);
        tooltipLines.accept((Component)Component.translatable((String)"gui.exdeorum.category.sieve.min_output", (Object[])new Object[]{minFormatted}).withStyle(ChatFormatting.GRAY));
        tooltipLines.accept((Component)Component.translatable((String)"gui.exdeorum.category.sieve.max_output", (Object[])new Object[]{maxFormatted}).withStyle(ChatFormatting.GRAY));
    }

    public static void addCrucibleHeatRecipes(HeatRecipeAcceptor acceptor) {
        Object2IntOpenHashMap values = new Object2IntOpenHashMap();
        for (Object2IntMap.Entry entry : RecipeUtil.getHeatSources()) {
            BlockState state = (BlockState)entry.getKey();
            Block block = state.getBlock();
            if (block instanceof WallTorchBlock || block == Blocks.AIR) continue;
            int newValue = entry.getIntValue();
            values.computeInt((Object)block, (key, value) -> {
                if (value != null) {
                    return Math.max(value, newValue);
                }
                return newValue == 0 ? null : Integer.valueOf(newValue);
            });
        }
        for (Object2IntMap.Entry entry : values.object2IntEntrySet()) {
            acceptor.accept(entry.getIntValue(), ((Block)entry.getKey()).defaultBlockState());
        }
    }

    static {
        FORMATTER.setMinimumFractionDigits(0);
        FORMATTER.setMaximumFractionDigits(3);
    }

    public static interface HeatRecipeAcceptor {
        public void accept(int var1, BlockState var2);
    }
}

