/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.compat.emi;

import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiInitRegistry;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.HashSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.WallTorchBlock;
import thedarkcolour.exdeorum.compat.ClientXeiUtil;
import thedarkcolour.exdeorum.compat.CompatHelper;
import thedarkcolour.exdeorum.compat.XeiSieveRecipe;
import thedarkcolour.exdeorum.compat.emi.BarrelCompostEmiRecipe;
import thedarkcolour.exdeorum.compat.emi.BarrelMixingEmiRecipe;
import thedarkcolour.exdeorum.compat.emi.CrookEmiRecipe;
import thedarkcolour.exdeorum.compat.emi.CrucibleEmiRecipe;
import thedarkcolour.exdeorum.compat.emi.CrucibleHeatEmiRecipe;
import thedarkcolour.exdeorum.compat.emi.EmiUtil;
import thedarkcolour.exdeorum.compat.emi.HammerEmiRecipe;
import thedarkcolour.exdeorum.compat.emi.SieveEmiRecipe;
import thedarkcolour.exdeorum.material.DefaultMaterials;
import thedarkcolour.exdeorum.recipe.BlockPredicate;
import thedarkcolour.exdeorum.recipe.crucible.CrucibleHeatRecipe;
import thedarkcolour.exdeorum.recipe.sieve.SieveRecipe;
import thedarkcolour.exdeorum.registry.EItems;
import thedarkcolour.exdeorum.registry.ERecipeTypes;

@EmiEntrypoint
public class ExDeorumEmiPlugin
implements EmiPlugin {
    static final EmiRecipeCategory BARREL_COMPOST = ExDeorumEmiPlugin.emiCategory("barrel_compost", (graphics, x, y, partialTick) -> ClientXeiUtil.renderFilledCompostBarrel(graphics, x, y));
    static final EmiRecipeCategory BARREL_MIXING = ExDeorumEmiPlugin.emiCategory("barrel_mixing", (EmiRenderable)EmiStack.of((ItemLike)DefaultMaterials.OAK_BARREL));
    static final EmiRecipeCategory BARREL_FLUID_MIXING = ExDeorumEmiPlugin.emiCategory("barrel_fluid_mixing", (EmiRenderable)EmiStack.of((ItemLike)DefaultMaterials.STONE_BARREL));
    static final EmiRecipeCategory LAVA_CRUCIBLE = ExDeorumEmiPlugin.emiCategory("lava_crucible", (EmiRenderable)EmiStack.of((ItemLike)DefaultMaterials.PORCELAIN_CRUCIBLE));
    static final EmiRecipeCategory WATER_CRUCIBLE = ExDeorumEmiPlugin.emiCategory("water_crucible", (EmiRenderable)EmiStack.of((ItemLike)DefaultMaterials.OAK_CRUCIBLE));
    static final EmiRecipeCategory CRUCIBLE_HEAT_SOURCES = ExDeorumEmiPlugin.emiCategory("crucible_heat_sources", (EmiRenderable)EmiStack.of((ItemLike)DefaultMaterials.PORCELAIN_CRUCIBLE));
    static final EmiRecipeCategory SIEVE = ExDeorumEmiPlugin.emiCategory("sieve", (EmiRenderable)EmiStack.of((ItemLike)DefaultMaterials.OAK_SIEVE));
    static final EmiRecipeCategory COMPRESSED_SIEVE = ExDeorumEmiPlugin.emiCategory("compressed_sieve", (EmiRenderable)EmiStack.of((ItemLike)DefaultMaterials.OAK_COMPRESSED_SIEVE));
    static final EmiRecipeCategory HAMMER = ExDeorumEmiPlugin.emiCategory("hammer", (EmiRenderable)EmiStack.of((ItemLike)((ItemLike)EItems.DIAMOND_HAMMER.get())));
    static final EmiRecipeCategory COMPRESSED_HAMMER = ExDeorumEmiPlugin.emiCategory("compressed_hammer", (EmiRenderable)EmiStack.of((ItemLike)((ItemLike)EItems.COMPRESSED_DIAMOND_HAMMER.get())));
    static final EmiRecipeCategory CROOK = ExDeorumEmiPlugin.emiCategory("crook", (EmiRenderable)EmiStack.of((ItemLike)((ItemLike)EItems.CROOK.get())));

    private static EmiRecipeCategory emiCategory(String name, EmiRenderable icon) {
        return new EmiRecipeCategory(new ResourceLocation("exdeorum", name), icon);
    }

    public void register(EmiRegistry registry) {
        ExDeorumEmiPlugin.addCategories(registry);
        ExDeorumEmiPlugin.addWorkstations(registry);
        ExDeorumEmiPlugin.addRecipes(registry);
    }

    private static void addCategories(EmiRegistry registry) {
        registry.addCategory(BARREL_COMPOST);
        registry.addCategory(BARREL_MIXING);
        registry.addCategory(BARREL_FLUID_MIXING);
        registry.addCategory(LAVA_CRUCIBLE);
        registry.addCategory(WATER_CRUCIBLE);
        registry.addCategory(CRUCIBLE_HEAT_SOURCES);
        registry.addCategory(SIEVE);
        registry.addCategory(COMPRESSED_SIEVE);
        registry.addCategory(HAMMER);
        registry.addCategory(COMPRESSED_HAMMER);
        registry.addCategory(CROOK);
    }

    private static void addWorkstations(EmiRegistry registry) {
        EmiStack stack;
        for (ItemLike barrel : CompatHelper.getAvailableBarrels(true)) {
            stack = EmiStack.of((ItemLike)barrel);
            registry.addWorkstation(BARREL_COMPOST, (EmiIngredient)stack);
            registry.addWorkstation(BARREL_MIXING, (EmiIngredient)stack);
            registry.addWorkstation(BARREL_FLUID_MIXING, (EmiIngredient)stack);
        }
        for (ItemLike lavaCrucible : CompatHelper.getAvailableLavaCrucibles(true)) {
            stack = EmiStack.of((ItemLike)lavaCrucible);
            registry.addWorkstation(LAVA_CRUCIBLE, (EmiIngredient)stack);
            registry.addWorkstation(CRUCIBLE_HEAT_SOURCES, (EmiIngredient)stack);
        }
        for (ItemLike waterCrucible : CompatHelper.getAvailableWaterCrucibles(true)) {
            registry.addWorkstation(WATER_CRUCIBLE, (EmiIngredient)EmiStack.of((ItemLike)waterCrucible));
        }
        for (ItemLike sieve : CompatHelper.getAvailableSieves(true, true)) {
            registry.addWorkstation(SIEVE, (EmiIngredient)EmiStack.of((ItemLike)sieve));
        }
        for (ItemLike compressedSieve : CompatHelper.getAvailableCompressedSieves(true)) {
            registry.addWorkstation(COMPRESSED_SIEVE, (EmiIngredient)EmiStack.of((ItemLike)compressedSieve));
        }
        registry.addWorkstation(HAMMER, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)EItems.WOODEN_HAMMER.get())));
        registry.addWorkstation(HAMMER, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)EItems.STONE_HAMMER.get())));
        registry.addWorkstation(HAMMER, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)EItems.GOLDEN_HAMMER.get())));
        registry.addWorkstation(HAMMER, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)EItems.IRON_HAMMER.get())));
        registry.addWorkstation(HAMMER, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)EItems.DIAMOND_HAMMER.get())));
        registry.addWorkstation(HAMMER, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)EItems.NETHERITE_HAMMER.get())));
        registry.addWorkstation(HAMMER, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)EItems.MECHANICAL_HAMMER.get())));
        registry.addWorkstation(COMPRESSED_HAMMER, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)EItems.COMPRESSED_WOODEN_HAMMER.get())));
        registry.addWorkstation(COMPRESSED_HAMMER, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)EItems.COMPRESSED_STONE_HAMMER.get())));
        registry.addWorkstation(COMPRESSED_HAMMER, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)EItems.COMPRESSED_GOLDEN_HAMMER.get())));
        registry.addWorkstation(COMPRESSED_HAMMER, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)EItems.COMPRESSED_IRON_HAMMER.get())));
        registry.addWorkstation(COMPRESSED_HAMMER, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)EItems.COMPRESSED_DIAMOND_HAMMER.get())));
        registry.addWorkstation(COMPRESSED_HAMMER, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)EItems.COMPRESSED_NETHERITE_HAMMER.get())));
        registry.addWorkstation(CROOK, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)EItems.CROOK.get())));
        registry.addWorkstation(CROOK, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)EItems.BONE_CROOK.get())));
    }

    private static void addRecipes(EmiRegistry registry) {
        EmiUtil.addAll(registry, ERecipeTypes.BARREL_COMPOST, BarrelCompostEmiRecipe::new);
        EmiUtil.addAll(registry, ERecipeTypes.BARREL_MIXING, BarrelMixingEmiRecipe.Items::new);
        EmiUtil.addAll(registry, ERecipeTypes.BARREL_FLUID_MIXING, BarrelMixingEmiRecipe.Fluids::new);
        EmiUtil.addAll(registry, ERecipeTypes.LAVA_CRUCIBLE, CrucibleEmiRecipe.Lava::new);
        EmiUtil.addAll(registry, ERecipeTypes.WATER_CRUCIBLE, CrucibleEmiRecipe.Water::new);
        for (CrucibleHeatRecipe value : registry.getRecipeManager().byType((RecipeType)ERecipeTypes.CRUCIBLE_HEAT_SOURCE.get()).values()) {
            BlockPredicate.SingleBlockPredicate block;
            BlockPredicate blockPredicate = value.blockPredicate();
            if (blockPredicate instanceof BlockPredicate.SingleBlockPredicate && (block = (BlockPredicate.SingleBlockPredicate)blockPredicate).block() instanceof WallTorchBlock) continue;
            registry.addRecipe((EmiRecipe)new CrucibleHeatEmiRecipe(value));
        }
        for (XeiSieveRecipe recipe : XeiSieveRecipe.getAllRecipesGrouped((RecipeType<? extends SieveRecipe>)((RecipeType)ERecipeTypes.SIEVE.get()), XeiSieveRecipe.SIEVE_ROWS)) {
            registry.addRecipe((EmiRecipe)new SieveEmiRecipe.Sieve(recipe));
        }
        for (XeiSieveRecipe recipe : XeiSieveRecipe.getAllRecipesGrouped((RecipeType<? extends SieveRecipe>)((RecipeType)ERecipeTypes.COMPRESSED_SIEVE.get()), XeiSieveRecipe.COMPRESSED_SIEVE_ROWS)) {
            registry.addRecipe((EmiRecipe)new SieveEmiRecipe.CompressedSieve(recipe));
        }
        EmiUtil.addAll(registry, ERecipeTypes.HAMMER, HammerEmiRecipe.Hammer::new);
        EmiUtil.addAll(registry, ERecipeTypes.COMPRESSED_HAMMER, HammerEmiRecipe.CompressedHammer::new);
        EmiUtil.addAll(registry, ERecipeTypes.CROOK, CrookEmiRecipe::new);
    }

    public void initialize(EmiInitRegistry registry) {
        HashSet<ItemLike> toRemove = new HashSet<ItemLike>();
        toRemove.addAll(CompatHelper.getAvailableBarrels(false));
        toRemove.addAll(CompatHelper.getAvailableSieves(false, false));
        toRemove.addAll(CompatHelper.getAvailableLavaCrucibles(false));
        toRemove.addAll(CompatHelper.getAvailableWaterCrucibles(false));
        HashSet<Item> toRemoveItems = new HashSet<Item>();
        for (ItemLike itemLike : toRemove) {
            toRemoveItems.add(itemLike.asItem());
        }
        registry.disableStacks(stack -> toRemoveItems.contains(stack.getItemStack().getItem()));
    }
}

