/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.compat.emi;

import com.google.common.collect.ImmutableList;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import thedarkcolour.exdeorum.compat.XeiSieveRecipe;
import thedarkcolour.exdeorum.compat.XeiUtil;
import thedarkcolour.exdeorum.compat.emi.EEmiRecipe;
import thedarkcolour.exdeorum.compat.emi.ExDeorumEmiPlugin;

abstract class SieveEmiRecipe
extends EEmiRecipe {
    private final List<EmiIngredient> inputs;
    private final int rows;
    private final List<EmiStack> outputs;
    private final XeiSieveRecipe recipe;

    SieveEmiRecipe(XeiSieveRecipe recipe, int rows) {
        super(SieveEmiRecipe.determineId(recipe));
        this.inputs = ImmutableList.of((Object)EmiIngredient.of((Ingredient)recipe.ingredient()), (Object)EmiStack.of((ItemStack)recipe.mesh()));
        this.rows = rows;
        this.recipe = recipe;
        ImmutableList.Builder outputs = ImmutableList.builderWithExpectedSize((int)recipe.results().size());
        for (XeiSieveRecipe.Result result : recipe.results()) {
            outputs.add((Object)EmiStack.of((ItemStack)result.item));
        }
        this.outputs = outputs.build();
    }

    private static ResourceLocation determineId(XeiSieveRecipe recipe) {
        Item mesh = recipe.mesh().getItem();
        int hashCode = Arrays.hashCode(Arrays.stream(recipe.ingredient().getItems()).map(ItemStack::getItem).toArray());
        return new ResourceLocation("exdeorum", BuiltInRegistries.ITEM.getKey((Object)mesh).getPath() + "_" + hashCode);
    }

    public List<EmiIngredient> getInputs() {
        return this.inputs;
    }

    public List<EmiStack> getOutputs() {
        return this.outputs;
    }

    public int getDisplayWidth() {
        return 162;
    }

    public int getDisplayHeight() {
        return 28 + 18 * this.rows;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addSlot(this.inputs.get(0), 58, 1);
        widgets.addSlot(this.inputs.get(1), 86, 1);
        for (int i = 0; i < this.rows * 9; ++i) {
            int x = i % 9 * 18;
            int y = 28 + 18 * (i / 9);
            if (i < this.outputs.size()) {
                XeiSieveRecipe.Result result = this.recipe.results().get(i);
                ((SieveResultWidget)widgets.add((Widget)new SieveResultWidget((EmiIngredient)this.outputs.get(i), x, y, result.byHandOnly, result.provider))).recipeContext(this);
                continue;
            }
            widgets.addSlot(x, y);
        }
    }

    private static class SieveResultWidget
    extends SlotWidget {
        private final boolean byHandOnly;
        private final NumberProvider amount;

        public SieveResultWidget(EmiIngredient stack, int x, int y, boolean byHandOnly, NumberProvider amount) {
            super(stack, x, y);
            this.byHandOnly = byHandOnly;
            this.amount = amount;
        }

        public List<ClientTooltipComponent> getTooltip(int mouseX, int mouseY) {
            List list = super.getTooltip(mouseX, mouseY);
            XeiUtil.addSieveDropTooltip(this.byHandOnly, this.amount, line -> list.add(ClientTooltipComponent.create((FormattedCharSequence)line.getVisualOrderText())));
            return list;
        }
    }

    static class CompressedSieve
    extends SieveEmiRecipe {
        CompressedSieve(XeiSieveRecipe recipe) {
            super(recipe, XeiSieveRecipe.COMPRESSED_SIEVE_ROWS.intValue());
        }

        public EmiRecipeCategory getCategory() {
            return ExDeorumEmiPlugin.COMPRESSED_SIEVE;
        }
    }

    static class Sieve
    extends SieveEmiRecipe {
        Sieve(XeiSieveRecipe recipe) {
            super(recipe, XeiSieveRecipe.SIEVE_ROWS.intValue());
        }

        public EmiRecipeCategory getCategory() {
            return ExDeorumEmiPlugin.SIEVE;
        }
    }
}

