/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.compat.jade;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec2;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;
import thedarkcolour.exdeorum.blockentity.logic.SieveLogic;
import thedarkcolour.exdeorum.compat.jade.ExDeorumJadePlugin;

enum SieveComponentProvider implements IBlockComponentProvider
{
    INSTANCE;


    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        BlockEntity blockEntity = accessor.getBlockEntity();
        if (blockEntity instanceof SieveLogic.Owner) {
            SieveLogic.Owner sieve = (SieveLogic.Owner)blockEntity;
            SieveLogic logic = sieve.getLogic();
            if (!logic.getContents().isEmpty()) {
                tooltip.add((Component)Component.literal((String)"Progress: ").append(Math.round(1000.0f * logic.getProgress()) / 10 + "%"));
            }
            if (accessor.getPlayer().isShiftKeyDown()) {
                ItemStack mesh = logic.getMesh();
                IElement element = IElementHelper.get().item(mesh);
                tooltip.add(element);
                tooltip.append(IElementHelper.get().text((Component)Component.translatable((String)mesh.getDescriptionId())).translate(new Vec2(2.0f, 6.0f)));
                if (mesh.isEnchanted()) {
                    ObjectArrayList list = new ObjectArrayList();
                    ItemStack.appendEnchantmentNames((List)list, (ListTag)mesh.getEnchantmentTags());
                    for (Component component : list) {
                        tooltip.add(component);
                    }
                }
            }
        }
    }

    public ResourceLocation getUid() {
        return ExDeorumJadePlugin.SIEVE;
    }
}

