/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.compat.jei;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.exdeorum.compat.XeiUtil;
import thedarkcolour.exdeorum.recipe.BlockPredicate;
import thedarkcolour.exdeorum.recipe.crook.CrookRecipe;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
abstract class CrookJeiRecipe {
    public final List<BlockState> states;
    public Item result;
    @Nullable
    private final CompoundTag resultNbt;
    public float chance;

    public CrookJeiRecipe(List<BlockState> states, Item result, @Nullable CompoundTag resultNbt, float chance) {
        this.states = states;
        this.result = result;
        this.resultNbt = resultNbt;
        this.chance = chance;
    }

    public abstract void addIngredients(IRecipeLayoutBuilder var1);

    static CrookJeiRecipe create(CrookRecipe recipe) {
        BlockPredicate blockPredicate = recipe.blockPredicate();
        if (blockPredicate instanceof BlockPredicate.BlockStatePredicate) {
            BlockPredicate.BlockStatePredicate state = (BlockPredicate.BlockStatePredicate)blockPredicate;
            return new StatesRecipe(state, state.possibleStates().filter(blockState -> !blockState.hasProperty((Property)BlockStateProperties.WATERLOGGED) || (Boolean)blockState.getValue((Property)BlockStateProperties.WATERLOGGED) == false).toList(), recipe.result(), recipe.resultNbt(), recipe.chance());
        }
        blockPredicate = recipe.blockPredicate();
        if (blockPredicate instanceof BlockPredicate.SingleBlockPredicate) {
            BlockPredicate.SingleBlockPredicate block = (BlockPredicate.SingleBlockPredicate)blockPredicate;
            return new BlockRecipe(block.block(), recipe.result(), recipe.resultNbt(), recipe.chance());
        }
        blockPredicate = recipe.blockPredicate();
        if (blockPredicate instanceof BlockPredicate.TagPredicate) {
            BlockPredicate.TagPredicate tag = (BlockPredicate.TagPredicate)blockPredicate;
            ArrayList<BlockState> list = new ArrayList<BlockState>();
            for (Holder holder : BuiltInRegistries.BLOCK.getTagOrEmpty(tag.tag())) {
                if (!holder.isBound()) continue;
                list.add(((Block)holder.value()).defaultBlockState());
            }
            return new TagRecipe(tag.tag(), List.copyOf(list), recipe.result(), recipe.resultNbt(), recipe.chance());
        }
        throw new IllegalArgumentException("Invalid crook recipe??  ->  " + recipe);
    }

    @Nullable
    public CompoundTag getResultNbt() {
        return this.resultNbt == null ? null : this.resultNbt.copy();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static class StatesRecipe
    extends CrookJeiRecipe {
        private final List<ItemStack> itemIngredients;
        public final List<Component> requirements;

        StatesRecipe(@Nullable BlockPredicate.BlockStatePredicate predicate, List<BlockState> states, Item result, @Nullable CompoundTag resultNbt, float chance) {
            super(states, result, resultNbt, chance);
            ImmutableList.Builder itemIngredients = ImmutableList.builder();
            HashSet<Block> blocks = new HashSet<Block>();
            for (BlockState state : this.states) {
                Item item;
                Block block = state.getBlock();
                if (!blocks.add(block) || (item = block.asItem()) == Items.AIR) continue;
                itemIngredients.add((Object)new ItemStack((ItemLike)item));
            }
            this.itemIngredients = itemIngredients.build();
            this.requirements = XeiUtil.getStateRequirements(predicate);
        }

        @Override
        public void addIngredients(IRecipeLayoutBuilder builder) {
            if (!this.itemIngredients.isEmpty()) {
                builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).addItemStacks(this.itemIngredients);
            }
        }
    }

    static final class BlockRecipe
    extends CrookJeiRecipe {
        private final ItemStack itemIngredient;

        BlockRecipe(Block block, Item result, @Nullable CompoundTag resultNbt, float chance) {
            super((List<BlockState>)ImmutableList.of((Object)block.defaultBlockState()), result, resultNbt, chance);
            Item item = block.asItem();
            this.itemIngredient = item == Items.AIR ? ItemStack.EMPTY : new ItemStack((ItemLike)item);
        }

        @Override
        public void addIngredients(IRecipeLayoutBuilder builder) {
            if (!this.itemIngredient.isEmpty()) {
                builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).addItemStack(this.itemIngredient);
            }
        }
    }

    static final class TagRecipe
    extends StatesRecipe {
        public final TagKey<Block> tag;

        public TagRecipe(TagKey<Block> tag, List<BlockState> states, Item result, @Nullable CompoundTag resultNbt, float chance) {
            super(null, states, result, resultNbt, chance);
            this.tag = tag;
        }
    }
}

