/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.compat.jei;

import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import thedarkcolour.exdeorum.compat.jei.ExDeorumJeiPlugin;
import thedarkcolour.exdeorum.compat.jei.OneToOneCategory;
import thedarkcolour.exdeorum.material.DefaultMaterials;
import thedarkcolour.exdeorum.recipe.crucible.CrucibleRecipe;

abstract class CrucibleCategory
extends OneToOneCategory<CrucibleRecipe> {
    public CrucibleCategory(IGuiHelper helper, IDrawable arrow, Item iconItem, String titleKey) {
        super(helper, arrow, helper.createDrawableItemStack(new ItemStack((ItemLike)iconItem)), (Component)Component.translatable((String)titleKey));
    }

    @Override
    protected void addInput(IRecipeSlotBuilder slot, CrucibleRecipe recipe) {
        slot.addIngredients(recipe.getIngredient());
    }

    @Override
    protected void addOutput(IRecipeSlotBuilder slot, CrucibleRecipe recipe) {
        ((IRecipeSlotBuilder)slot.addFluidStack(recipe.getResult().getFluid(), (long)recipe.getResult().getAmount())).setFluidRenderer((long)Math.max(1000, recipe.getResult().getAmount()), false, 16, 16);
    }

    static class WaterCrucible
    extends CrucibleCategory {
        public WaterCrucible(IGuiHelper helper, IDrawable arrow) {
            super(helper, arrow, DefaultMaterials.OAK_CRUCIBLE.getItem(), "gui.exdeorum.category.water_crucible");
        }

        public RecipeType<CrucibleRecipe> getRecipeType() {
            return ExDeorumJeiPlugin.WATER_CRUCIBLE;
        }
    }

    static class LavaCrucible
    extends CrucibleCategory {
        public LavaCrucible(IGuiHelper helper, IDrawable arrow) {
            super(helper, arrow, DefaultMaterials.PORCELAIN_CRUCIBLE.getItem(), "gui.exdeorum.category.lava_crucible");
        }

        public RecipeType<CrucibleRecipe> getRecipeType() {
            return ExDeorumJeiPlugin.LAVA_CRUCIBLE;
        }
    }
}

