/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.compat.kubejs;

import dev.latvian.mods.kubejs.bindings.event.ServerEvents;
import dev.latvian.mods.kubejs.recipe.RecipesEventJS;
import dev.latvian.mods.kubejs.recipe.ReplacementMatch;
import dev.latvian.mods.kubejs.recipe.filter.RecipeFilter;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.util.function.Consumer;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.RegistryObject;
import thedarkcolour.exdeorum.compat.kubejs.SieveMeshFilter;
import thedarkcolour.exdeorum.recipe.BlockPredicate;
import thedarkcolour.exdeorum.recipe.RecipeUtil;
import thedarkcolour.exdeorum.recipe.crucible.FinishedCrucibleHeatRecipe;
import thedarkcolour.exdeorum.registry.ERecipeTypes;

class ExDeorumKubeJsBindings {
    ExDeorumKubeJsBindings() {
    }

    public void setCrucibleHeatValue(Block block, int value) {
        this.setCrucibleHeatValueForBlock(block, value);
    }

    public void setCrucibleHeatValueForState(String stateString, int value) {
        ExDeorumKubeJsBindings.onRecipesEvent(event -> {
            BlockState state = RecipeUtil.parseBlockState(stateString);
            StatePropertiesPredicate.Builder properties = StatePropertiesPredicate.Builder.properties();
            for (Property prop : state.getProperties()) {
                ExDeorumKubeJsBindings.bypassTypeChecking(properties, prop, state);
            }
            event.custom(new FinishedCrucibleHeatRecipe(null, BlockPredicate.blockState(state.getBlock(), properties.build()), value).serializeRecipe());
        });
    }

    @HideFromJS
    private static <T extends Comparable<T>> void bypassTypeChecking(StatePropertiesPredicate.Builder properties, Property<T> prop, BlockState state) {
        properties.hasProperty(prop, prop.getName(state.getValue(prop)));
    }

    public void setCrucibleHeatValueForBlock(Block block, int value) {
        ExDeorumKubeJsBindings.onRecipesEvent(event -> event.custom(new FinishedCrucibleHeatRecipe(null, BlockPredicate.singleBlock(block), value).serializeRecipe()));
    }

    public void removeDefaultSieveRecipes(RecipesEventJS recipesEvent) {
        ExDeorumKubeJsBindings.removeDefaultRecipes(recipesEvent, ERecipeTypes.SIEVE);
    }

    public void removeDefaultHeatSources() {
        ExDeorumKubeJsBindings.onRecipesEvent(event -> ExDeorumKubeJsBindings.removeDefaultRecipes(event, ERecipeTypes.CRUCIBLE_HEAT_SOURCE));
    }

    @HideFromJS
    private static void removeDefaultRecipes(RecipesEventJS event, RegistryObject<? extends RecipeType<?>> recipeType) {
        event.remove(r -> r.kjs$getType().equals((Object)recipeType.getId()) && r.kjs$getOrCreateId().getNamespace().equals("exdeorum"));
    }

    @HideFromJS
    private static void onRecipesEvent(Consumer<RecipesEventJS> action) {
        ServerEvents.RECIPES.listenJava(ScriptType.SERVER, null, jsEvent -> {
            action.accept((RecipesEventJS)jsEvent);
            return null;
        });
    }

    static {
        RecipeFilter.PARSE.register((ctx, filters, map) -> {
            Object sieveMesh = map.get("sieve_mesh");
            if (sieveMesh != null) {
                filters.add(new SieveMeshFilter(ReplacementMatch.of(sieveMesh)));
            }
        });
    }
}

