/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.compat.kubejs;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import dev.latvian.mods.kubejs.item.InputItem;
import dev.latvian.mods.kubejs.item.OutputItem;
import dev.latvian.mods.kubejs.recipe.ItemMatch;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.recipe.RecipeKey;
import dev.latvian.mods.kubejs.recipe.ReplacementMatch;
import dev.latvian.mods.kubejs.recipe.component.ComponentRole;
import dev.latvian.mods.kubejs.recipe.component.ItemComponents;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchema;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public interface SieveRecipeSchema {
    public static final RecipeComponent<OutputItem> OUTPUT_ITEM_ONLY = new RecipeComponent<OutputItem>(){

        public String componentType() {
            return "output_item_only";
        }

        public ComponentRole role() {
            return ComponentRole.OUTPUT;
        }

        public Class<?> componentClass() {
            return OutputItem.class;
        }

        public boolean hasPriority(RecipeJS recipe, Object from) {
            return recipe.outputItemHasPriority(from);
        }

        public JsonElement write(RecipeJS recipe, OutputItem value) {
            return new JsonPrimitive(ForgeRegistries.ITEMS.getKey((Object)value.item.getItem()).toString());
        }

        public OutputItem read(RecipeJS recipe, Object from) {
            JsonPrimitive primitive;
            if (from instanceof JsonPrimitive && (primitive = (JsonPrimitive)from).isString()) {
                return OutputItem.of((Object)new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(primitive.getAsString()))));
            }
            return OutputItem.of((Object)from);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean isOutput(RecipeJS recipe, OutputItem value, ReplacementMatch match) {
            if (!(match instanceof ItemMatch)) return false;
            ItemMatch m = (ItemMatch)match;
            if (value.isEmpty()) return false;
            if (!m.contains(value.item)) return false;
            return true;
        }

        public String checkEmpty(RecipeKey<OutputItem> key, OutputItem value) {
            if (value.isEmpty()) {
                return "ItemStack '" + key.name + "' can't be empty";
            }
            return "";
        }
    };
    public static final RecipeKey<OutputItem> RESULT = OUTPUT_ITEM_ONLY.key("result");
    public static final RecipeKey<InputItem> INGREDIENT = ItemComponents.INPUT.key("ingredient");
    public static final RecipeSchema SCHEMA = new RecipeSchema(new RecipeKey[]{RESULT, INGREDIENT}).uniqueOutputId(RESULT);
}

