/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.data;

import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.loaders.CompositeModelBuilder;
import net.minecraftforge.registries.ForgeRegistries;
import thedarkcolour.exdeorum.block.CompressedBlockType;
import thedarkcolour.exdeorum.data.ModCompatData;
import thedarkcolour.exdeorum.material.DefaultMaterials;
import thedarkcolour.exdeorum.registry.EBlocks;
import thedarkcolour.exdeorum.registry.ECompressedBlocks;
import thedarkcolour.modkit.data.MKBlockModelProvider;

class BlockModels {
    BlockModels() {
    }

    public static void addBlockModels(MKBlockModelProvider models) {
        models.simpleBlock((Block)EBlocks.DUST.get());
        models.simpleBlock((Block)EBlocks.CRUSHED_NETHERRACK.get());
        models.simpleBlock((Block)EBlocks.CRUSHED_END_STONE.get());
        models.simpleBlock((Block)EBlocks.CRUSHED_DEEPSLATE.get());
        models.simpleBlock((Block)EBlocks.CRUSHED_BLACKSTONE.get());
        for (CompressedBlockType variant : ECompressedBlocks.ALL_VARIANTS) {
            BlockModels.compressedBlock(models, variant.getBlock(), variant.getBase());
        }
        BlockModels.barrel(models, DefaultMaterials.OAK_BARREL.getBlock(), Blocks.OAK_PLANKS);
        BlockModels.barrel(models, DefaultMaterials.SPRUCE_BARREL.getBlock(), Blocks.SPRUCE_PLANKS);
        BlockModels.barrel(models, DefaultMaterials.BIRCH_BARREL.getBlock(), Blocks.BIRCH_PLANKS);
        BlockModels.barrel(models, DefaultMaterials.JUNGLE_BARREL.getBlock(), Blocks.JUNGLE_PLANKS);
        BlockModels.barrel(models, DefaultMaterials.ACACIA_BARREL.getBlock(), Blocks.ACACIA_PLANKS);
        BlockModels.barrel(models, DefaultMaterials.DARK_OAK_BARREL.getBlock(), Blocks.DARK_OAK_PLANKS);
        BlockModels.barrel(models, DefaultMaterials.MANGROVE_BARREL.getBlock(), Blocks.MANGROVE_PLANKS);
        BlockModels.barrel(models, DefaultMaterials.CHERRY_BARREL.getBlock(), Blocks.CHERRY_PLANKS);
        BlockModels.barrel(models, DefaultMaterials.BAMBOO_BARREL.getBlock(), Blocks.BAMBOO_PLANKS);
        BlockModels.barrel(models, DefaultMaterials.CRIMSON_BARREL.getBlock(), Blocks.CRIMSON_PLANKS);
        BlockModels.barrel(models, DefaultMaterials.WARPED_BARREL.getBlock(), Blocks.WARPED_PLANKS);
        BlockModels.barrel(models, DefaultMaterials.STONE_BARREL.getBlock(), Blocks.STONE);
        BlockModels.sieve(models, DefaultMaterials.OAK_SIEVE.getBlock(), Blocks.OAK_PLANKS);
        BlockModels.sieve(models, DefaultMaterials.SPRUCE_SIEVE.getBlock(), Blocks.SPRUCE_PLANKS);
        BlockModels.sieve(models, DefaultMaterials.BIRCH_SIEVE.getBlock(), Blocks.BIRCH_PLANKS);
        BlockModels.sieve(models, DefaultMaterials.JUNGLE_SIEVE.getBlock(), Blocks.JUNGLE_PLANKS);
        BlockModels.sieve(models, DefaultMaterials.ACACIA_SIEVE.getBlock(), Blocks.ACACIA_PLANKS);
        BlockModels.sieve(models, DefaultMaterials.DARK_OAK_SIEVE.getBlock(), Blocks.DARK_OAK_PLANKS);
        BlockModels.sieve(models, DefaultMaterials.MANGROVE_SIEVE.getBlock(), Blocks.MANGROVE_PLANKS);
        BlockModels.sieve(models, DefaultMaterials.CHERRY_SIEVE.getBlock(), Blocks.CHERRY_PLANKS);
        BlockModels.sieve(models, DefaultMaterials.BAMBOO_SIEVE.getBlock(), Blocks.BAMBOO_PLANKS);
        BlockModels.sieve(models, DefaultMaterials.CRIMSON_SIEVE.getBlock(), Blocks.CRIMSON_PLANKS);
        BlockModels.sieve(models, DefaultMaterials.WARPED_SIEVE.getBlock(), Blocks.WARPED_PLANKS);
        BlockModels.compressedSieve(models, DefaultMaterials.OAK_COMPRESSED_SIEVE.getBlock(), Blocks.OAK_LOG);
        BlockModels.compressedSieve(models, DefaultMaterials.SPRUCE_COMPRESSED_SIEVE.getBlock(), Blocks.SPRUCE_LOG);
        BlockModels.compressedSieve(models, DefaultMaterials.BIRCH_COMPRESSED_SIEVE.getBlock(), Blocks.BIRCH_LOG);
        BlockModels.compressedSieve(models, DefaultMaterials.JUNGLE_COMPRESSED_SIEVE.getBlock(), Blocks.JUNGLE_LOG);
        BlockModels.compressedSieve(models, DefaultMaterials.ACACIA_COMPRESSED_SIEVE.getBlock(), Blocks.ACACIA_LOG);
        BlockModels.compressedSieve(models, DefaultMaterials.DARK_OAK_COMPRESSED_SIEVE.getBlock(), Blocks.DARK_OAK_LOG);
        BlockModels.compressedSieve(models, DefaultMaterials.MANGROVE_COMPRESSED_SIEVE.getBlock(), Blocks.MANGROVE_LOG);
        BlockModels.compressedSieve(models, DefaultMaterials.CHERRY_COMPRESSED_SIEVE.getBlock(), Blocks.CHERRY_LOG);
        BlockModels.compressedSieve(models, DefaultMaterials.BAMBOO_COMPRESSED_SIEVE.getBlock(), Blocks.BAMBOO_BLOCK);
        BlockModels.compressedSieve(models, DefaultMaterials.WARPED_COMPRESSED_SIEVE.getBlock(), Blocks.WARPED_STEM);
        BlockModels.compressedSieve(models, DefaultMaterials.CRIMSON_COMPRESSED_SIEVE.getBlock(), Blocks.CRIMSON_STEM);
        BlockModels.crucible(models, (Block)EBlocks.UNFIRED_PORCELAIN_CRUCIBLE.get());
        BlockModels.crucible(models, DefaultMaterials.PORCELAIN_CRUCIBLE.getBlock());
        BlockModels.crucible(models, DefaultMaterials.CRIMSON_CRUCIBLE.getBlock(), Blocks.CRIMSON_STEM);
        BlockModels.crucible(models, DefaultMaterials.WARPED_CRUCIBLE.getBlock(), Blocks.WARPED_STEM);
        BlockModels.crucible(models, DefaultMaterials.OAK_CRUCIBLE.getBlock(), Blocks.OAK_LOG);
        BlockModels.crucible(models, DefaultMaterials.SPRUCE_CRUCIBLE.getBlock(), Blocks.SPRUCE_LOG);
        BlockModels.crucible(models, DefaultMaterials.BIRCH_CRUCIBLE.getBlock(), Blocks.BIRCH_LOG);
        BlockModels.crucible(models, DefaultMaterials.JUNGLE_CRUCIBLE.getBlock(), Blocks.JUNGLE_LOG);
        BlockModels.crucible(models, DefaultMaterials.ACACIA_CRUCIBLE.getBlock(), Blocks.ACACIA_LOG);
        BlockModels.crucible(models, DefaultMaterials.DARK_OAK_CRUCIBLE.getBlock(), Blocks.DARK_OAK_LOG);
        BlockModels.crucible(models, DefaultMaterials.MANGROVE_CRUCIBLE.getBlock(), Blocks.MANGROVE_LOG);
        BlockModels.crucible(models, DefaultMaterials.CHERRY_CRUCIBLE.getBlock(), Blocks.CHERRY_LOG);
        BlockModels.crucible(models, DefaultMaterials.BAMBOO_CRUCIBLE.getBlock(), Blocks.BAMBOO_BLOCK);
        BlockModels.bopModels(models);
        BlockModels.arsNouveauModels(models);
        BlockModels.aetherModels(models);
        BlockModels.blueSkiesModels(models);
    }

    private static void arsNouveauModels(MKBlockModelProvider models) {
        BlockModels.barrel(models, DefaultMaterials.ARCHWOOD_BARREL.getBlock(), (Block)ModCompatData.ARCHWOOD_PLANKS.get());
        BlockModels.sieve(models, DefaultMaterials.ARCHWOOD_SIEVE.getBlock(), (Block)ModCompatData.ARCHWOOD_PLANKS.get());
        BlockModels.compressedSieve(models, DefaultMaterials.CASCADING_ARCHWOOD_COMPRESSED_SIEVE.getBlock(), (Block)ModCompatData.CASCADING_ARCHWOOD_LOG.get());
        BlockModels.compressedSieve(models, DefaultMaterials.BLAZING_ARCHWOOD_COMPRESSED_SIEVE.getBlock(), (Block)ModCompatData.BLAZING_ARCHWOOD_LOG.get());
        BlockModels.compressedSieve(models, DefaultMaterials.VEXING_ARCHWOOD_COMPRESSED_SIEVE.getBlock(), (Block)ModCompatData.VEXING_ARCHWOOD_LOG.get());
        BlockModels.compressedSieve(models, DefaultMaterials.FLOURISHING_ARCHWOOD_COMPRESSED_SIEVE.getBlock(), (Block)ModCompatData.FLOURISHING_ARCHWOOD_LOG.get());
        BlockModels.crucible(models, DefaultMaterials.CASCADING_ARCHWOOD_CRUCIBLE.getBlock(), (Block)ModCompatData.CASCADING_ARCHWOOD_LOG.get());
        BlockModels.crucible(models, DefaultMaterials.BLAZING_ARCHWOOD_CRUCIBLE.getBlock(), (Block)ModCompatData.BLAZING_ARCHWOOD_LOG.get());
        BlockModels.crucible(models, DefaultMaterials.VEXING_ARCHWOOD_CRUCIBLE.getBlock(), (Block)ModCompatData.VEXING_ARCHWOOD_LOG.get());
        BlockModels.crucible(models, DefaultMaterials.FLOURISHING_ARCHWOOD_CRUCIBLE.getBlock(), (Block)ModCompatData.FLOURISHING_ARCHWOOD_LOG.get());
    }

    private static void aetherModels(MKBlockModelProvider models) {
        BlockModels.barrel(models, DefaultMaterials.SKYROOT_BARREL.getBlock(), (Block)ModCompatData.SKYROOT_PLANKS.get(), "construction/");
        BlockModels.sieve(models, DefaultMaterials.SKYROOT_SIEVE.getBlock(), (Block)ModCompatData.SKYROOT_PLANKS.get(), "construction/");
        BlockModels.compressedSieve(models, DefaultMaterials.SKYROOT_COMPRESSED_SIEVE.getBlock(), (Block)ModCompatData.SKYROOT_LOG.get(), "natural/", "");
        BlockModels.compressedSieve(models, DefaultMaterials.GOLDEN_OAK_COMPRESSED_SIEVE.getBlock(), (Block)ModCompatData.GOLDEN_OAK_LOG.get(), "natural/", "");
        BlockModels.crucible(models, DefaultMaterials.SKYROOT_CRUCIBLE.getBlock(), (Block)ModCompatData.SKYROOT_LOG.get(), "natural/", "");
        BlockModels.crucible(models, DefaultMaterials.GOLDEN_OAK_CRUCIBLE.getBlock(), (Block)ModCompatData.GOLDEN_OAK_LOG.get(), "natural/", "");
    }

    private static void blueSkiesModels(MKBlockModelProvider models) {
        String woodPrefix = "wood/";
        String logSuffix = "_side";
        BlockModels.barrel(models, DefaultMaterials.BLUEBRIGHT_BARREL.getBlock(), (Block)ModCompatData.BLUEBRIGHT_PLANKS.get(), "wood/");
        BlockModels.barrel(models, DefaultMaterials.STARLIT_BARREL.getBlock(), (Block)ModCompatData.STARLIT_PLANKS.get(), "wood/");
        BlockModels.barrel(models, DefaultMaterials.FROSTBRIGHT_BARREL.getBlock(), (Block)ModCompatData.FROSTBRIGHT_PLANKS.get(), "wood/");
        BlockModels.barrel(models, DefaultMaterials.COMET_BARREL.getBlock(), (Block)ModCompatData.COMET_PLANKS.get(), "wood/");
        BlockModels.barrel(models, DefaultMaterials.LUNAR_BARREL.getBlock(), (Block)ModCompatData.LUNAR_PLANKS.get(), "wood/");
        BlockModels.barrel(models, DefaultMaterials.DUSK_BARREL.getBlock(), (Block)ModCompatData.DUSK_PLANKS.get(), "wood/");
        BlockModels.barrel(models, DefaultMaterials.MAPLE_BARREL.getBlock(), (Block)ModCompatData.MAPLE_PLANKS.get(), "wood/");
        BlockModels.barrel(models, DefaultMaterials.CRYSTALLIZED_BARREL.getBlock(), (Block)ModCompatData.CRYSTALLIZED_PLANKS.get(), "wood/").renderType("translucent");
        BlockModels.sieve(models, DefaultMaterials.BLUEBRIGHT_SIEVE.getBlock(), (Block)ModCompatData.BLUEBRIGHT_PLANKS.get(), "wood/");
        BlockModels.sieve(models, DefaultMaterials.STARLIT_SIEVE.getBlock(), (Block)ModCompatData.STARLIT_PLANKS.get(), "wood/");
        BlockModels.sieve(models, DefaultMaterials.FROSTBRIGHT_SIEVE.getBlock(), (Block)ModCompatData.FROSTBRIGHT_PLANKS.get(), "wood/");
        BlockModels.sieve(models, DefaultMaterials.COMET_SIEVE.getBlock(), (Block)ModCompatData.COMET_PLANKS.get(), "wood/");
        BlockModels.sieve(models, DefaultMaterials.LUNAR_SIEVE.getBlock(), (Block)ModCompatData.LUNAR_PLANKS.get(), "wood/");
        BlockModels.sieve(models, DefaultMaterials.DUSK_SIEVE.getBlock(), (Block)ModCompatData.DUSK_PLANKS.get(), "wood/");
        BlockModels.sieve(models, DefaultMaterials.MAPLE_SIEVE.getBlock(), (Block)ModCompatData.MAPLE_PLANKS.get(), "wood/");
        BlockModels.sieve(models, DefaultMaterials.CRYSTALLIZED_SIEVE.getBlock(), (Block)ModCompatData.CRYSTALLIZED_PLANKS.get(), "wood/").renderType("translucent");
        BlockModels.compressedSieve(models, DefaultMaterials.BLUEBRIGHT_COMPRESSED_SIEVE.getBlock(), (Block)ModCompatData.BLUEBRIGHT_LOG.get(), "wood/", "_side");
        BlockModels.compressedSieve(models, DefaultMaterials.STARLIT_COMPRESSED_SIEVE.getBlock(), (Block)ModCompatData.STARLIT_LOG.get(), "wood/", "_side");
        BlockModels.compressedSieve(models, DefaultMaterials.FROSTBRIGHT_COMPRESSED_SIEVE.getBlock(), (Block)ModCompatData.FROSTBRIGHT_LOG.get(), "wood/", "_side");
        BlockModels.compressedSieve(models, DefaultMaterials.COMET_COMPRESSED_SIEVE.getBlock(), (Block)ModCompatData.COMET_LOG.get(), "wood/", "_side");
        BlockModels.compressedSieve(models, DefaultMaterials.LUNAR_COMPRESSED_SIEVE.getBlock(), (Block)ModCompatData.LUNAR_LOG.get(), "wood/", "_side");
        BlockModels.compressedSieve(models, DefaultMaterials.DUSK_COMPRESSED_SIEVE.getBlock(), (Block)ModCompatData.DUSK_LOG.get(), "wood/", "_side");
        BlockModels.compressedSieve(models, DefaultMaterials.MAPLE_COMPRESSED_SIEVE.getBlock(), (Block)ModCompatData.MAPLE_LOG.get(), "wood/", "_side");
        BlockModels.compressedSieve(models, DefaultMaterials.CRYSTALLIZED_COMPRESSED_SIEVE.getBlock(), (Block)ModCompatData.CRYSTALLIZED_LOG.get(), "wood/", "_side").renderType("translucent");
        BlockModels.crucible(models, DefaultMaterials.BLUEBRIGHT_CRUCIBLE.getBlock(), (Block)ModCompatData.BLUEBRIGHT_LOG.get(), "wood/", "_side");
        BlockModels.crucible(models, DefaultMaterials.STARLIT_CRUCIBLE.getBlock(), (Block)ModCompatData.STARLIT_LOG.get(), "wood/", "_side");
        BlockModels.crucible(models, DefaultMaterials.FROSTBRIGHT_CRUCIBLE.getBlock(), (Block)ModCompatData.FROSTBRIGHT_LOG.get(), "wood/", "_side");
        BlockModels.crucible(models, DefaultMaterials.COMET_CRUCIBLE.getBlock(), (Block)ModCompatData.COMET_LOG.get(), "wood/", "_side");
        BlockModels.crucible(models, DefaultMaterials.LUNAR_CRUCIBLE.getBlock(), (Block)ModCompatData.LUNAR_LOG.get(), "wood/", "_side");
        BlockModels.crucible(models, DefaultMaterials.DUSK_CRUCIBLE.getBlock(), (Block)ModCompatData.DUSK_LOG.get(), "wood/", "_side");
        BlockModels.crucible(models, DefaultMaterials.MAPLE_CRUCIBLE.getBlock(), (Block)ModCompatData.MAPLE_LOG.get(), "wood/", "_side");
        BlockModels.crucible(models, DefaultMaterials.CRYSTALLIZED_CRUCIBLE.getBlock(), (Block)ModCompatData.CRYSTALLIZED_LOG.get(), "wood/", "_side").renderType("translucent");
    }

    private static void bopModels(MKBlockModelProvider models) {
        BlockModels.barrel(models, DefaultMaterials.FIR_BARREL.getBlock(), (Block)ModCompatData.FIR_PLANKS.get());
        BlockModels.barrel(models, DefaultMaterials.REDWOOD_BARREL.getBlock(), (Block)ModCompatData.REDWOOD_PLANKS.get());
        BlockModels.barrel(models, DefaultMaterials.MAHOGANY_BARREL.getBlock(), (Block)ModCompatData.MAHOGANY_PLANKS.get());
        BlockModels.barrel(models, DefaultMaterials.JACARANDA_BARREL.getBlock(), (Block)ModCompatData.JACARANDA_PLANKS.get());
        BlockModels.barrel(models, DefaultMaterials.PALM_BARREL.getBlock(), (Block)ModCompatData.PALM_PLANKS.get());
        BlockModels.barrel(models, DefaultMaterials.WILLOW_BARREL.getBlock(), (Block)ModCompatData.WILLOW_PLANKS.get());
        BlockModels.barrel(models, DefaultMaterials.DEAD_BARREL.getBlock(), (Block)ModCompatData.DEAD_PLANKS.get());
        BlockModels.barrel(models, DefaultMaterials.MAGIC_BARREL.getBlock(), (Block)ModCompatData.MAGIC_PLANKS.get());
        BlockModels.barrel(models, DefaultMaterials.UMBRAN_BARREL.getBlock(), (Block)ModCompatData.UMBRAN_PLANKS.get());
        BlockModels.barrel(models, DefaultMaterials.HELLBARK_BARREL.getBlock(), (Block)ModCompatData.HELLBARK_PLANKS.get());
        BlockModels.sieve(models, DefaultMaterials.FIR_SIEVE.getBlock(), (Block)ModCompatData.FIR_PLANKS.get());
        BlockModels.sieve(models, DefaultMaterials.REDWOOD_SIEVE.getBlock(), (Block)ModCompatData.REDWOOD_PLANKS.get());
        BlockModels.sieve(models, DefaultMaterials.MAHOGANY_SIEVE.getBlock(), (Block)ModCompatData.MAHOGANY_PLANKS.get());
        BlockModels.sieve(models, DefaultMaterials.JACARANDA_SIEVE.getBlock(), (Block)ModCompatData.JACARANDA_PLANKS.get());
        BlockModels.sieve(models, DefaultMaterials.PALM_SIEVE.getBlock(), (Block)ModCompatData.PALM_PLANKS.get());
        BlockModels.sieve(models, DefaultMaterials.WILLOW_SIEVE.getBlock(), (Block)ModCompatData.WILLOW_PLANKS.get());
        BlockModels.sieve(models, DefaultMaterials.DEAD_SIEVE.getBlock(), (Block)ModCompatData.DEAD_PLANKS.get());
        BlockModels.sieve(models, DefaultMaterials.MAGIC_SIEVE.getBlock(), (Block)ModCompatData.MAGIC_PLANKS.get());
        BlockModels.sieve(models, DefaultMaterials.UMBRAN_SIEVE.getBlock(), (Block)ModCompatData.UMBRAN_PLANKS.get());
        BlockModels.sieve(models, DefaultMaterials.HELLBARK_SIEVE.getBlock(), (Block)ModCompatData.HELLBARK_PLANKS.get());
        BlockModels.compressedSieve(models, DefaultMaterials.FIR_COMPRESSED_SIEVE.getBlock(), (Block)ModCompatData.FIR_LOG.get());
        BlockModels.compressedSieve(models, DefaultMaterials.REDWOOD_COMPRESSED_SIEVE.getBlock(), (Block)ModCompatData.REDWOOD_LOG.get());
        BlockModels.compressedSieve(models, DefaultMaterials.MAHOGANY_COMPRESSED_SIEVE.getBlock(), (Block)ModCompatData.MAHOGANY_LOG.get());
        BlockModels.compressedSieve(models, DefaultMaterials.JACARANDA_COMPRESSED_SIEVE.getBlock(), (Block)ModCompatData.JACARANDA_LOG.get());
        BlockModels.compressedSieve(models, DefaultMaterials.PALM_COMPRESSED_SIEVE.getBlock(), (Block)ModCompatData.PALM_LOG.get());
        BlockModels.compressedSieve(models, DefaultMaterials.WILLOW_COMPRESSED_SIEVE.getBlock(), (Block)ModCompatData.WILLOW_LOG.get());
        BlockModels.compressedSieve(models, DefaultMaterials.DEAD_COMPRESSED_SIEVE.getBlock(), (Block)ModCompatData.DEAD_LOG.get());
        BlockModels.compressedSieve(models, DefaultMaterials.MAGIC_COMPRESSED_SIEVE.getBlock(), (Block)ModCompatData.MAGIC_LOG.get());
        BlockModels.compressedSieve(models, DefaultMaterials.UMBRAN_COMPRESSED_SIEVE.getBlock(), (Block)ModCompatData.UMBRAN_LOG.get());
        BlockModels.compressedSieve(models, DefaultMaterials.HELLBARK_COMPRESSED_SIEVE.getBlock(), (Block)ModCompatData.HELLBARK_LOG.get());
        BlockModels.crucible(models, DefaultMaterials.FIR_CRUCIBLE.getBlock(), (Block)ModCompatData.FIR_LOG.get());
        BlockModels.crucible(models, DefaultMaterials.REDWOOD_CRUCIBLE.getBlock(), (Block)ModCompatData.REDWOOD_LOG.get());
        BlockModels.crucible(models, DefaultMaterials.MAHOGANY_CRUCIBLE.getBlock(), (Block)ModCompatData.MAHOGANY_LOG.get());
        BlockModels.crucible(models, DefaultMaterials.JACARANDA_CRUCIBLE.getBlock(), (Block)ModCompatData.JACARANDA_LOG.get());
        BlockModels.crucible(models, DefaultMaterials.PALM_CRUCIBLE.getBlock(), (Block)ModCompatData.PALM_LOG.get());
        BlockModels.crucible(models, DefaultMaterials.WILLOW_CRUCIBLE.getBlock(), (Block)ModCompatData.WILLOW_LOG.get());
        BlockModels.crucible(models, DefaultMaterials.DEAD_CRUCIBLE.getBlock(), (Block)ModCompatData.DEAD_LOG.get());
        BlockModels.crucible(models, DefaultMaterials.MAGIC_CRUCIBLE.getBlock(), (Block)ModCompatData.MAGIC_LOG.get());
        BlockModels.crucible(models, DefaultMaterials.UMBRAN_CRUCIBLE.getBlock(), (Block)ModCompatData.UMBRAN_LOG.get());
        BlockModels.crucible(models, DefaultMaterials.HELLBARK_CRUCIBLE.getBlock(), (Block)ModCompatData.HELLBARK_LOG.get());
    }

    public static void crucible(MKBlockModelProvider models, Block block) {
        BlockModels.crucible(models, block, block);
    }

    public static void compressedBlock(MKBlockModelProvider models, Block block, Block appearance) {
        ModelFile.UncheckedModelFile original = models.file(models.blockTexture(appearance));
        models.getVariantBuilder(block).partialState().addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((CompositeModelBuilder)((BlockModelBuilder)models.models().getBuilder(models.name(block))).customLoader(CompositeModelBuilder::begin)).child("base", (ModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)models.models().nested()).parent((ModelFile)original)).renderType("solid"))).child("overlay", (ModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)models.models().nested()).parent((ModelFile)models.mcFile("cube_all"))).texture("all", models.modLoc("block/compressed_overlay"))).renderType("translucent"))).itemRenderOrder(new String[]{"base", "overlay"}).end()).parent((ModelFile)models.mcFile("block"))).texture("particle", models.blockTexture(appearance)))});
    }

    public static void crucible(MKBlockModelProvider models, Block block, Block appearance) {
        BlockModels.crucible(models, block, appearance, "", "");
    }

    public static BlockModelBuilder crucible(MKBlockModelProvider models, Block block, Block appearance, String pathPrefix, String pathSuffix) {
        ResourceLocation texture = BlockModels.texture(appearance, pathPrefix, pathSuffix);
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)BlockModels.singleModel(models, block).parent((ModelFile)models.modFile("template_crucible"))).texture("inside", texture)).texture("top", texture)).texture("bottom", texture)).texture("side", texture);
    }

    private static ResourceLocation texture(Block block, String prefix, String suffix) {
        ResourceLocation key = Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block));
        return new ResourceLocation(key.getNamespace(), "block/" + prefix + key.getPath() + suffix);
    }

    public static void barrel(MKBlockModelProvider models, Block block, Block appearance) {
        BlockModels.barrel(models, block, appearance, "");
    }

    public static BlockModelBuilder barrel(MKBlockModelProvider models, Block block, Block appearance, String pathPrefix) {
        return (BlockModelBuilder)((BlockModelBuilder)BlockModels.singleModel(models, block).parent((ModelFile)models.modFile("template_barrel"))).texture("barrel", BlockModels.texture(appearance, pathPrefix, ""));
    }

    public static void sieve(MKBlockModelProvider models, Block block, Block appearance) {
        BlockModels.sieve(models, block, appearance, "");
    }

    public static BlockModelBuilder sieve(MKBlockModelProvider models, Block block, Block appearance, String pathPrefix) {
        return (BlockModelBuilder)((BlockModelBuilder)BlockModels.singleModel(models, block).parent((ModelFile)models.modFile("template_sieve"))).texture("texture", BlockModels.texture(appearance, pathPrefix, ""));
    }

    public static void compressedSieve(MKBlockModelProvider models, Block block, Block appearance) {
        BlockModels.compressedSieve(models, block, appearance, "", "");
    }

    public static BlockModelBuilder compressedSieve(MKBlockModelProvider models, Block block, Block appearance, String pathPrefix, String pathSuffix) {
        return (BlockModelBuilder)((BlockModelBuilder)BlockModels.singleModel(models, block).parent((ModelFile)models.modFile("template_compressed_sieve"))).texture("texture", BlockModels.texture(appearance, pathPrefix, pathSuffix));
    }

    public static BlockModelBuilder singleModel(MKBlockModelProvider models, Block block) {
        BlockModelBuilder builder = BlockModels.blockModel(models, block);
        models.getVariantBuilder(block).partialState().addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)builder)});
        return builder;
    }

    public static BlockModelBuilder blockModel(MKBlockModelProvider models, Block block) {
        return (BlockModelBuilder)models.models().getBuilder(models.name(block));
    }
}

