/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.data.recipe;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.providers.number.BinomialDistributionGenerator;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.ModLoadedCondition;
import net.minecraftforge.common.crafting.conditions.NotCondition;
import net.minecraftforge.common.crafting.conditions.TagEmptyCondition;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.mutable.MutableObject;
import thedarkcolour.exdeorum.block.CompressedBlockType;
import thedarkcolour.exdeorum.block.InfestedLeavesBlock;
import thedarkcolour.exdeorum.data.ModCompatData;
import thedarkcolour.exdeorum.data.recipe.SieveRecipes;
import thedarkcolour.exdeorum.material.DefaultMaterials;
import thedarkcolour.exdeorum.recipe.BlockPredicate;
import thedarkcolour.exdeorum.recipe.TagResultRecipe;
import thedarkcolour.exdeorum.recipe.WeightedList;
import thedarkcolour.exdeorum.recipe.barrel.FinishedBarrelCompostRecipe;
import thedarkcolour.exdeorum.recipe.barrel.FinishedBarrelFluidMixingRecipe;
import thedarkcolour.exdeorum.recipe.barrel.FinishedBarrelMixingRecipe;
import thedarkcolour.exdeorum.recipe.barrel.FinishedFluidTransformationRecipe;
import thedarkcolour.exdeorum.recipe.crook.FinishedCrookRecipe;
import thedarkcolour.exdeorum.recipe.crucible.FinishedCrucibleHeatRecipe;
import thedarkcolour.exdeorum.recipe.crucible.FinishedCrucibleRecipe;
import thedarkcolour.exdeorum.recipe.hammer.FinishedCompressedHammerRecipe;
import thedarkcolour.exdeorum.recipe.hammer.FinishedHammerRecipe;
import thedarkcolour.exdeorum.registry.EBlocks;
import thedarkcolour.exdeorum.registry.ECompressedBlocks;
import thedarkcolour.exdeorum.registry.EFluids;
import thedarkcolour.exdeorum.registry.EItems;
import thedarkcolour.exdeorum.registry.ERecipeSerializers;
import thedarkcolour.exdeorum.tag.EItemTags;
import thedarkcolour.modkit.data.MKRecipeProvider;

public class Recipes {
    private static final Ingredient SPORES_AND_SEEDS = MKRecipeProvider.ingredient((Supplier[])new Supplier[]{EItems.GRASS_SEEDS, EItems.MYCELIUM_SPORES, EItems.WARPED_NYLIUM_SPORES, EItems.CRIMSON_NYLIUM_SPORES});
    static final ICondition AE2 = Recipes.modInstalled("ae2");
    static final ICondition ENDERIO = Recipes.modInstalled("enderio");
    static final ICondition EXTREME_REACTORS = Recipes.modInstalled("bigreactors");

    public static void addRecipes(Consumer<FinishedRecipe> writer, MKRecipeProvider recipes) {
        Recipes.craftingRecipes(writer, recipes);
        Recipes.smeltingRecipes(recipes);
        SieveRecipes.sieveRecipes(writer);
        Recipes.crucibleRecipes(writer);
        Recipes.hammerRecipes(writer);
        Recipes.compressedHammerRecipes(writer);
        Recipes.crookRecipes(writer);
        Recipes.crucibleHeatSources(writer);
        Recipes.barrelCompostRecipes(writer);
        Recipes.barrelMixingRecipes(writer);
        Recipes.fluidTransformationRecipes(writer);
    }

    private static void craftingRecipes(Consumer<FinishedRecipe> writer, MKRecipeProvider recipes) {
        Recipes.shapedCrook(recipes, EItems.CROOK, MKRecipeProvider.ingredient((TagKey)Tags.Items.RODS_WOODEN));
        Recipes.shapedCrook(recipes, EItems.BONE_CROOK, MKRecipeProvider.ingredient((ItemLike)Items.BONE));
        Recipes.shapedHammer(recipes, EItems.WOODEN_HAMMER, MKRecipeProvider.ingredient((TagKey)ItemTags.PLANKS));
        Recipes.shapedHammer(recipes, EItems.STONE_HAMMER, MKRecipeProvider.ingredient((TagKey)ItemTags.STONE_CRAFTING_MATERIALS));
        Recipes.shapedHammer(recipes, EItems.GOLDEN_HAMMER, MKRecipeProvider.ingredient((TagKey)Tags.Items.INGOTS_GOLD));
        Recipes.shapedHammer(recipes, EItems.IRON_HAMMER, MKRecipeProvider.ingredient((TagKey)Tags.Items.INGOTS_IRON));
        Recipes.shapedHammer(recipes, EItems.DIAMOND_HAMMER, MKRecipeProvider.ingredient((TagKey)Tags.Items.GEMS_DIAMOND));
        recipes.netheriteUpgrade(RecipeCategory.TOOLS, MKRecipeProvider.ingredient((ItemLike)((ItemLike)EItems.DIAMOND_HAMMER.get())), (ItemLike)EItems.NETHERITE_HAMMER.get());
        Recipes.uShaped(recipes, DefaultMaterials.OAK_CRUCIBLE.getItem(), MKRecipeProvider.ingredient((ItemLike)Items.OAK_LOG), MKRecipeProvider.ingredient((ItemLike)Items.OAK_SLAB));
        Recipes.uShaped(recipes, DefaultMaterials.SPRUCE_CRUCIBLE.getItem(), MKRecipeProvider.ingredient((ItemLike)Items.SPRUCE_LOG), MKRecipeProvider.ingredient((ItemLike)Items.SPRUCE_SLAB));
        Recipes.uShaped(recipes, DefaultMaterials.BIRCH_CRUCIBLE.getItem(), MKRecipeProvider.ingredient((ItemLike)Items.BIRCH_LOG), MKRecipeProvider.ingredient((ItemLike)Items.BIRCH_SLAB));
        Recipes.uShaped(recipes, DefaultMaterials.JUNGLE_CRUCIBLE.getItem(), MKRecipeProvider.ingredient((ItemLike)Items.JUNGLE_LOG), MKRecipeProvider.ingredient((ItemLike)Items.JUNGLE_SLAB));
        Recipes.uShaped(recipes, DefaultMaterials.ACACIA_CRUCIBLE.getItem(), MKRecipeProvider.ingredient((ItemLike)Items.ACACIA_LOG), MKRecipeProvider.ingredient((ItemLike)Items.ACACIA_SLAB));
        Recipes.uShaped(recipes, DefaultMaterials.DARK_OAK_CRUCIBLE.getItem(), MKRecipeProvider.ingredient((ItemLike)Items.DARK_OAK_LOG), MKRecipeProvider.ingredient((ItemLike)Items.DARK_OAK_SLAB));
        Recipes.uShaped(recipes, DefaultMaterials.MANGROVE_CRUCIBLE.getItem(), MKRecipeProvider.ingredient((ItemLike)Items.MANGROVE_LOG), MKRecipeProvider.ingredient((ItemLike)Items.MANGROVE_SLAB));
        Recipes.uShaped(recipes, DefaultMaterials.CHERRY_CRUCIBLE.getItem(), MKRecipeProvider.ingredient((ItemLike)Items.CHERRY_LOG), MKRecipeProvider.ingredient((ItemLike)Items.CHERRY_SLAB));
        Recipes.uShaped(recipes, DefaultMaterials.BAMBOO_CRUCIBLE.getItem(), MKRecipeProvider.ingredient((ItemLike)Items.BAMBOO_BLOCK), MKRecipeProvider.ingredient((ItemLike)Items.BAMBOO_SLAB));
        Recipes.uShaped(recipes, DefaultMaterials.CRIMSON_CRUCIBLE.getItem(), MKRecipeProvider.ingredient((ItemLike)Items.CRIMSON_STEM), MKRecipeProvider.ingredient((ItemLike)Items.CRIMSON_SLAB));
        Recipes.uShaped(recipes, DefaultMaterials.WARPED_CRUCIBLE.getItem(), MKRecipeProvider.ingredient((ItemLike)Items.WARPED_STEM), MKRecipeProvider.ingredient((ItemLike)Items.WARPED_SLAB));
        Recipes.uShaped(recipes, (Item)EItems.UNFIRED_PORCELAIN_CRUCIBLE.get(), MKRecipeProvider.ingredient((ItemLike)((ItemLike)EItems.PORCELAIN_CLAY_BALL.get())), MKRecipeProvider.ingredient((ItemLike)((ItemLike)EItems.PORCELAIN_CLAY_BALL.get())));
        Recipes.modUShaped(recipes, "biomesoplenty", ModCompatData.FIR_LOG_ITEM, ModCompatData.FIR_SLAB, DefaultMaterials.FIR_CRUCIBLE.getItem());
        Recipes.modUShaped(recipes, "biomesoplenty", ModCompatData.REDWOOD_LOG_ITEM, ModCompatData.REDWOOD_SLAB, DefaultMaterials.REDWOOD_CRUCIBLE.getItem());
        Recipes.modUShaped(recipes, "biomesoplenty", ModCompatData.MAHOGANY_LOG_ITEM, ModCompatData.MAHOGANY_SLAB, DefaultMaterials.MAHOGANY_CRUCIBLE.getItem());
        Recipes.modUShaped(recipes, "biomesoplenty", ModCompatData.JACARANDA_LOG_ITEM, ModCompatData.JACARANDA_SLAB, DefaultMaterials.JACARANDA_CRUCIBLE.getItem());
        Recipes.modUShaped(recipes, "biomesoplenty", ModCompatData.PALM_LOG_ITEM, ModCompatData.PALM_SLAB, DefaultMaterials.PALM_CRUCIBLE.getItem());
        Recipes.modUShaped(recipes, "biomesoplenty", ModCompatData.WILLOW_LOG_ITEM, ModCompatData.WILLOW_SLAB, DefaultMaterials.WILLOW_CRUCIBLE.getItem());
        Recipes.modUShaped(recipes, "biomesoplenty", ModCompatData.DEAD_LOG_ITEM, ModCompatData.DEAD_SLAB, DefaultMaterials.DEAD_CRUCIBLE.getItem());
        Recipes.modUShaped(recipes, "biomesoplenty", ModCompatData.MAGIC_LOG_ITEM, ModCompatData.MAGIC_SLAB, DefaultMaterials.MAGIC_CRUCIBLE.getItem());
        Recipes.modUShaped(recipes, "biomesoplenty", ModCompatData.UMBRAN_LOG_ITEM, ModCompatData.UMBRAN_SLAB, DefaultMaterials.UMBRAN_CRUCIBLE.getItem());
        Recipes.modUShaped(recipes, "biomesoplenty", ModCompatData.HELLBARK_LOG_ITEM, ModCompatData.HELLBARK_SLAB, DefaultMaterials.HELLBARK_CRUCIBLE.getItem());
        Recipes.modUShaped(recipes, "ars_nouveau", ModCompatData.CASCADING_ARCHWOOD_LOG_ITEM, ModCompatData.ARCHWOOD_SLAB, DefaultMaterials.CASCADING_ARCHWOOD_CRUCIBLE.getItem());
        Recipes.modUShaped(recipes, "ars_nouveau", ModCompatData.BLAZING_ARCHWOOD_LOG_ITEM, ModCompatData.ARCHWOOD_SLAB, DefaultMaterials.BLAZING_ARCHWOOD_CRUCIBLE.getItem());
        Recipes.modUShaped(recipes, "ars_nouveau", ModCompatData.VEXING_ARCHWOOD_LOG_ITEM, ModCompatData.ARCHWOOD_SLAB, DefaultMaterials.VEXING_ARCHWOOD_CRUCIBLE.getItem());
        Recipes.modUShaped(recipes, "ars_nouveau", ModCompatData.FLOURISHING_ARCHWOOD_LOG_ITEM, ModCompatData.ARCHWOOD_SLAB, DefaultMaterials.FLOURISHING_ARCHWOOD_CRUCIBLE.getItem());
        Recipes.modUShaped(recipes, "aether", ModCompatData.GOLDEN_OAK_LOG_ITEM, ModCompatData.SKYROOT_SLAB, DefaultMaterials.GOLDEN_OAK_CRUCIBLE.getItem());
        Recipes.modUShaped(recipes, "aether", ModCompatData.SKYROOT_LOG_ITEM, ModCompatData.SKYROOT_SLAB, DefaultMaterials.SKYROOT_CRUCIBLE.getItem());
        Recipes.modUShaped(recipes, "blue_skies", ModCompatData.BLUEBRIGHT_LOG_ITEM, ModCompatData.BLUEBRIGHT_SLAB, DefaultMaterials.BLUEBRIGHT_CRUCIBLE.getItem());
        Recipes.modUShaped(recipes, "blue_skies", ModCompatData.STARLIT_LOG_ITEM, ModCompatData.STARLIT_SLAB, DefaultMaterials.STARLIT_CRUCIBLE.getItem());
        Recipes.modUShaped(recipes, "blue_skies", ModCompatData.FROSTBRIGHT_LOG_ITEM, ModCompatData.FROSTBRIGHT_SLAB, DefaultMaterials.FROSTBRIGHT_CRUCIBLE.getItem());
        Recipes.modUShaped(recipes, "blue_skies", ModCompatData.COMET_LOG_ITEM, ModCompatData.COMET_SLAB, DefaultMaterials.COMET_CRUCIBLE.getItem());
        Recipes.modUShaped(recipes, "blue_skies", ModCompatData.LUNAR_LOG_ITEM, ModCompatData.LUNAR_SLAB, DefaultMaterials.LUNAR_CRUCIBLE.getItem());
        Recipes.modUShaped(recipes, "blue_skies", ModCompatData.DUSK_LOG_ITEM, ModCompatData.DUSK_SLAB, DefaultMaterials.DUSK_CRUCIBLE.getItem());
        Recipes.modUShaped(recipes, "blue_skies", ModCompatData.MAPLE_LOG_ITEM, ModCompatData.MAPLE_SLAB, DefaultMaterials.MAPLE_CRUCIBLE.getItem());
        Recipes.modUShaped(recipes, "blue_skies", ModCompatData.CRYSTALLIZED_LOG_ITEM, ModCompatData.CRYSTALLIZED_SLAB, DefaultMaterials.CRYSTALLIZED_CRUCIBLE.getItem());
        Recipes.uShaped(recipes, DefaultMaterials.OAK_BARREL.getItem(), MKRecipeProvider.ingredient((ItemLike)Items.OAK_PLANKS), MKRecipeProvider.ingredient((ItemLike)Items.OAK_SLAB));
        Recipes.uShaped(recipes, DefaultMaterials.SPRUCE_BARREL.getItem(), MKRecipeProvider.ingredient((ItemLike)Items.SPRUCE_PLANKS), MKRecipeProvider.ingredient((ItemLike)Items.SPRUCE_SLAB));
        Recipes.uShaped(recipes, DefaultMaterials.BIRCH_BARREL.getItem(), MKRecipeProvider.ingredient((ItemLike)Items.BIRCH_PLANKS), MKRecipeProvider.ingredient((ItemLike)Items.BIRCH_SLAB));
        Recipes.uShaped(recipes, DefaultMaterials.JUNGLE_BARREL.getItem(), MKRecipeProvider.ingredient((ItemLike)Items.JUNGLE_PLANKS), MKRecipeProvider.ingredient((ItemLike)Items.JUNGLE_SLAB));
        Recipes.uShaped(recipes, DefaultMaterials.ACACIA_BARREL.getItem(), MKRecipeProvider.ingredient((ItemLike)Items.ACACIA_PLANKS), MKRecipeProvider.ingredient((ItemLike)Items.ACACIA_SLAB));
        Recipes.uShaped(recipes, DefaultMaterials.DARK_OAK_BARREL.getItem(), MKRecipeProvider.ingredient((ItemLike)Items.DARK_OAK_PLANKS), MKRecipeProvider.ingredient((ItemLike)Items.DARK_OAK_SLAB));
        Recipes.uShaped(recipes, DefaultMaterials.MANGROVE_BARREL.getItem(), MKRecipeProvider.ingredient((ItemLike)Items.MANGROVE_PLANKS), MKRecipeProvider.ingredient((ItemLike)Items.MANGROVE_SLAB));
        Recipes.uShaped(recipes, DefaultMaterials.CHERRY_BARREL.getItem(), MKRecipeProvider.ingredient((ItemLike)Items.CHERRY_PLANKS), MKRecipeProvider.ingredient((ItemLike)Items.CHERRY_SLAB));
        Recipes.uShaped(recipes, DefaultMaterials.BAMBOO_BARREL.getItem(), MKRecipeProvider.ingredient((ItemLike)Items.BAMBOO_PLANKS), MKRecipeProvider.ingredient((ItemLike)Items.BAMBOO_SLAB));
        Recipes.uShaped(recipes, DefaultMaterials.CRIMSON_BARREL.getItem(), MKRecipeProvider.ingredient((ItemLike)Items.CRIMSON_PLANKS), MKRecipeProvider.ingredient((ItemLike)Items.CRIMSON_SLAB));
        Recipes.uShaped(recipes, DefaultMaterials.WARPED_BARREL.getItem(), MKRecipeProvider.ingredient((ItemLike)Items.WARPED_PLANKS), MKRecipeProvider.ingredient((ItemLike)Items.WARPED_SLAB));
        Recipes.uShaped(recipes, DefaultMaterials.STONE_BARREL.getItem(), MKRecipeProvider.ingredient((ItemLike)Items.STONE), MKRecipeProvider.ingredient((ItemLike)Items.STONE_SLAB));
        Recipes.modUShaped(recipes, "biomesoplenty", ModCompatData.FIR_PLANKS_ITEM, ModCompatData.FIR_SLAB, DefaultMaterials.FIR_BARREL.getItem());
        Recipes.modUShaped(recipes, "biomesoplenty", ModCompatData.REDWOOD_PLANKS_ITEM, ModCompatData.REDWOOD_SLAB, DefaultMaterials.REDWOOD_BARREL.getItem());
        Recipes.modUShaped(recipes, "biomesoplenty", ModCompatData.MAHOGANY_PLANKS_ITEM, ModCompatData.MAHOGANY_SLAB, DefaultMaterials.MAHOGANY_BARREL.getItem());
        Recipes.modUShaped(recipes, "biomesoplenty", ModCompatData.JACARANDA_PLANKS_ITEM, ModCompatData.JACARANDA_SLAB, DefaultMaterials.JACARANDA_BARREL.getItem());
        Recipes.modUShaped(recipes, "biomesoplenty", ModCompatData.PALM_PLANKS_ITEM, ModCompatData.PALM_SLAB, DefaultMaterials.PALM_BARREL.getItem());
        Recipes.modUShaped(recipes, "biomesoplenty", ModCompatData.WILLOW_PLANKS_ITEM, ModCompatData.WILLOW_SLAB, DefaultMaterials.WILLOW_BARREL.getItem());
        Recipes.modUShaped(recipes, "biomesoplenty", ModCompatData.DEAD_PLANKS_ITEM, ModCompatData.DEAD_SLAB, DefaultMaterials.DEAD_BARREL.getItem());
        Recipes.modUShaped(recipes, "biomesoplenty", ModCompatData.MAGIC_PLANKS_ITEM, ModCompatData.MAGIC_SLAB, DefaultMaterials.MAGIC_BARREL.getItem());
        Recipes.modUShaped(recipes, "biomesoplenty", ModCompatData.UMBRAN_PLANKS_ITEM, ModCompatData.UMBRAN_SLAB, DefaultMaterials.UMBRAN_BARREL.getItem());
        Recipes.modUShaped(recipes, "biomesoplenty", ModCompatData.HELLBARK_PLANKS_ITEM, ModCompatData.HELLBARK_SLAB, DefaultMaterials.HELLBARK_BARREL.getItem());
        Recipes.modUShaped(recipes, "ars_nouveau", ModCompatData.ARCHWOOD_PLANKS_ITEM, ModCompatData.ARCHWOOD_SLAB, DefaultMaterials.ARCHWOOD_BARREL.getItem());
        Recipes.modUShaped(recipes, "aether", ModCompatData.SKYROOT_PLANKS_ITEM, ModCompatData.SKYROOT_SLAB, DefaultMaterials.SKYROOT_BARREL.getItem());
        Recipes.modUShaped(recipes, "blue_skies", ModCompatData.BLUEBRIGHT_PLANKS_ITEM, ModCompatData.BLUEBRIGHT_SLAB, DefaultMaterials.BLUEBRIGHT_BARREL.getItem());
        Recipes.modUShaped(recipes, "blue_skies", ModCompatData.STARLIT_PLANKS_ITEM, ModCompatData.STARLIT_SLAB, DefaultMaterials.STARLIT_BARREL.getItem());
        Recipes.modUShaped(recipes, "blue_skies", ModCompatData.FROSTBRIGHT_PLANKS_ITEM, ModCompatData.FROSTBRIGHT_SLAB, DefaultMaterials.FROSTBRIGHT_BARREL.getItem());
        Recipes.modUShaped(recipes, "blue_skies", ModCompatData.COMET_PLANKS_ITEM, ModCompatData.COMET_SLAB, DefaultMaterials.COMET_BARREL.getItem());
        Recipes.modUShaped(recipes, "blue_skies", ModCompatData.LUNAR_PLANKS_ITEM, ModCompatData.LUNAR_SLAB, DefaultMaterials.LUNAR_BARREL.getItem());
        Recipes.modUShaped(recipes, "blue_skies", ModCompatData.DUSK_PLANKS_ITEM, ModCompatData.DUSK_SLAB, DefaultMaterials.DUSK_BARREL.getItem());
        Recipes.modUShaped(recipes, "blue_skies", ModCompatData.MAPLE_PLANKS_ITEM, ModCompatData.MAPLE_SLAB, DefaultMaterials.MAPLE_BARREL.getItem());
        Recipes.modUShaped(recipes, "blue_skies", ModCompatData.CRYSTALLIZED_PLANKS_ITEM, ModCompatData.CRYSTALLIZED_SLAB, DefaultMaterials.CRYSTALLIZED_BARREL.getItem());
        recipes.grid2x2((ItemLike)Items.COBBLESTONE, MKRecipeProvider.ingredient(EItems.STONE_PEBBLE));
        recipes.grid2x2((ItemLike)Items.ANDESITE, MKRecipeProvider.ingredient(EItems.ANDESITE_PEBBLE));
        recipes.grid2x2((ItemLike)Items.DIORITE, MKRecipeProvider.ingredient(EItems.DIORITE_PEBBLE));
        recipes.grid2x2((ItemLike)Items.GRANITE, MKRecipeProvider.ingredient(EItems.GRANITE_PEBBLE));
        recipes.grid2x2((ItemLike)Items.COBBLED_DEEPSLATE, MKRecipeProvider.ingredient(EItems.DEEPSLATE_PEBBLE));
        recipes.grid2x2((ItemLike)Items.TUFF, MKRecipeProvider.ingredient(EItems.TUFF_PEBBLE));
        recipes.grid2x2((ItemLike)Items.CALCITE, MKRecipeProvider.ingredient(EItems.CALCITE_PEBBLE));
        recipes.grid2x2((ItemLike)Items.BLACKSTONE, MKRecipeProvider.ingredient(EItems.BLACKSTONE_PEBBLE));
        recipes.grid2x2((ItemLike)Items.BASALT, MKRecipeProvider.ingredient(EItems.BASALT_PEBBLE));
        recipes.grid2x2((ItemLike)Items.IRON_ORE, MKRecipeProvider.ingredient(EItems.IRON_ORE_CHUNK));
        recipes.grid2x2((ItemLike)Items.GOLD_ORE, MKRecipeProvider.ingredient(EItems.GOLD_ORE_CHUNK));
        recipes.grid2x2((ItemLike)Items.COPPER_ORE, MKRecipeProvider.ingredient(EItems.COPPER_ORE_CHUNK));
        recipes.grid2x2((ItemLike)Items.MOSS_BLOCK, MKRecipeProvider.ingredient(EItems.GRASS_SEEDS));
        recipes.grid3x3(RecipeCategory.TOOLS, (ItemLike)EItems.COMPRESSED_WOODEN_HAMMER.get(), MKRecipeProvider.ingredient(EItems.WOODEN_HAMMER));
        recipes.grid3x3(RecipeCategory.TOOLS, (ItemLike)EItems.COMPRESSED_STONE_HAMMER.get(), MKRecipeProvider.ingredient(EItems.STONE_HAMMER));
        recipes.grid3x3(RecipeCategory.TOOLS, (ItemLike)EItems.COMPRESSED_GOLDEN_HAMMER.get(), MKRecipeProvider.ingredient(EItems.GOLDEN_HAMMER));
        recipes.grid3x3(RecipeCategory.TOOLS, (ItemLike)EItems.COMPRESSED_IRON_HAMMER.get(), MKRecipeProvider.ingredient(EItems.IRON_HAMMER));
        recipes.grid3x3(RecipeCategory.TOOLS, (ItemLike)EItems.COMPRESSED_DIAMOND_HAMMER.get(), MKRecipeProvider.ingredient(EItems.DIAMOND_HAMMER));
        recipes.grid3x3(RecipeCategory.TOOLS, (ItemLike)EItems.COMPRESSED_NETHERITE_HAMMER.get(), MKRecipeProvider.ingredient(EItems.NETHERITE_HAMMER));
        for (CompressedBlockType variant : ECompressedBlocks.ALL_VARIANTS) {
            Block storage = variant.getBlock();
            Block material = variant.getBase();
            if (variant.hasCompressium() || variant.hasAtc()) {
                ArrayList<ICondition> conditions = new ArrayList<ICondition>();
                if (variant.hasAtc()) {
                    conditions.add(Recipes.modNotInstalled("allthecompressed"));
                }
                if (variant.hasCompressium()) {
                    conditions.add(Recipes.modNotInstalled("compressium"));
                }
                recipes.conditional(MKRecipeProvider.path((ItemLike)storage), conditions, newWriter -> recipes.grid3x3(RecipeCategory.BUILDING_BLOCKS, (ItemLike)storage, Ingredient.of((ItemLike[])new ItemLike[]{material})));
            } else {
                recipes.grid3x3(RecipeCategory.BUILDING_BLOCKS, (ItemLike)storage, Ingredient.of((ItemLike[])new ItemLike[]{material}));
            }
            ShapelessRecipeBuilder fromStorage = new ShapelessRecipeBuilder(RecipeCategory.MISC, (ItemLike)material, 9);
            MKRecipeProvider.unlockedByHaving((Object)fromStorage, (ItemLike)storage);
            fromStorage.requires((ItemLike)storage);
            fromStorage.save(writer, MKRecipeProvider.id((ItemLike)material).withSuffix("_from_" + MKRecipeProvider.id((ItemLike)storage).getPath()));
        }
        Recipes.compressedSieve(recipes, DefaultMaterials.OAK_COMPRESSED_SIEVE, MKRecipeProvider.ingredient((ItemLike)Items.OAK_LOG));
        Recipes.compressedSieve(recipes, DefaultMaterials.SPRUCE_COMPRESSED_SIEVE, MKRecipeProvider.ingredient((ItemLike)Items.SPRUCE_LOG));
        Recipes.compressedSieve(recipes, DefaultMaterials.BIRCH_COMPRESSED_SIEVE, MKRecipeProvider.ingredient((ItemLike)Items.BIRCH_LOG));
        Recipes.compressedSieve(recipes, DefaultMaterials.JUNGLE_COMPRESSED_SIEVE, MKRecipeProvider.ingredient((ItemLike)Items.JUNGLE_LOG));
        Recipes.compressedSieve(recipes, DefaultMaterials.ACACIA_COMPRESSED_SIEVE, MKRecipeProvider.ingredient((ItemLike)Items.ACACIA_LOG));
        Recipes.compressedSieve(recipes, DefaultMaterials.DARK_OAK_COMPRESSED_SIEVE, MKRecipeProvider.ingredient((ItemLike)Items.DARK_OAK_LOG));
        Recipes.compressedSieve(recipes, DefaultMaterials.MANGROVE_COMPRESSED_SIEVE, MKRecipeProvider.ingredient((ItemLike)Items.MANGROVE_LOG));
        Recipes.compressedSieve(recipes, DefaultMaterials.CHERRY_COMPRESSED_SIEVE, MKRecipeProvider.ingredient((ItemLike)Items.CHERRY_LOG));
        Recipes.compressedSieve(recipes, DefaultMaterials.BAMBOO_COMPRESSED_SIEVE, MKRecipeProvider.ingredient((ItemLike)Items.BAMBOO_BLOCK));
        Recipes.compressedSieve(recipes, DefaultMaterials.WARPED_COMPRESSED_SIEVE, MKRecipeProvider.ingredient((ItemLike)Items.WARPED_STEM));
        Recipes.compressedSieve(recipes, DefaultMaterials.CRIMSON_COMPRESSED_SIEVE, MKRecipeProvider.ingredient((ItemLike)Items.CRIMSON_STEM));
        Recipes.modCompressedSieve(recipes, "biomesoplenty", DefaultMaterials.FIR_COMPRESSED_SIEVE, MKRecipeProvider.ingredient(ModCompatData.FIR_LOG_ITEM));
        Recipes.modCompressedSieve(recipes, "biomesoplenty", DefaultMaterials.REDWOOD_COMPRESSED_SIEVE, MKRecipeProvider.ingredient(ModCompatData.REDWOOD_LOG_ITEM));
        Recipes.modCompressedSieve(recipes, "biomesoplenty", DefaultMaterials.MAHOGANY_COMPRESSED_SIEVE, MKRecipeProvider.ingredient(ModCompatData.MAHOGANY_LOG_ITEM));
        Recipes.modCompressedSieve(recipes, "biomesoplenty", DefaultMaterials.JACARANDA_COMPRESSED_SIEVE, MKRecipeProvider.ingredient(ModCompatData.JACARANDA_LOG_ITEM));
        Recipes.modCompressedSieve(recipes, "biomesoplenty", DefaultMaterials.PALM_COMPRESSED_SIEVE, MKRecipeProvider.ingredient(ModCompatData.PALM_LOG_ITEM));
        Recipes.modCompressedSieve(recipes, "biomesoplenty", DefaultMaterials.WILLOW_COMPRESSED_SIEVE, MKRecipeProvider.ingredient(ModCompatData.WILLOW_LOG_ITEM));
        Recipes.modCompressedSieve(recipes, "biomesoplenty", DefaultMaterials.DEAD_COMPRESSED_SIEVE, MKRecipeProvider.ingredient(ModCompatData.DEAD_LOG_ITEM));
        Recipes.modCompressedSieve(recipes, "biomesoplenty", DefaultMaterials.MAGIC_COMPRESSED_SIEVE, MKRecipeProvider.ingredient(ModCompatData.MAGIC_LOG_ITEM));
        Recipes.modCompressedSieve(recipes, "biomesoplenty", DefaultMaterials.UMBRAN_COMPRESSED_SIEVE, MKRecipeProvider.ingredient(ModCompatData.UMBRAN_LOG_ITEM));
        Recipes.modCompressedSieve(recipes, "biomesoplenty", DefaultMaterials.HELLBARK_COMPRESSED_SIEVE, MKRecipeProvider.ingredient(ModCompatData.HELLBARK_LOG_ITEM));
        Recipes.modCompressedSieve(recipes, "ars_nouveau", DefaultMaterials.CASCADING_ARCHWOOD_COMPRESSED_SIEVE, MKRecipeProvider.ingredient(ModCompatData.CASCADING_ARCHWOOD_LOG_ITEM));
        Recipes.modCompressedSieve(recipes, "ars_nouveau", DefaultMaterials.BLAZING_ARCHWOOD_COMPRESSED_SIEVE, MKRecipeProvider.ingredient(ModCompatData.BLAZING_ARCHWOOD_LOG_ITEM));
        Recipes.modCompressedSieve(recipes, "ars_nouveau", DefaultMaterials.VEXING_ARCHWOOD_COMPRESSED_SIEVE, MKRecipeProvider.ingredient(ModCompatData.VEXING_ARCHWOOD_LOG_ITEM));
        Recipes.modCompressedSieve(recipes, "ars_nouveau", DefaultMaterials.FLOURISHING_ARCHWOOD_COMPRESSED_SIEVE, MKRecipeProvider.ingredient(ModCompatData.FLOURISHING_ARCHWOOD_LOG_ITEM));
        Recipes.modCompressedSieve(recipes, "aether", DefaultMaterials.SKYROOT_COMPRESSED_SIEVE, MKRecipeProvider.ingredient(ModCompatData.SKYROOT_LOG_ITEM));
        Recipes.modCompressedSieve(recipes, "aether", DefaultMaterials.GOLDEN_OAK_COMPRESSED_SIEVE, MKRecipeProvider.ingredient(ModCompatData.GOLDEN_OAK_LOG_ITEM));
        Recipes.modCompressedSieve(recipes, "blue_skies", DefaultMaterials.BLUEBRIGHT_COMPRESSED_SIEVE, MKRecipeProvider.ingredient(ModCompatData.BLUEBRIGHT_LOG_ITEM));
        Recipes.modCompressedSieve(recipes, "blue_skies", DefaultMaterials.STARLIT_COMPRESSED_SIEVE, MKRecipeProvider.ingredient(ModCompatData.STARLIT_LOG_ITEM));
        Recipes.modCompressedSieve(recipes, "blue_skies", DefaultMaterials.FROSTBRIGHT_COMPRESSED_SIEVE, MKRecipeProvider.ingredient(ModCompatData.FROSTBRIGHT_LOG_ITEM));
        Recipes.modCompressedSieve(recipes, "blue_skies", DefaultMaterials.COMET_COMPRESSED_SIEVE, MKRecipeProvider.ingredient(ModCompatData.COMET_LOG_ITEM));
        Recipes.modCompressedSieve(recipes, "blue_skies", DefaultMaterials.LUNAR_COMPRESSED_SIEVE, MKRecipeProvider.ingredient(ModCompatData.LUNAR_LOG_ITEM));
        Recipes.modCompressedSieve(recipes, "blue_skies", DefaultMaterials.DUSK_COMPRESSED_SIEVE, MKRecipeProvider.ingredient(ModCompatData.DUSK_LOG_ITEM));
        Recipes.modCompressedSieve(recipes, "blue_skies", DefaultMaterials.MAPLE_COMPRESSED_SIEVE, MKRecipeProvider.ingredient(ModCompatData.MAPLE_LOG_ITEM));
        Recipes.modCompressedSieve(recipes, "blue_skies", DefaultMaterials.CRYSTALLIZED_COMPRESSED_SIEVE, MKRecipeProvider.ingredient(ModCompatData.CRYSTALLIZED_LOG_ITEM));
        Recipes.grid2x2TagResult(writer, recipes, EItemTags.ORES_ALUMINUM, MKRecipeProvider.ingredient(EItems.ALUMINUM_ORE_CHUNK));
        Recipes.grid2x2TagResult(writer, recipes, EItemTags.ORES_COBALT, MKRecipeProvider.ingredient(EItems.COBALT_ORE_CHUNK));
        Recipes.grid2x2TagResult(writer, recipes, EItemTags.ORES_SILVER, MKRecipeProvider.ingredient(EItems.SILVER_ORE_CHUNK));
        Recipes.grid2x2TagResult(writer, recipes, EItemTags.ORES_LEAD, MKRecipeProvider.ingredient(EItems.LEAD_ORE_CHUNK));
        Recipes.grid2x2TagResult(writer, recipes, EItemTags.ORES_PLATINUM, MKRecipeProvider.ingredient(EItems.PLATINUM_ORE_CHUNK));
        Recipes.grid2x2TagResult(writer, recipes, EItemTags.ORES_NICKEL, MKRecipeProvider.ingredient(EItems.NICKEL_ORE_CHUNK));
        Recipes.grid2x2TagResult(writer, recipes, EItemTags.ORES_URANIUM, MKRecipeProvider.ingredient(EItems.URANIUM_ORE_CHUNK));
        Recipes.grid2x2TagResult(writer, recipes, EItemTags.ORES_OSMIUM, MKRecipeProvider.ingredient(EItems.OSMIUM_ORE_CHUNK));
        Recipes.grid2x2TagResult(writer, recipes, EItemTags.ORES_TIN, MKRecipeProvider.ingredient(EItems.TIN_ORE_CHUNK));
        Recipes.grid2x2TagResult(writer, recipes, EItemTags.ORES_ZINC, MKRecipeProvider.ingredient(EItems.ZINC_ORE_CHUNK));
        Recipes.grid2x2TagResult(writer, recipes, EItemTags.ORES_IRIDIUM, MKRecipeProvider.ingredient(EItems.IRIDIUM_ORE_CHUNK));
        Recipes.grid2x2TagResult(writer, recipes, EItemTags.ORES_THORIUM, MKRecipeProvider.ingredient(EItems.THORIUM_ORE_CHUNK));
        Recipes.grid2x2TagResult(writer, recipes, EItemTags.ORES_MAGNESIUM, MKRecipeProvider.ingredient(EItems.MAGNESIUM_ORE_CHUNK));
        Recipes.grid2x2TagResult(writer, recipes, EItemTags.ORES_LITHIUM, MKRecipeProvider.ingredient(EItems.LITHIUM_ORE_CHUNK));
        Recipes.grid2x2TagResult(writer, recipes, EItemTags.ORES_BORON, MKRecipeProvider.ingredient(EItems.BORON_ORE_CHUNK));
        Recipes.sieve(recipes, DefaultMaterials.OAK_SIEVE.getItem(), Items.OAK_PLANKS, Items.OAK_SLAB);
        Recipes.sieve(recipes, DefaultMaterials.SPRUCE_SIEVE.getItem(), Items.SPRUCE_PLANKS, Items.SPRUCE_SLAB);
        Recipes.sieve(recipes, DefaultMaterials.BIRCH_SIEVE.getItem(), Items.BIRCH_PLANKS, Items.BIRCH_SLAB);
        Recipes.sieve(recipes, DefaultMaterials.JUNGLE_SIEVE.getItem(), Items.JUNGLE_PLANKS, Items.JUNGLE_SLAB);
        Recipes.sieve(recipes, DefaultMaterials.ACACIA_SIEVE.getItem(), Items.ACACIA_PLANKS, Items.ACACIA_SLAB);
        Recipes.sieve(recipes, DefaultMaterials.DARK_OAK_SIEVE.getItem(), Items.DARK_OAK_PLANKS, Items.DARK_OAK_SLAB);
        Recipes.sieve(recipes, DefaultMaterials.MANGROVE_SIEVE.getItem(), Items.MANGROVE_PLANKS, Items.MANGROVE_SLAB);
        Recipes.sieve(recipes, DefaultMaterials.CHERRY_SIEVE.getItem(), Items.CHERRY_PLANKS, Items.CHERRY_SLAB);
        Recipes.sieve(recipes, DefaultMaterials.BAMBOO_SIEVE.getItem(), Items.BAMBOO_PLANKS, Items.BAMBOO_SLAB);
        Recipes.sieve(recipes, DefaultMaterials.CRIMSON_SIEVE.getItem(), Items.CRIMSON_PLANKS, Items.CRIMSON_SLAB);
        Recipes.sieve(recipes, DefaultMaterials.WARPED_SIEVE.getItem(), Items.WARPED_PLANKS, Items.WARPED_SLAB);
        Recipes.modSieve(recipes, "biomesoplenty", ModCompatData.FIR_PLANKS_ITEM, ModCompatData.FIR_SLAB, DefaultMaterials.FIR_SIEVE.getItem());
        Recipes.modSieve(recipes, "biomesoplenty", ModCompatData.REDWOOD_PLANKS_ITEM, ModCompatData.REDWOOD_SLAB, DefaultMaterials.REDWOOD_SIEVE.getItem());
        Recipes.modSieve(recipes, "biomesoplenty", ModCompatData.MAHOGANY_PLANKS_ITEM, ModCompatData.MAHOGANY_SLAB, DefaultMaterials.MAHOGANY_SIEVE.getItem());
        Recipes.modSieve(recipes, "biomesoplenty", ModCompatData.JACARANDA_PLANKS_ITEM, ModCompatData.JACARANDA_SLAB, DefaultMaterials.JACARANDA_SIEVE.getItem());
        Recipes.modSieve(recipes, "biomesoplenty", ModCompatData.PALM_PLANKS_ITEM, ModCompatData.PALM_SLAB, DefaultMaterials.PALM_SIEVE.getItem());
        Recipes.modSieve(recipes, "biomesoplenty", ModCompatData.WILLOW_PLANKS_ITEM, ModCompatData.WILLOW_SLAB, DefaultMaterials.WILLOW_SIEVE.getItem());
        Recipes.modSieve(recipes, "biomesoplenty", ModCompatData.DEAD_PLANKS_ITEM, ModCompatData.DEAD_SLAB, DefaultMaterials.DEAD_SIEVE.getItem());
        Recipes.modSieve(recipes, "biomesoplenty", ModCompatData.MAGIC_PLANKS_ITEM, ModCompatData.MAGIC_SLAB, DefaultMaterials.MAGIC_SIEVE.getItem());
        Recipes.modSieve(recipes, "biomesoplenty", ModCompatData.UMBRAN_PLANKS_ITEM, ModCompatData.UMBRAN_SLAB, DefaultMaterials.UMBRAN_SIEVE.getItem());
        Recipes.modSieve(recipes, "biomesoplenty", ModCompatData.HELLBARK_PLANKS_ITEM, ModCompatData.HELLBARK_SLAB, DefaultMaterials.HELLBARK_SIEVE.getItem());
        Recipes.modSieve(recipes, "ars_nouveau", ModCompatData.ARCHWOOD_PLANKS_ITEM, ModCompatData.ARCHWOOD_SLAB, DefaultMaterials.ARCHWOOD_SIEVE.getItem());
        Recipes.modSieve(recipes, "aether", ModCompatData.SKYROOT_PLANKS_ITEM, ModCompatData.SKYROOT_SLAB, DefaultMaterials.SKYROOT_SIEVE.getItem());
        Recipes.modSieve(recipes, "blue_skies", ModCompatData.BLUEBRIGHT_PLANKS_ITEM, ModCompatData.BLUEBRIGHT_SLAB, DefaultMaterials.BLUEBRIGHT_SIEVE.getItem());
        Recipes.modSieve(recipes, "blue_skies", ModCompatData.STARLIT_PLANKS_ITEM, ModCompatData.STARLIT_SLAB, DefaultMaterials.STARLIT_SIEVE.getItem());
        Recipes.modSieve(recipes, "blue_skies", ModCompatData.FROSTBRIGHT_PLANKS_ITEM, ModCompatData.FROSTBRIGHT_SLAB, DefaultMaterials.FROSTBRIGHT_SIEVE.getItem());
        Recipes.modSieve(recipes, "blue_skies", ModCompatData.COMET_PLANKS_ITEM, ModCompatData.COMET_SLAB, DefaultMaterials.COMET_SIEVE.getItem());
        Recipes.modSieve(recipes, "blue_skies", ModCompatData.LUNAR_PLANKS_ITEM, ModCompatData.LUNAR_SLAB, DefaultMaterials.LUNAR_SIEVE.getItem());
        Recipes.modSieve(recipes, "blue_skies", ModCompatData.DUSK_PLANKS_ITEM, ModCompatData.DUSK_SLAB, DefaultMaterials.DUSK_SIEVE.getItem());
        Recipes.modSieve(recipes, "blue_skies", ModCompatData.MAPLE_PLANKS_ITEM, ModCompatData.MAPLE_SLAB, DefaultMaterials.MAPLE_SIEVE.getItem());
        Recipes.modSieve(recipes, "blue_skies", ModCompatData.CRYSTALLIZED_PLANKS_ITEM, ModCompatData.CRYSTALLIZED_SLAB, DefaultMaterials.CRYSTALLIZED_SIEVE.getItem());
        recipes.grid3x3((ItemLike)EItems.STRING_MESH.get(), MKRecipeProvider.ingredient((TagKey)Tags.Items.STRING));
        Recipes.mesh(recipes, EItems.FLINT_MESH, MKRecipeProvider.ingredient((ItemLike)Items.FLINT));
        Recipes.mesh(recipes, EItems.IRON_MESH, MKRecipeProvider.ingredient((TagKey)Tags.Items.INGOTS_IRON));
        Recipes.mesh(recipes, EItems.GOLDEN_MESH, MKRecipeProvider.ingredient((TagKey)Tags.Items.INGOTS_GOLD));
        Recipes.mesh(recipes, EItems.DIAMOND_MESH, MKRecipeProvider.ingredient((TagKey)Tags.Items.GEMS_DIAMOND));
        Recipes.meshUpgrade(recipes, EItems.FLINT_MESH, EItems.STRING_MESH, MKRecipeProvider.ingredient((ItemLike)Items.FLINT));
        Recipes.meshUpgrade(recipes, EItems.IRON_MESH, EItems.FLINT_MESH, MKRecipeProvider.ingredient((TagKey)Tags.Items.INGOTS_IRON));
        Recipes.meshUpgrade(recipes, EItems.GOLDEN_MESH, EItems.IRON_MESH, MKRecipeProvider.ingredient((TagKey)Tags.Items.INGOTS_GOLD));
        Recipes.meshUpgrade(recipes, EItems.DIAMOND_MESH, EItems.GOLDEN_MESH, MKRecipeProvider.ingredient((TagKey)Tags.Items.GEMS_DIAMOND));
        recipes.netheriteUpgrade(RecipeCategory.MISC, MKRecipeProvider.ingredient(EItems.DIAMOND_MESH), (ItemLike)EItems.NETHERITE_MESH.get());
        Recipes.wateringCan(recipes, EItems.WOODEN_WATERING_CAN, MKRecipeProvider.ingredient((TagKey)ItemTags.PLANKS));
        Recipes.wateringCan(recipes, EItems.STONE_WATERING_CAN, MKRecipeProvider.ingredient((TagKey)ItemTags.STONE_TOOL_MATERIALS));
        Recipes.wateringCan(recipes, EItems.IRON_WATERING_CAN, MKRecipeProvider.ingredient((TagKey)Tags.Items.INGOTS_IRON));
        Recipes.wateringCan(recipes, EItems.GOLDEN_WATERING_CAN, MKRecipeProvider.ingredient((TagKey)Tags.Items.INGOTS_GOLD));
        Recipes.wateringCan(recipes, EItems.DIAMOND_WATERING_CAN, MKRecipeProvider.ingredient((TagKey)Tags.Items.GEMS_DIAMOND));
        recipes.netheriteUpgrade(RecipeCategory.TOOLS, MKRecipeProvider.ingredient(EItems.DIAMOND_WATERING_CAN), (ItemLike)EItems.NETHERITE_WATERING_CAN.get());
        recipes.shapelessCrafting(RecipeCategory.MISC, new ItemStack((ItemLike)EItems.PORCELAIN_CLAY_BALL.get()), new Object[]{MKRecipeProvider.ingredient((ItemLike)Items.CLAY_BALL), MKRecipeProvider.ingredient((ItemLike)Items.BONE_MEAL)});
        recipes.shapedCrafting(RecipeCategory.MISC, (ItemLike)EItems.UNFIRED_PORCELAIN_BUCKET.get(), recipe -> {
            recipe.define('#', EItems.PORCELAIN_CLAY_BALL);
            recipe.pattern("# #");
            recipe.pattern(" # ");
        });
        recipes.shapedCrafting(RecipeCategory.MISC, (ItemLike)EItems.SCULK_CORE.get(), recipe -> {
            recipe.define('#', (ItemLike)Items.ECHO_SHARD);
            recipe.define('O', (ItemLike)Items.ENDER_PEARL);
            recipe.pattern(" # ");
            recipe.pattern("#O#");
            recipe.pattern(" # ");
        });
        recipes.shapedCrafting(RecipeCategory.FOOD, (ItemLike)EItems.END_CAKE.get(), recipe -> {
            recipe.define('P', (ItemLike)Items.ENDER_EYE);
            recipe.define('S', (ItemLike)Items.SUGAR);
            recipe.define('E', Tags.Items.EGGS);
            recipe.define('C', EItems.CRUSHED_END_STONE);
            recipe.pattern("PPP");
            recipe.pattern("SES");
            recipe.pattern("CCC");
        });
        recipes.shapedCrafting(RecipeCategory.BUILDING_BLOCKS, (ItemLike)Items.SPONGE, recipe -> {
            recipe.define('S', (ItemLike)Blocks.SLIME_BLOCK);
            recipe.define('W', ItemTags.WOOL);
            recipe.define('C', EItems.WOOD_CHIPPINGS);
            recipe.pattern("WCW");
            recipe.pattern("CSC");
            recipe.pattern("WCW");
            MKRecipeProvider.unlockedByHaving((Object)recipe, (ItemLike)((ItemLike)EItems.WOOD_CHIPPINGS.get()));
        });
        recipes.shapedCrafting(RecipeCategory.MISC, (ItemLike)EItems.MECHANICAL_SIEVE.get(), recipe -> {
            recipe.define('#', (ItemLike)Items.IRON_BLOCK);
            recipe.define('G', (ItemLike)Items.GLASS);
            recipe.define('H', (ItemLike)Items.HOPPER);
            recipe.define('I', (ItemLike)Items.IRON_BARS);
            recipe.pattern("#G#");
            recipe.pattern("IHI");
            recipe.pattern("I I");
            MKRecipeProvider.unlockedByHaving((Object)recipe, (ItemLike)Items.HOPPER);
        });
        recipes.shapedCrafting(RecipeCategory.MISC, (ItemLike)EItems.MECHANICAL_HAMMER.get(), recipe -> {
            recipe.define('#', (ItemLike)Items.IRON_BLOCK);
            recipe.define('H', (ItemLike)Items.HOPPER);
            recipe.define('T', EItemTags.HAMMERS);
            recipe.define('I', (ItemLike)Items.IRON_INGOT);
            recipe.pattern("III");
            recipe.pattern("ITI");
            recipe.pattern("#H#");
            MKRecipeProvider.unlockedByHaving((Object)recipe, (ItemLike)Items.HOPPER);
        });
    }

    private static void modUShaped(MKRecipeProvider recipes, String modid, RegistryObject<? extends Item> sides, RegistryObject<? extends Item> middle, Item result) {
        recipes.conditional(MKRecipeProvider.path((ItemLike)result), List.of(Recipes.modInstalled(modid)), writer1 -> Recipes.uShaped(recipes, result, MKRecipeProvider.ingredient((Supplier)sides), MKRecipeProvider.ingredient((Supplier)middle)));
    }

    private static void modSieve(MKRecipeProvider recipes, String modid, RegistryObject<? extends Item> planks, RegistryObject<? extends Item> slab, Item result) {
        recipes.conditional(MKRecipeProvider.path((ItemLike)result), List.of(Recipes.modInstalled(modid)), writer1 -> Recipes.sieve(recipes, result, (Item)planks.get(), (Item)slab.get()));
    }

    private static void grid2x2TagResult(Consumer<FinishedRecipe> writer, MKRecipeProvider recipes, TagKey<Item> resultTag, Ingredient ingredient) {
        MutableObject wrappedRecipe = new MutableObject();
        recipes.pushWriter(arg_0 -> ((MutableObject)wrappedRecipe).setValue(arg_0), newWriter -> recipes.shapedCrafting(resultTag.location().getPath() + "_tag", RecipeCategory.MISC, (ItemLike)Items.AIR, recipe -> {
            recipe.define('#', ingredient);
            recipe.pattern("##");
            recipe.pattern("##");
        }));
        writer.accept(new TagResultRecipe.Finished(resultTag, (FinishedRecipe)wrappedRecipe.getValue()));
    }

    private static void shapedCrook(MKRecipeProvider recipes, RegistryObject<? extends Item> crook, Ingredient stick) {
        recipes.shapedCrafting(RecipeCategory.TOOLS, (ItemLike)crook.get(), recipe -> {
            recipe.define('x', stick);
            recipe.pattern("xx");
            recipe.pattern(" x");
            recipe.pattern(" x");
        });
    }

    private static void shapedHammer(MKRecipeProvider recipes, RegistryObject<? extends Item> hammer, Ingredient material) {
        recipes.shapedCrafting(RecipeCategory.TOOLS, (ItemLike)hammer.get(), recipe -> {
            recipe.define('m', material);
            recipe.define('s', Tags.Items.RODS_WOODEN);
            recipe.pattern(" m ");
            recipe.pattern(" sm");
            recipe.pattern("s  ");
        });
    }

    private static void uShaped(MKRecipeProvider recipes, Item result, Ingredient sides, Ingredient middle) {
        recipes.shapedCrafting(RecipeCategory.MISC, (ItemLike)result, recipe -> {
            recipe.define('s', sides);
            recipe.define('m', middle);
            recipe.pattern("s s");
            recipe.pattern("s s");
            recipe.pattern("sms");
        });
    }

    private static void sieve(MKRecipeProvider recipes, Item result, Item planks, Item slab) {
        recipes.shapedCrafting(RecipeCategory.MISC, (ItemLike)result, recipe -> {
            recipe.define('O', (ItemLike)planks);
            recipe.define('_', (ItemLike)slab);
            recipe.define('I', Tags.Items.RODS_WOODEN);
            recipe.pattern("O O");
            recipe.pattern("O_O");
            recipe.pattern("I I");
        });
    }

    private static void compressedSieve(MKRecipeProvider recipes, ItemLike result, Ingredient log) {
        recipes.shapedCrafting(RecipeCategory.MISC, (ItemLike)result.asItem(), recipe -> {
            recipe.define('O', log);
            recipe.define('I', Tags.Items.RODS_WOODEN);
            recipe.define('_', Tags.Items.INGOTS_IRON);
            recipe.pattern("O O");
            recipe.pattern("O_O");
            recipe.pattern("I I");
        });
    }

    private static void modCompressedSieve(MKRecipeProvider recipes, String modid, ItemLike result, Ingredient log) {
        recipes.conditional(MKRecipeProvider.path((ItemLike)result), List.of(Recipes.modInstalled(modid)), writer1 -> Recipes.compressedSieve(recipes, result, log));
    }

    private static void mesh(MKRecipeProvider recipes, Supplier<? extends Item> result, Ingredient ingredient) {
        recipes.shapedCrafting(RecipeCategory.MISC, (ItemLike)result.get(), recipe -> {
            recipe.define('#', ingredient);
            recipe.define('S', MKRecipeProvider.ingredient((TagKey)Tags.Items.STRING));
            recipe.pattern("S#S");
            recipe.pattern("#S#");
            recipe.pattern("S#S");
        });
    }

    private static void meshUpgrade(MKRecipeProvider recipes, RegistryObject<? extends Item> newMesh, RegistryObject<? extends Item> previousMesh, Ingredient ingredient) {
        recipes.shapedCrafting(newMesh.getId().getPath() + "_from_" + previousMesh.getId().getPath(), RecipeCategory.MISC, (ItemLike)newMesh.get(), recipe -> {
            recipe.define('#', ingredient);
            recipe.define('M', (ItemLike)previousMesh.get());
            recipe.pattern(" # ");
            recipe.pattern("#M#");
            recipe.pattern(" # ");
        });
    }

    private static void wateringCan(MKRecipeProvider recipes, Supplier<? extends Item> result, Ingredient shell) {
        recipes.shapedCrafting(RecipeCategory.TOOLS, (ItemLike)result.get(), recipe -> {
            recipe.define('#', shell);
            recipe.define('B', (ItemLike)Items.BOWL);
            recipe.pattern("#  ");
            recipe.pattern("#B#");
            recipe.pattern(" # ");
        });
    }

    private static void smeltingRecipes(MKRecipeProvider recipes) {
        recipes.smelting(MKRecipeProvider.ingredient(EItems.UNFIRED_PORCELAIN_CRUCIBLE), (ItemLike)DefaultMaterials.PORCELAIN_CRUCIBLE.getItem(), 0.1f);
        recipes.smelting(MKRecipeProvider.ingredient(EItems.UNFIRED_PORCELAIN_BUCKET), (ItemLike)EItems.PORCELAIN_BUCKET.get(), 0.1f);
        recipes.foodCooking((ItemLike)EItems.SILK_WORM.get(), (ItemLike)EItems.COOKED_SILK_WORM.get(), 0.1f);
    }

    private static void crucibleRecipes(Consumer<FinishedRecipe> writer) {
        Recipes.lavaCrucible(writer, "cobblestone", MKRecipeProvider.ingredient((TagKey)Tags.Items.COBBLESTONE), 250);
        Recipes.lavaCrucible(writer, "stone", MKRecipeProvider.ingredient((TagKey)Tags.Items.STONE), 250);
        Recipes.lavaCrucible(writer, "gravel", MKRecipeProvider.ingredient((TagKey)Tags.Items.GRAVEL), 250);
        Recipes.lavaCrucible(writer, "netherrack", MKRecipeProvider.ingredient((TagKey)Tags.Items.NETHERRACK), 500);
        Recipes.waterCrucible(writer, "saplings", MKRecipeProvider.ingredient((TagKey)ItemTags.SAPLINGS), 100);
        Recipes.waterCrucible(writer, "leaves", MKRecipeProvider.ingredient((TagKey)ItemTags.LEAVES), 250);
        Recipes.waterCrucible(writer, "small_flowers", MKRecipeProvider.ingredient((TagKey)ItemTags.SMALL_FLOWERS), 100);
        Recipes.waterCrucible(writer, "tall_flowers", MKRecipeProvider.ingredient((TagKey)ItemTags.TALL_FLOWERS), 200);
        Recipes.waterCrucible(writer, "mushrooms", MKRecipeProvider.ingredient((TagKey)Tags.Items.MUSHROOMS), 100);
        Recipes.waterCrucible(writer, "lily_pad", MKRecipeProvider.ingredient((ItemLike)Items.LILY_PAD), 150);
        Recipes.waterCrucible(writer, "sugar_cane", MKRecipeProvider.ingredient((ItemLike)Items.SUGAR_CANE), 100);
        Recipes.waterCrucible(writer, "vine", MKRecipeProvider.ingredient((ItemLike)Items.VINE), 100);
        Recipes.waterCrucible(writer, "seeds_and_spores", SPORES_AND_SEEDS, 50);
        Recipes.waterCrucible(writer, "seeds", MKRecipeProvider.ingredient((TagKey)Tags.Items.SEEDS), 50);
        Recipes.waterCrucible(writer, "grass", MKRecipeProvider.ingredient((ItemLike[])new ItemLike[]{Items.GRASS, Items.TALL_GRASS}), 100);
        Recipes.waterCrucible(writer, "grass_block", MKRecipeProvider.ingredient((ItemLike)Items.GRASS_BLOCK), 150);
        Recipes.waterCrucible(writer, "sweet_berries", MKRecipeProvider.ingredient((ItemLike[])new ItemLike[]{Items.SWEET_BERRIES, Items.GLOW_BERRIES}), 50);
        Recipes.waterCrucible(writer, "melon_slice", MKRecipeProvider.ingredient((ItemLike)Items.MELON_SLICE), 50);
        Recipes.waterCrucible(writer, "potato", MKRecipeProvider.ingredient((ItemLike)Items.POTATO), 100);
        Recipes.waterCrucible(writer, "carrot", MKRecipeProvider.ingredient((ItemLike)Items.CARROT), 100);
        Recipes.waterCrucible(writer, "beetroot", MKRecipeProvider.ingredient((ItemLike)Items.BEETROOT), 100);
        Recipes.waterCrucible(writer, "apple", MKRecipeProvider.ingredient((ItemLike)Items.APPLE), 100);
        Recipes.waterCrucible(writer, "cactus", MKRecipeProvider.ingredient((ItemLike)Items.CACTUS), 250);
        Recipes.waterCrucible(writer, "pumpkin", MKRecipeProvider.ingredient((ItemLike)Items.PUMPKIN), 250);
        Recipes.waterCrucible(writer, "melon", MKRecipeProvider.ingredient((ItemLike)Items.MELON), 250);
        Recipes.waterCrucible(writer, "seagrass", MKRecipeProvider.ingredient((ItemLike)Items.SEAGRASS), 100);
        Recipes.waterCrucible(writer, "sea_pickle", MKRecipeProvider.ingredient((ItemLike)Items.SEA_PICKLE), 200);
        Recipes.waterCrucible(writer, "moss", MKRecipeProvider.ingredient((ItemLike)Items.MOSS_BLOCK), 150);
        Recipes.waterCrucible(writer, "moss_carpet", MKRecipeProvider.ingredient((ItemLike)Items.MOSS_CARPET), 100);
        Recipes.waterCrucible(writer, "spore_blossom", MKRecipeProvider.ingredient((ItemLike)Items.SPORE_BLOSSOM), 150);
    }

    private static void lavaCrucible(Consumer<FinishedRecipe> writer, String id, Ingredient ingredient, int volume) {
        writer.accept(new FinishedCrucibleRecipe(Recipes.modLoc("lava_crucible/" + id), (RecipeSerializer)ERecipeSerializers.LAVA_CRUCIBLE.get(), ingredient, (Fluid)Fluids.LAVA, volume));
    }

    private static void waterCrucible(Consumer<FinishedRecipe> writer, String id, Ingredient ingredient, int volume) {
        writer.accept(new FinishedCrucibleRecipe(Recipes.modLoc("water_crucible/" + id), (RecipeSerializer)ERecipeSerializers.WATER_CRUCIBLE.get(), ingredient, (Fluid)Fluids.WATER, volume));
    }

    private static void hammerRecipes(Consumer<FinishedRecipe> writer) {
        Recipes.hammerRecipe(writer, "gravel", MKRecipeProvider.ingredient((ItemLike[])new ItemLike[]{Items.COBBLESTONE, Items.DIORITE, Items.GRANITE, Items.ANDESITE}), (ItemLike)Blocks.GRAVEL);
        Recipes.hammerRecipe(writer, "sand", MKRecipeProvider.ingredient((ItemLike)Items.GRAVEL), (ItemLike)Blocks.SAND);
        Recipes.hammerRecipe(writer, "dust", MKRecipeProvider.ingredient((ItemLike[])new ItemLike[]{Items.SAND, Items.RED_SAND}), (ItemLike)EBlocks.DUST.get());
        Recipes.hammerRecipe(writer, "crushed_deepslate", MKRecipeProvider.ingredient((ItemLike[])new ItemLike[]{Blocks.DEEPSLATE, Blocks.COBBLED_DEEPSLATE}), (ItemLike)EBlocks.CRUSHED_DEEPSLATE.get());
        Recipes.hammerRecipe(writer, "crushed_netherrack", MKRecipeProvider.ingredient((ItemLike)Blocks.NETHERRACK), (ItemLike)EBlocks.CRUSHED_NETHERRACK.get());
        Recipes.hammerRecipe(writer, "crushed_blackstone", MKRecipeProvider.ingredient((ItemLike)Blocks.BLACKSTONE), (ItemLike)EBlocks.CRUSHED_BLACKSTONE.get());
        Recipes.hammerRecipe(writer, "crushed_end_stone", MKRecipeProvider.ingredient((ItemLike)Blocks.END_STONE), (ItemLike)EBlocks.CRUSHED_END_STONE.get());
        Recipes.hammerRecipe(writer, "red_sand", MKRecipeProvider.ingredient(EBlocks.CRUSHED_NETHERRACK), (ItemLike)Blocks.RED_SAND);
        Recipes.hammerRecipe(writer, "crushing_sandstone", MKRecipeProvider.ingredient((ItemLike[])new ItemLike[]{Items.SANDSTONE, Items.CUT_SANDSTONE, Items.CHISELED_SANDSTONE, Items.SMOOTH_SANDSTONE}), (ItemLike)Items.SAND);
        Recipes.hammerRecipe(writer, "crushing_red_sandstone", MKRecipeProvider.ingredient((ItemLike[])new ItemLike[]{Items.RED_SANDSTONE, Items.CUT_RED_SANDSTONE, Items.CHISELED_RED_SANDSTONE, Items.SMOOTH_RED_SANDSTONE}), (ItemLike)Items.RED_SAND);
        Recipes.hammerRecipe(writer, "crushing_stone_bricks", MKRecipeProvider.ingredient((ItemLike)Items.STONE_BRICKS), (ItemLike)Items.CRACKED_STONE_BRICKS);
        Recipes.hammerRecipe(writer, "stone_pebbles", MKRecipeProvider.ingredient((ItemLike[])new ItemLike[]{Items.STONE, Items.STONE_BRICKS, Items.CHISELED_STONE_BRICKS, Items.CRACKED_STONE_BRICKS}), (ItemLike)EItems.STONE_PEBBLE.get(), (NumberProvider)new UniformGenerator((NumberProvider)ConstantValue.exactly((float)1.0f), (NumberProvider)ConstantValue.exactly((float)6.0f)));
        Recipes.hammerRecipe(writer, "basalt", MKRecipeProvider.ingredient((ItemLike[])new ItemLike[]{Items.POLISHED_BASALT, Items.SMOOTH_BASALT}), (ItemLike)Items.BASALT);
        Recipes.hammerRecipe(writer, "wood_chippings", MKRecipeProvider.ingredient((TagKey)ItemTags.LOGS), (ItemLike)EItems.WOOD_CHIPPINGS.get(), (NumberProvider)new UniformGenerator((NumberProvider)ConstantValue.exactly((float)3.0f), (NumberProvider)ConstantValue.exactly((float)8.0f)));
        Recipes.hammerRecipe(writer, "tube_coral", MKRecipeProvider.ingredient((ItemLike)Items.TUBE_CORAL_BLOCK), (ItemLike)Items.TUBE_CORAL);
        Recipes.hammerRecipe(writer, "brain_coral", MKRecipeProvider.ingredient((ItemLike)Items.BRAIN_CORAL_BLOCK), (ItemLike)Items.BRAIN_CORAL);
        Recipes.hammerRecipe(writer, "bubble_coral", MKRecipeProvider.ingredient((ItemLike)Items.BUBBLE_CORAL_BLOCK), (ItemLike)Items.BUBBLE_CORAL);
        Recipes.hammerRecipe(writer, "fire_coral", MKRecipeProvider.ingredient((ItemLike)Items.FIRE_CORAL_BLOCK), (ItemLike)Items.FIRE_CORAL);
        Recipes.hammerRecipe(writer, "horn_coral", MKRecipeProvider.ingredient((ItemLike)Items.HORN_CORAL_BLOCK), (ItemLike)Items.HORN_CORAL);
        Recipes.hammerRecipe(writer, "tube_coral_fan", MKRecipeProvider.ingredient((ItemLike)Items.TUBE_CORAL), (ItemLike)Items.TUBE_CORAL_FAN);
        Recipes.hammerRecipe(writer, "brain_coral_fan", MKRecipeProvider.ingredient((ItemLike)Items.BRAIN_CORAL), (ItemLike)Items.BRAIN_CORAL_FAN);
        Recipes.hammerRecipe(writer, "bubble_coral_fan", MKRecipeProvider.ingredient((ItemLike)Items.BUBBLE_CORAL), (ItemLike)Items.BUBBLE_CORAL_FAN);
        Recipes.hammerRecipe(writer, "fire_coral_fan", MKRecipeProvider.ingredient((ItemLike)Items.FIRE_CORAL), (ItemLike)Items.FIRE_CORAL_FAN);
        Recipes.hammerRecipe(writer, "horn_coral_fan", MKRecipeProvider.ingredient((ItemLike)Items.HORN_CORAL), (ItemLike)Items.HORN_CORAL_FAN);
        Recipes.hammerRecipe(writer, "prismarine", MKRecipeProvider.ingredient((ItemLike[])new ItemLike[]{Items.PRISMARINE, Items.PRISMARINE_BRICKS, Items.DARK_PRISMARINE}), (ItemLike)Items.PRISMARINE_SHARD, (NumberProvider)UniformGenerator.between((float)1.0f, (float)4.0f));
        Recipes.hammerRecipe(writer, "pointed_dripstone", MKRecipeProvider.ingredient((ItemLike)Items.DRIPSTONE_BLOCK), (ItemLike)Items.POINTED_DRIPSTONE, (NumberProvider)UniformGenerator.between((float)2.0f, (float)4.0f));
    }

    private static void compressedHammerRecipes(Consumer<FinishedRecipe> writer) {
        Recipes.compressedHammerRecipe(writer, (ItemLike)Items.GRAVEL, MKRecipeProvider.ingredient((TagKey[])new TagKey[]{ECompressedBlocks.COMPRESSED_COBBLESTONE.getTag(), ECompressedBlocks.COMPRESSED_DIORITE.getTag(), ECompressedBlocks.COMPRESSED_GRANITE.getTag(), ECompressedBlocks.COMPRESSED_ANDESITE.getTag()}));
        Recipes.compressedHammerRecipe(writer, (ItemLike)Items.SAND, MKRecipeProvider.ingredient(ECompressedBlocks.COMPRESSED_GRAVEL.getTag()));
        Recipes.compressedHammerRecipe(writer, (ItemLike)EItems.DUST.get(), MKRecipeProvider.ingredient(EItemTags.COMPRESSED_SANDS));
        Recipes.compressedHammerRecipe(writer, (ItemLike)EItems.CRUSHED_DEEPSLATE.get(), MKRecipeProvider.ingredient((TagKey[])new TagKey[]{ECompressedBlocks.COMPRESSED_DEEPSLATE.getTag(), ECompressedBlocks.COMPRESSED_COBBLED_DEEPSLATE.getTag()}));
        Recipes.compressedHammerRecipe(writer, (ItemLike)EItems.CRUSHED_NETHERRACK.get(), MKRecipeProvider.ingredient(ECompressedBlocks.COMPRESSED_NETHERRACK.getTag()));
        Recipes.compressedHammerRecipe(writer, (ItemLike)EItems.CRUSHED_BLACKSTONE.get(), MKRecipeProvider.ingredient(ECompressedBlocks.COMPRESSED_BLACKSTONE.getTag()));
        Recipes.compressedHammerRecipe(writer, (ItemLike)EItems.CRUSHED_END_STONE.get(), MKRecipeProvider.ingredient(ECompressedBlocks.COMPRESSED_END_STONE.getTag()));
        Recipes.compressedHammerRecipe(writer, (ItemLike)Items.RED_SAND, MKRecipeProvider.ingredient(ECompressedBlocks.COMPRESSED_CRUSHED_NETHERRACK.getTag()));
    }

    private static void compressedHammerRecipe(Consumer<FinishedRecipe> writer, ItemLike result, Ingredient block) {
        writer.accept(new FinishedCompressedHammerRecipe(Recipes.modLoc("compressed_hammer/" + MKRecipeProvider.path((ItemLike)result)), block, result.asItem(), (NumberProvider)ConstantValue.exactly((float)9.0f)));
    }

    private static void hammerRecipe(Consumer<FinishedRecipe> writer, String name, Ingredient block, ItemLike result) {
        Recipes.hammerRecipe(writer, name, block, result, (NumberProvider)ConstantValue.exactly((float)1.0f));
    }

    private static void hammerRecipe(Consumer<FinishedRecipe> writer, String name, Ingredient block, ItemLike result, NumberProvider resultAmount) {
        writer.accept(new FinishedHammerRecipe(Recipes.modLoc("hammer/" + name), block, result.asItem(), resultAmount));
    }

    private static void crookRecipes(Consumer<FinishedRecipe> writer) {
        Recipes.crookRecipe(writer, "silkworm", BlockPredicate.blockTag((TagKey<Block>)BlockTags.LEAVES), (ItemLike)EItems.SILK_WORM.get(), 0.01f);
        BlockPredicate fullyInfestedLeaves = BlockPredicate.blockState((Block)EBlocks.INFESTED_LEAVES.get(), StatePropertiesPredicate.Builder.properties().hasProperty((Property)InfestedLeavesBlock.FULLY_INFESTED, true).build());
        Recipes.crookRecipe(writer, "silkworm_bonus", fullyInfestedLeaves, (ItemLike)EItems.SILK_WORM.get(), 0.01f);
        Recipes.crookRecipe(writer, "string_roll_1", fullyInfestedLeaves, (ItemLike)Items.STRING, 0.4f);
        Recipes.crookRecipe(writer, "string_roll_2", fullyInfestedLeaves, (ItemLike)Items.STRING, 0.1f);
    }

    private static void crookRecipe(Consumer<FinishedRecipe> writer, String name, BlockPredicate blockPredicate, ItemLike result, float chance) {
        writer.accept(new FinishedCrookRecipe(Recipes.modLoc("crook/" + name), blockPredicate, result.asItem(), chance));
    }

    private static void crucibleHeatSources(Consumer<FinishedRecipe> writer) {
        Recipes.crucibleHeatSource(writer, Blocks.TORCH, 1);
        Recipes.crucibleHeatSource(writer, Blocks.WALL_TORCH, 1);
        Recipes.crucibleHeatSource(writer, Blocks.LANTERN, 1);
        Recipes.crucibleHeatSource(writer, Blocks.SOUL_TORCH, 2);
        Recipes.crucibleHeatSource(writer, Blocks.SOUL_WALL_TORCH, 2);
        Recipes.crucibleHeatSource(writer, Blocks.SOUL_LANTERN, 2);
        Recipes.crucibleHeatSource(writer, Blocks.LAVA, 3);
        Recipes.crucibleHeatSource(writer, Blocks.FIRE, 5);
        Recipes.crucibleHeatSource(writer, Blocks.SOUL_FIRE, 5);
        Recipes.crucibleHeatSource(writer, "lit_campfire", BlockPredicate.blockState(Blocks.CAMPFIRE, StatePropertiesPredicate.Builder.properties().hasProperty((Property)CampfireBlock.LIT, true).build()), 2);
        Recipes.crucibleHeatSource(writer, "lit_soul_campfire", BlockPredicate.blockState(Blocks.SOUL_CAMPFIRE, StatePropertiesPredicate.Builder.properties().hasProperty((Property)CampfireBlock.LIT, true).build()), 2);
    }

    private static void crucibleHeatSource(Consumer<FinishedRecipe> writer, Block block, int heatValue) {
        Recipes.crucibleHeatSource(writer, BuiltInRegistries.BLOCK.getKey((Object)block).getPath(), BlockPredicate.singleBlock(block), heatValue);
    }

    private static void crucibleHeatSource(Consumer<FinishedRecipe> writer, String name, BlockPredicate blockPredicate, int heatValue) {
        writer.accept(new FinishedCrucibleHeatRecipe(Recipes.modLoc("crucible_heat_source/" + name), blockPredicate, heatValue));
    }

    private static void barrelCompostRecipes(Consumer<FinishedRecipe> writer) {
        Recipes.barrelCompost(writer, "saplings", MKRecipeProvider.ingredient((TagKey)ItemTags.SAPLINGS), 125);
        Recipes.barrelCompost(writer, "leaves", MKRecipeProvider.ingredient((TagKey)ItemTags.LEAVES), 125);
        Recipes.barrelCompost(writer, "small_flowers", MKRecipeProvider.ingredient((TagKey)ItemTags.SMALL_FLOWERS), 100);
        Recipes.barrelCompost(writer, "tall_flowers", MKRecipeProvider.ingredient((TagKey)ItemTags.TALL_FLOWERS), 150);
        Recipes.barrelCompost(writer, "mushrooms", MKRecipeProvider.ingredient((TagKey)Tags.Items.MUSHROOMS), 100);
        Recipes.barrelCompost(writer, "lily_pad", MKRecipeProvider.ingredient((ItemLike)Items.LILY_PAD), 100);
        Recipes.barrelCompost(writer, "sugar_cane", MKRecipeProvider.ingredient((ItemLike)Items.SUGAR_CANE), 80);
        Recipes.barrelCompost(writer, "vine", MKRecipeProvider.ingredient((ItemLike)Items.VINE), 100);
        Recipes.barrelCompost(writer, "grass", MKRecipeProvider.ingredient((ItemLike[])new ItemLike[]{Items.GRASS, Items.FERN}), 100);
        Recipes.barrelCompost(writer, "tall_grass", MKRecipeProvider.ingredient((ItemLike[])new ItemLike[]{Items.TALL_GRASS, Items.LARGE_FERN}), 150);
        Recipes.barrelCompost(writer, "seagrass", MKRecipeProvider.ingredient((ItemLike)Items.SEAGRASS), 80);
        Recipes.barrelCompost(writer, "nether_wart", MKRecipeProvider.ingredient((ItemLike)Items.NETHER_WART), 100);
        Recipes.barrelCompost(writer, "seeds", MKRecipeProvider.ingredient((TagKey)Tags.Items.SEEDS), 80);
        Recipes.barrelCompost(writer, "wheat", MKRecipeProvider.ingredient((TagKey)Tags.Items.CROPS_WHEAT), 80);
        Recipes.barrelCompost(writer, "berries", MKRecipeProvider.ingredient((ItemLike[])new ItemLike[]{Items.SWEET_BERRIES, Items.GLOW_BERRIES}), 80);
        Recipes.barrelCompost(writer, "melon", MKRecipeProvider.ingredient((ItemLike)Items.MELON), 200);
        Recipes.barrelCompost(writer, "cake", MKRecipeProvider.ingredient((ItemLike)Items.CAKE), 500);
        Recipes.barrelCompost(writer, "pumpkin", MKRecipeProvider.ingredient((ItemLike)Items.PUMPKIN), 500);
        Recipes.barrelCompost(writer, "carrots", MKRecipeProvider.ingredient((ItemLike)Items.CARROT), 100);
        Recipes.barrelCompost(writer, "potatoes", MKRecipeProvider.ingredient((ItemLike[])new ItemLike[]{Items.POTATO, Items.BAKED_POTATO, Items.POISONOUS_POTATO}), 80);
        Recipes.barrelCompost(writer, "beetroot", MKRecipeProvider.ingredient((ItemLike)Items.BEETROOT), 80);
        Recipes.barrelCompost(writer, "moss_block", MKRecipeProvider.ingredient((ItemLike)Items.MOSS_BLOCK), 150);
        Recipes.barrelCompost(writer, "moss_carpet", MKRecipeProvider.ingredient((ItemLike)Items.MOSS_CARPET), 100);
        Recipes.barrelCompost(writer, "spores_and_seeds", SPORES_AND_SEEDS, 80);
        Recipes.barrelCompost(writer, "bamboo", MKRecipeProvider.ingredient((ItemLike)Items.BAMBOO), 100);
        Recipes.barrelCompost(writer, "cactus", MKRecipeProvider.ingredient((ItemLike)Items.CACTUS), 125);
        Recipes.barrelCompost(writer, "dead_bush", MKRecipeProvider.ingredient((ItemLike)Items.DEAD_BUSH), 80);
        Recipes.barrelCompost(writer, "chorus_flower", MKRecipeProvider.ingredient((ItemLike)Items.CHORUS_FLOWER), 150);
        Recipes.barrelCompost(writer, "chorus_fruit", MKRecipeProvider.ingredient((ItemLike)Items.CHORUS_FRUIT), 80);
        Recipes.barrelCompost(writer, "chorus_plant", MKRecipeProvider.ingredient((ItemLike)Items.CHORUS_PLANT), 150);
        Recipes.barrelCompost(writer, "kelp", MKRecipeProvider.ingredient((ItemLike[])new ItemLike[]{Items.KELP, Items.DRIED_KELP}), 80);
        Recipes.barrelCompost(writer, "sea_pickle", MKRecipeProvider.ingredient((ItemLike)Items.SEA_PICKLE), 80);
        Recipes.barrelCompost(writer, "spore_blossom", MKRecipeProvider.ingredient((ItemLike)Items.SPORE_BLOSSOM), 125);
        Recipes.barrelCompost(writer, "weeping_vines", MKRecipeProvider.ingredient((ItemLike)Items.WEEPING_VINES), 100);
        Recipes.barrelCompost(writer, "twisting_vines", MKRecipeProvider.ingredient((ItemLike)Items.TWISTING_VINES), 100);
        Recipes.barrelCompost(writer, "wood_chippings", MKRecipeProvider.ingredient(EItems.WOOD_CHIPPINGS), 125);
        Recipes.barrelCompost(writer, "rotten_flesh", MKRecipeProvider.ingredient((ItemLike)Items.ROTTEN_FLESH), 100);
        Recipes.barrelCompost(writer, "spider_eye", MKRecipeProvider.ingredient((ItemLike)Items.SPIDER_EYE), 80);
        Recipes.barrelCompost(writer, "fermented_spider_eye", MKRecipeProvider.ingredient((ItemLike)Items.FERMENTED_SPIDER_EYE), 100);
        Recipes.barrelCompost(writer, "string", MKRecipeProvider.ingredient((ItemLike)Items.STRING), 40);
        Recipes.barrelCompost(writer, "rabbit_foot", MKRecipeProvider.ingredient((ItemLike)Items.RABBIT_FOOT), 100);
        Recipes.barrelCompost(writer, "pork", MKRecipeProvider.ingredient((ItemLike[])new ItemLike[]{Items.PORKCHOP, Items.COOKED_PORKCHOP}), 150);
        Recipes.barrelCompost(writer, "beef", MKRecipeProvider.ingredient((ItemLike[])new ItemLike[]{Items.BEEF, Items.COOKED_BEEF}), 150);
        Recipes.barrelCompost(writer, "chicken", MKRecipeProvider.ingredient((ItemLike[])new ItemLike[]{Items.CHICKEN, Items.COOKED_CHICKEN}), 125);
        Recipes.barrelCompost(writer, "mutton", MKRecipeProvider.ingredient((ItemLike[])new ItemLike[]{Items.MUTTON, Items.COOKED_MUTTON}), 125);
        Recipes.barrelCompost(writer, "salmon", MKRecipeProvider.ingredient((ItemLike[])new ItemLike[]{Items.SALMON, Items.COOKED_SALMON}), 125);
        Recipes.barrelCompost(writer, "rabbit", MKRecipeProvider.ingredient((ItemLike[])new ItemLike[]{Items.RABBIT, Items.COOKED_RABBIT}), 100);
        Recipes.barrelCompost(writer, "cod", MKRecipeProvider.ingredient((ItemLike[])new ItemLike[]{Items.COD, Items.COOKED_COD}), 100);
        Recipes.barrelCompost(writer, "tropical_fish", MKRecipeProvider.ingredient((ItemLike)Items.TROPICAL_FISH), 80);
        Recipes.barrelCompost(writer, "pufferfish", MKRecipeProvider.ingredient((ItemLike)Items.PUFFERFISH), 80);
        Recipes.barrelCompost(writer, "egg", MKRecipeProvider.ingredient((ItemLike)Items.EGG), 100);
        Recipes.barrelCompost(writer, "melon_slice", MKRecipeProvider.ingredient((ItemLike)Items.MELON_SLICE), 40);
        Recipes.barrelCompost(writer, "silk_worms", MKRecipeProvider.ingredient((ItemLike[])new ItemLike[]{(ItemLike)EItems.SILK_WORM.get(), (ItemLike)EItems.COOKED_SILK_WORM.get()}), 40);
        Recipes.barrelCompost(writer, "apple", MKRecipeProvider.ingredient((ItemLike)Items.APPLE), 100);
        Recipes.barrelCompost(writer, "cookie", MKRecipeProvider.ingredient((ItemLike)Items.COOKIE), 100);
        Recipes.barrelCompost(writer, "pumpkin_pie", MKRecipeProvider.ingredient((ItemLike)Items.PUMPKIN_PIE), 150);
        Recipes.barrelCompost(writer, "bread", MKRecipeProvider.ingredient((ItemLike)Items.BREAD), 125);
        Recipes.barrelCompost(writer, "mushroom_stew", MKRecipeProvider.ingredient((ItemLike)Items.MUSHROOM_STEW), 200);
        Recipes.barrelCompost(writer, "suspicious_stew", MKRecipeProvider.ingredient((ItemLike)Items.SUSPICIOUS_STEW), 200);
        Recipes.barrelCompost(writer, "beetroot_soup", MKRecipeProvider.ingredient((ItemLike)Items.BEETROOT_SOUP), 150);
        Recipes.barrelCompost(writer, "rabbit_stew", MKRecipeProvider.ingredient((ItemLike)Items.RABBIT_STEW), 200);
        Recipes.barrelCompost(writer, "golden_apples", MKRecipeProvider.ingredient((ItemLike[])new ItemLike[]{Items.GOLDEN_APPLE, Items.ENCHANTED_GOLDEN_APPLE}), 1000);
        Recipes.barrelCompost(writer, "golden_carrot", MKRecipeProvider.ingredient((ItemLike[])new ItemLike[]{Items.GOLDEN_CARROT, Items.GOLDEN_CARROT}), 500);
    }

    private static void barrelCompost(Consumer<FinishedRecipe> writer, String id, Ingredient ingredient, int volume) {
        writer.accept(new FinishedBarrelCompostRecipe(Recipes.modLoc("barrel_compost/" + id), ingredient, volume));
    }

    private static void barrelMixingRecipes(Consumer<FinishedRecipe> writer) {
        Recipes.barrelMixing(writer, MKRecipeProvider.ingredient((ItemLike)((ItemLike)EItems.DUST.get())), (Fluid)Fluids.WATER, Items.CLAY);
        Recipes.barrelMixing(writer, MKRecipeProvider.ingredient((ItemLike)Items.MILK_BUCKET), (Fluid)Fluids.WATER, Items.SLIME_BLOCK);
        Recipes.barrelMixing(writer, "_from_porcelain_bucket", MKRecipeProvider.ingredient((ItemLike)((ItemLike)EItems.PORCELAIN_MILK_BUCKET.get())), (Fluid)Fluids.WATER, Items.SLIME_BLOCK);
        Recipes.barrelFluidMixing(writer, (Fluid)Fluids.WATER, (Fluid)ForgeMod.MILK.get(), Items.SLIME_BLOCK, true);
        Recipes.barrelMixing(writer, MKRecipeProvider.ingredient((ItemLike)Items.SNOWBALL), (Fluid)Fluids.WATER, Items.ICE);
        Recipes.barrelFluidMixing(writer, (Fluid)Fluids.WATER, (Fluid)Fluids.LAVA, Items.STONE, false);
        Recipes.barrelFluidMixing(writer, (Fluid)EFluids.WITCH_WATER.get(), (Fluid)Fluids.LAVA, Items.NETHERRACK, true);
        Recipes.barrelFluidMixing(writer, (Fluid)Fluids.LAVA, (Fluid)EFluids.WITCH_WATER.get(), Items.BLACKSTONE, true);
        Recipes.barrelMixing(writer, MKRecipeProvider.ingredient((ItemLike)Items.GLOWSTONE_DUST), (Fluid)Fluids.LAVA, Items.END_STONE);
        Recipes.barrelFluidMixing(writer, (Fluid)Fluids.LAVA, (Fluid)Fluids.WATER, Items.OBSIDIAN, false);
        Recipes.barrelMixing(writer, MKRecipeProvider.ingredient((ItemLike)Items.SLIME_BALL), (Fluid)Fluids.LAVA, Items.MAGMA_CREAM);
        Recipes.barrelMixing(writer, MKRecipeProvider.ingredient((ItemLike)Items.SOUL_SAND), (Fluid)Fluids.LAVA, Items.SOUL_SOIL);
        Recipes.barrelMixing(writer, MKRecipeProvider.ingredient((ItemLike)Items.SAND), (Fluid)EFluids.WITCH_WATER.get(), Items.SOUL_SAND);
    }

    private static void barrelMixing(Consumer<FinishedRecipe> writer, Ingredient ingredient, Fluid fluidType, Item result) {
        Recipes.barrelMixing(writer, "", ingredient, fluidType, result);
    }

    private static void barrelMixing(Consumer<FinishedRecipe> writer, String suffix, Ingredient ingredient, Fluid fluidType, Item result) {
        writer.accept(new FinishedBarrelMixingRecipe(Recipes.modLoc("barrel_mixing/" + MKRecipeProvider.path((ItemLike)result) + suffix), ingredient, fluidType, 1000, result));
    }

    private static void barrelFluidMixing(Consumer<FinishedRecipe> writer, Fluid base, Fluid additive, Item result, boolean consumesAdditive) {
        writer.accept(new FinishedBarrelFluidMixingRecipe(Recipes.modLoc("barrel_fluid_mixing/" + MKRecipeProvider.path((ItemLike)result)), base, 1000, additive, result, consumesAdditive));
    }

    private static void fluidTransformationRecipes(Consumer<FinishedRecipe> writer) {
        writer.accept(new FinishedFluidTransformationRecipe(Recipes.modLoc("barrel_fluid_transformation/witch_water"), (Fluid)Fluids.WATER, (Fluid)EFluids.WITCH_WATER.get(), 2822231, BlockPredicate.singleBlock(Blocks.MYCELIUM), WeightedList.builder().add(50, Blocks.RED_MUSHROOM.defaultBlockState()).add(50, Blocks.BROWN_MUSHROOM.defaultBlockState()).build(), 1700));
    }

    static ResourceLocation modLoc(String path) {
        return new ResourceLocation("exdeorum", path);
    }

    static ICondition tagNotEmpty(TagKey<Item> tag) {
        return new NotCondition((ICondition)new TagEmptyCondition(tag.location()));
    }

    static ICondition modInstalled(String modid) {
        return new ModLoadedCondition(modid);
    }

    static ICondition modNotInstalled(String modid) {
        return new NotCondition(Recipes.modInstalled(modid));
    }

    static NumberProvider compressedMultiplier(NumberProvider resultAmount) {
        if (resultAmount instanceof BinomialDistributionGenerator) {
            BinomialDistributionGenerator binomial = (BinomialDistributionGenerator)resultAmount;
            return BinomialDistributionGenerator.binomial((int)((int)((ConstantValue)binomial.n).value * 7), (float)((ConstantValue)binomial.p).value);
        }
        throw new IllegalArgumentException("Unable to multiply type " + resultAmount.getClass());
    }
}

