/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.item;

import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;
import thedarkcolour.exdeorum.registry.EItems;

public class CrookItem
extends Item {
    private final float speed;

    public CrookItem(Item.Properties properties, float speed) {
        super(properties);
        this.speed = speed;
    }

    public float getDestroySpeed(ItemStack pStack, BlockState pState) {
        return pState.is(BlockTags.LEAVES) ? this.speed : 1.0f;
    }

    public boolean mineBlock(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity living) {
        if (!level.isClientSide && state.getDestroySpeed((BlockGetter)level, pos) != 0.0f) {
            stack.hurtAndBreak(1, living, p_40992_ -> p_40992_.broadcastBreakEvent(EquipmentSlot.MAINHAND));
        }
        return true;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment == Enchantments.BLOCK_FORTUNE || enchantment == Enchantments.UNBREAKING || enchantment == Enchantments.BLOCK_EFFICIENCY;
    }

    public boolean isValidRepairItem(ItemStack tool, ItemStack material) {
        if (this == EItems.BONE_CROOK.get()) {
            return material.is(Tags.Items.BONES);
        }
        return material.is(ItemTags.PLANKS);
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player playerIn, LivingEntity living, InteractionHand hand) {
        Vec3 difference = playerIn.position().subtract(living.position());
        double distance = difference.horizontalDistance();
        double scalarX = difference.x / distance;
        double scalarZ = difference.z / distance;
        double dx = scalarX * 1.5;
        double dz = scalarZ * 1.5;
        living.setDeltaMovement(living.getDeltaMovement().add(dx, 0.0, dz));
        return InteractionResult.SUCCESS;
    }
}

