/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.item;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.Set;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.common.util.Lazy;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.exdeorum.recipe.RecipeUtil;
import thedarkcolour.exdeorum.recipe.hammer.HammerRecipe;
import thedarkcolour.exdeorum.registry.EItems;

public class HammerItem
extends DiggerItem {
    public static Lazy<Set<Block>> validBlocks = Lazy.of(() -> HammerItem.computeValidBlocks(RecipeUtil.getCachedHammerRecipes()));

    public HammerItem(Tier tier, Item.Properties properties) {
        super(1.0f, -2.8f, tier, null, properties);
    }

    public static Set<Block> computeValidBlocks(Collection<? extends HammerRecipe> hammerRecipes) {
        ObjectOpenHashSet validBlocks = new ObjectOpenHashSet(hammerRecipes.size());
        for (HammerRecipe hammerRecipe : hammerRecipes) {
            for (ItemStack item : hammerRecipe.getIngredient().getItems()) {
                Item item2 = item.getItem();
                if (!(item2 instanceof BlockItem)) continue;
                BlockItem blockItem = (BlockItem)item2;
                validBlocks.add((Object)blockItem.getBlock());
            }
        }
        return validBlocks;
    }

    public static void refreshValidBlocks() {
        validBlocks = Lazy.of(() -> HammerItem.computeValidBlocks(RecipeUtil.getCachedHammerRecipes()));
    }

    protected Set<Block> getValidBlocks() {
        return (Set)validBlocks.get();
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        return this.getValidBlocks().contains(state.getBlock()) ? this.speed : 1.0f;
    }

    public boolean isCorrectToolForDrops(BlockState state) {
        if (TierSortingRegistry.isTierSorted((Tier)this.getTier())) {
            return TierSortingRegistry.isCorrectTierForDrops((Tier)this.getTier(), (BlockState)state) && this.getValidBlocks().contains(state.getBlock());
        }
        int i = this.getTier().getLevel();
        if (i < 3 && state.is(BlockTags.NEEDS_DIAMOND_TOOL)) {
            return false;
        }
        if (i < 2 && state.is(BlockTags.NEEDS_IRON_TOOL)) {
            return false;
        }
        return (i >= 1 || !state.is(BlockTags.NEEDS_STONE_TOOL)) && this.getValidBlocks().contains(state.getBlock());
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return this.getValidBlocks().contains(state.getBlock()) && TierSortingRegistry.isCorrectTierForDrops((Tier)this.getTier(), (BlockState)state);
    }

    public int getBurnTime(ItemStack stack, @Nullable RecipeType<?> recipeType) {
        return this == EItems.WOODEN_HAMMER.get() ? 200 : 0;
    }
}

