/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.loot;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import thedarkcolour.exdeorum.recipe.RecipeUtil;
import thedarkcolour.exdeorum.recipe.crook.CrookRecipe;

public class CrookLootModifier
extends LootModifier {
    public static final Codec<CrookLootModifier> CODEC = RecordCodecBuilder.create(inst -> LootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, CrookLootModifier::new));

    protected CrookLootModifier(LootItemCondition[] conditions) {
        super(conditions);
    }

    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        BlockState state = (BlockState)context.getParamOrNull(LootContextParams.BLOCK_STATE);
        ItemStack stack = (ItemStack)context.getParamOrNull(LootContextParams.TOOL);
        if (state != null && stack != null) {
            RandomSource rand = context.getRandom();
            if (stack.getEnchantmentLevel(Enchantments.SILK_TOUCH) == 0) {
                int fortune = stack.getEnchantmentLevel(Enchantments.BLOCK_FORTUNE);
                int rolls = Math.max(1, Mth.ceil((float)((float)fortune / 3.0f)));
                for (CrookRecipe recipe : RecipeUtil.getCrookRecipes(state)) {
                    for (int i = 0; i < rolls; ++i) {
                        if (!(rand.nextFloat() < recipe.chance())) continue;
                        ItemStack result = new ItemStack((ItemLike)recipe.result(), 1);
                        result.setTag(recipe.getResultNbt());
                        generatedLoot.add((Object)result);
                    }
                }
                if (state.is(BlockTags.LEAVES)) {
                    ItemStack nonCrook = new ItemStack((ItemLike)Items.BARRIER);
                    nonCrook.setTag(stack.getTag());
                    for (int i = 0; i < rolls; ++i) {
                        generatedLoot.addAll(CrookLootModifier.reRollDrops(context, nonCrook, state));
                    }
                }
            }
        }
        return generatedLoot;
    }

    private static List<ItemStack> reRollDrops(LootContext context, ItemStack nonCrook, BlockState state) {
        LootParams.Builder builder = new LootParams.Builder(context.getLevel());
        builder.withParameter(LootContextParams.BLOCK_STATE, (Object)((BlockState)context.getParam(LootContextParams.BLOCK_STATE)));
        builder.withParameter(LootContextParams.TOOL, (Object)nonCrook);
        if (context.hasParam(LootContextParams.THIS_ENTITY)) {
            builder.withParameter(LootContextParams.THIS_ENTITY, (Object)((Entity)context.getParam(LootContextParams.THIS_ENTITY)));
        }
        if (context.hasParam(LootContextParams.ORIGIN)) {
            builder.withParameter(LootContextParams.ORIGIN, (Object)((Vec3)context.getParam(LootContextParams.ORIGIN)));
        }
        return state.getDrops(builder);
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

