/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.loot;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.exdeorum.recipe.RecipeUtil;
import thedarkcolour.exdeorum.recipe.hammer.HammerRecipe;

public class HammerLootModifier
extends LootModifier {
    public static final Codec<HammerLootModifier> CODEC = RecordCodecBuilder.create(inst -> LootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, HammerLootModifier::new));

    protected HammerLootModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        HammerRecipe recipe;
        Item itemForm;
        BlockState state = (BlockState)context.getParamOrNull(LootContextParams.BLOCK_STATE);
        if (state != null && (itemForm = state.getBlock().asItem()) != Items.AIR && (recipe = this.getRecipe(itemForm)) != null) {
            ObjectArrayList newLoot = new ObjectArrayList();
            int resultAmount = recipe.resultAmount.getInt(context);
            if (context.hasParam(LootContextParams.TOOL)) {
                ItemStack hammer = (ItemStack)context.getParam(LootContextParams.TOOL);
                resultAmount += HammerLootModifier.calculateFortuneBonus(hammer, context.getRandom(), resultAmount == 0);
            }
            if (resultAmount > 0) {
                ItemStack result = new ItemStack((ItemLike)recipe.result, resultAmount);
                result.setTag(recipe.getResultNbt());
                newLoot.add((Object)result);
            }
            return newLoot;
        }
        return generatedLoot;
    }

    @Nullable
    protected HammerRecipe getRecipe(Item itemForm) {
        return RecipeUtil.getHammerRecipe(itemForm);
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }

    public static int calculateFortuneBonus(ItemStack hammer, RandomSource rand, boolean zeroBaseDrops) {
        int fortune = hammer.getEnchantmentLevel(Enchantments.BLOCK_FORTUNE);
        if (fortune != 0) {
            float chance = rand.nextFloat();
            if (zeroBaseDrops ? chance < 0.06f * (float)fortune : chance < 0.03f * (float)fortune) {
                return 1;
            }
        }
        return 0;
    }
}

