/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import thedarkcolour.exdeorum.registry.ELootFunctions;

public class MachineLootFunction
extends LootItemConditionalFunction {
    protected MachineLootFunction(LootItemCondition[] conditions) {
        super(conditions);
    }

    protected ItemStack run(ItemStack stack, LootContext ctx) {
        BlockEntity blockEntity = (BlockEntity)ctx.getParamOrNull(LootContextParams.BLOCK_ENTITY);
        if (blockEntity != null) {
            blockEntity.saveToItem(stack);
        }
        return stack;
    }

    public LootItemFunctionType getType() {
        return (LootItemFunctionType)ELootFunctions.MACHINE.get();
    }

    public static LootItemConditionalFunction.Builder<?> machineLoot() {
        return LootItemConditionalFunction.simpleBuilder(MachineLootFunction::new);
    }

    public static class LootSerializer
    extends LootItemConditionalFunction.Serializer<MachineLootFunction> {
        public MachineLootFunction deserialize(JsonObject json, JsonDeserializationContext ctx, LootItemCondition[] conditions) {
            return new MachineLootFunction(conditions);
        }
    }
}

